/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Classes;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import groovy.jmx.builder.JmxBuilder;
import groovy.util.GroovyMBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class Mbeans {
    private static final Map<String, String> EMPTY = new HashMap<String, String>();
    private static Logger LOG = Logger.getLogger(Mbeans.class);
    private static final int JMX_PORT = 1099;
    private static final String JMX_HOST = "localhost";
    private static final String URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/eucalyptus";
    private static MBeanServer mbeanServer;
    private static JMXConnectorServer jmxServer;
    private static Registry rmiRegistry;
    private static JmxBuilder jmxBuilder;
    private static Map jmxProps;

    public static void init() {
        System.setProperty("euca.jmx.uri", URI);
        mbeanServer = ManagementFactory.getPlatformMBeanServer();
        jmxBuilder = new JmxBuilder();
        jmxBuilder.setDefaultJmxNameDomain("com.eucalyptus");
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            try {
                try {
                    rmiRegistry = LocateRegistry.createRegistry(1099);
                }
                catch (ExportException ex1) {
                    LOG.error((Object)ex1, (Throwable)ex1);
                    rmiRegistry = LocateRegistry.getRegistry(1099);
                }
            }
            catch (RemoteException ex1) {
                LOG.error((Object)ex1, (Throwable)ex1);
                throw BootstrapException.throwFatal(ex1.getMessage(), ex1);
            }
            try {
                jmxServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(URI), jmxProps, mbeanServer);
                jmxServer.start();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            catch (IOException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private static final MBeanServer mbeanServer() {
        return mbeanServer;
    }

    public static Set<String> listPropertyValues(String domain, String propertyKey, Map<String, String> properties) throws IllegalArgumentException {
        LinkedHashSet values = Sets.newLinkedHashSet();
        try {
            Hashtable<String, String> allProperties = new Hashtable<String, String>(properties);
            allProperties.put(propertyKey, "*");
            Set<ObjectName> objectNames = ManagementFactory.getPlatformMBeanServer().queryNames(ObjectName.getInstance(domain, allProperties), null);
            for (ObjectName name : objectNames) {
                values.add(name.getKeyProperty(propertyKey));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
        return values;
    }

    public static <T> T lookup(String domain, Map props, Class<T> type) throws NoSuchElementException {
        Hashtable<String, String> attributes = new Hashtable<String, String>(props);
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance(domain, attributes);
            T mbeanProxy = JMX.newMBeanProxy(server, objectName, type);
            return mbeanProxy;
        }
        catch (MalformedObjectNameException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException("Failed to lookup: " + type.getCanonicalName() + " named: " + domain + "=" + props.toString());
        }
        catch (NullPointerException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw new NoSuchElementException("Failed to lookup: " + type.getCanonicalName() + " named: " + domain + "=" + props.toString());
        }
    }

    public static void register(final Object obj) {
        if (jmxBuilder == null) {
            return;
        }
        Class<?> targetType = obj.getClass();
        if (targetType.isAnonymousClass()) {
            targetType = targetType.getSuperclass() != null ? targetType.getSuperclass() : targetType.getInterfaces()[0];
        }
        String exportString = "jmx.export{ bean(  target: obj,  name: obj.class.package.name+\":type=${obj.class.simpleName}\", desc: \"${obj.toString()}\" ) }";
        for (Class c : Classes.ancestors(targetType)) {
            File jmxConfig = SubDirectory.MANAGEMENT.getChildFile(c.getCanonicalName());
            if (!jmxConfig.exists()) continue;
            LOG.trace((Object)("Trying to read jmx config file: " + jmxConfig.getAbsolutePath()));
            try {
                exportString = Files.toString((File)jmxConfig, (Charset)Charset.defaultCharset());
                LOG.trace((Object)("Succeeded reading jmx config file: " + jmxConfig.getAbsolutePath()));
                break;
            }
            catch (IOException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        try {
            LOG.trace((Object)("Exporting MBean: " + obj));
            LOG.trace((Object)("Exporting MBean: " + exportString));
            List mbeans = (List)Groovyness.eval(exportString, new HashMap(){
                {
                    this.put("jmx", jmxBuilder);
                    this.put("obj", obj);
                }
            });
            for (GroovyMBean mbean : mbeans) {
                LOG.trace((Object)("MBean server: default=" + mbean.server().getDefaultDomain() + " all=" + Arrays.asList(mbean.server().getDomains())));
                LOG.trace((Object)("Exported MBean: " + mbean));
            }
        }
        catch (ScriptExecutionFailedException ex) {
            LOG.error((Object)("Exporting MBean failed: " + ex.getMessage()), (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)("Error after export MBean: " + ex.getMessage()), (Throwable)ex);
        }
    }

    static {
        jmxProps = new HashMap(){
            {
                this.put("jmx.remote.jndi.rebind", "true");
            }
        };
        Mbeans.init();
    }
}

