/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.records.Logs;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Intervals {
    private static final Pattern intervalPattern = Pattern.compile("(\\d+)(d|h|m|s|ms)?");
    private static final Map<String, TimeUnit> units = ImmutableMap.builder().put((Object)"d", (Object)TimeUnit.DAYS).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).build();

    public static long parse(@Nonnull String value) throws ParseException {
        return Intervals.parse(value, TimeUnit.MILLISECONDS);
    }

    public static long parse(@Nullable String value, long defaultValue) {
        if (value != null) {
            try {
                return Intervals.parse(value, TimeUnit.MILLISECONDS);
            }
            catch (ParseException e) {
                Logs.exhaust().debug((Object)e, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public static long parse(@Nonnull String value, @Nonnull TimeUnit defaultUnit) throws ParseException {
        String valueToParse = value.toLowerCase().trim();
        Matcher matcher = intervalPattern.matcher(valueToParse);
        if (matcher.matches()) {
            TimeUnit unit = matcher.group(2) != null ? units.get(matcher.group(2)) : defaultUnit;
            try {
                return unit.toMillis(Long.parseLong(matcher.group(1)));
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid interval: " + value, 0);
            }
        }
        throw new ParseException("Invalid interval: " + value, 0);
    }

    public static long parse(@Nullable String value, @Nonnull TimeUnit defaultUnit, long defaultValue) {
        if (value != null) {
            try {
                return Intervals.parse(value, defaultUnit);
            }
            catch (ParseException e) {
                Logs.exhaust().debug((Object)e, (Throwable)e);
            }
        }
        return defaultValue;
    }
}

