/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.records.Logs;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class Internets {
    private static Logger LOG = Logger.getLogger(Internets.class);
    private static final ConcurrentMap<String, InetAddress> localHostAddrList = new ConcurrentHashMap<String, InetAddress>();
    private static final InetAddress localHostAddr = Internets.determineLocalAddress();
    private static final String localId = Internets.localHostIdentifier();
    public static final Comparator<InetAddress> INET_ADDRESS_COMPARATOR = new Inet4AddressComparator();

    public static boolean isReachable(InetAddress addr, int timeoutMillis) throws IOException {
        return addr.isReachable(timeoutMillis);
    }

    private static InetAddress determineLocalAddress() {
        InetAddress laddr = null;
        LOG.info((Object)"Trying to determine local bind address based on cli (--bind-addr)... ");
        if (!BootstrapArgs.bindAddresses().isEmpty()) {
            laddr = Internets.lookupBindAddresses();
        }
        if (laddr == null) {
            LOG.info((Object)"Trying to determine local bind address based on the default route... ");
            laddr = Internets.lookupDefaultRoute();
        }
        if (laddr == null) {
            LOG.info((Object)"Trying to determine local bind address based on a netmask and scope maximizing heuristic... ");
            laddr = Internets.getAllInetAddresses().get(0);
        }
        LOG.info((Object)("==> Decided to use local bind address: " + laddr));
        System.setProperty("bind_addr", laddr.getHostAddress());
        System.setProperty("bind.address", laddr.getHostAddress());
        System.setProperty("jgroups.bind_addr", laddr.getHostAddress());
        System.setProperty("jgroups.udp.bind_addr", laddr.getHostAddress());
        return laddr;
    }

    private static InetAddress lookupDefaultRoute() {
        InetAddress laddr = null;
        try {
            String localAddr = (String)Groovyness.eval("hi=\"/sbin/ip -o route get 4.2.2.1\".execute();hi.waitFor();hi.text");
            String[] parts = localAddr.replaceAll(".*src *", "").split(" ");
            if (parts.length >= 1) {
                laddr = InetAddresses.forString((String)parts[0]);
            }
        }
        catch (ScriptExecutionFailedException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        return laddr;
    }

    private static InetAddress lookupBindAddresses() {
        InetAddress laddr = null;
        List<InetAddress> locallyBoundAddrs = Internets.getAllInetAddresses();
        boolean err = false;
        for (String addrStr : BootstrapArgs.bindAddresses()) {
            try {
                InetAddress next = InetAddress.getByName(addrStr);
                laddr = laddr == null ? next : laddr;
                NetworkInterface iface = NetworkInterface.getByInetAddress(next);
                if (locallyBoundAddrs.contains(InetAddress.getByName(addrStr))) {
                    localHostAddrList.put(next.getHostAddress(), next);
                    LOG.info((Object)("Identified local bind address: " + addrStr + " on interface " + iface.toString()));
                } else {
                    LOG.error((Object)("Failed to find specified --bind-addr=" + addrStr + " as it is not bound to a local interface.\n  Known addresses are: " + Joiner.on((String)", ").join(locallyBoundAddrs)));
                }
            }
            catch (UnknownHostException ex) {
                LOG.fatal((Object)("Invalid argument given for --bind-addr=" + addrStr + " " + ex.getMessage()));
                LOG.error((Object)ex, (Throwable)ex);
                err = true;
            }
            catch (SocketException ex) {
                LOG.fatal((Object)("Invalid argument given for --bind-addr=" + addrStr + " " + ex.getMessage()));
                LOG.error((Object)ex, (Throwable)ex);
                err = true;
            }
            if (!err) continue;
            System.exit(1);
        }
        return laddr;
    }

    public static InetAddress loopback() {
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException ex) {
            for (InetAddress i : Internets.getAllInetAddresses()) {
                if (!i.isLoopbackAddress()) continue;
                return i;
            }
            return Internets.localHostInetAddress();
        }
    }

    public static InetAddress any() {
        return InetAddresses.fromInteger((int)0);
    }

    public static InetAddress localHostInetAddress() {
        return localHostAddr;
    }

    public static String localHostAddress() {
        return Internets.localHostInetAddress().getHostAddress();
    }

    public static String localHostIdentifier() {
        return localId != null ? localId : Internets.localHostInetAddress().getHostAddress();
    }

    public static List<NetworkInterface> getNetworkInterfaces() {
        try {
            ArrayList ifaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ifaces = Lists.newArrayList((Iterable)Iterables.filter(ifaces, (Predicate)new Predicate<NetworkInterface>(){

                public boolean apply(NetworkInterface input) {
                    return !input.getName().contains("virbr0") && !input.getDisplayName().contains("virbr0");
                }
            }));
            Collections.sort(ifaces, new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface o1, NetworkInterface o2) {
                    short min1 = 0;
                    short min2 = 0;
                    for (InterfaceAddress ifaceAddr : o1.getInterfaceAddresses()) {
                        min1 = min1 > ifaceAddr.getNetworkPrefixLength() ? ifaceAddr.getNetworkPrefixLength() : min1;
                    }
                    for (InterfaceAddress ifaceAddr : o2.getInterfaceAddresses()) {
                        min2 = min2 > ifaceAddr.getNetworkPrefixLength() ? ifaceAddr.getNetworkPrefixLength() : min2;
                    }
                    return min2 - min1;
                }
            });
            return ifaces;
        }
        catch (SocketException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new RuntimeException("Getting list of network interfaces failed because of " + ex.getMessage(), ex);
        }
    }

    public static List<InetAddress> getAllInetAddresses() {
        ArrayList addrs = Lists.newArrayList();
        for (NetworkInterface iface : Internets.getNetworkInterfaces()) {
            InetAddress addr;
            try {
                if (iface.isPointToPoint()) {
                    continue;
                }
            }
            catch (SocketException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            for (InterfaceAddress iaddr : iface.getInterfaceAddresses()) {
                addr = iaddr.getAddress();
                if (!(addr instanceof Inet4Address) || addr.isMulticastAddress() || addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress() || addr.getHostAddress().contains("192.168.122.")) continue;
                addrs.add(addr);
            }
            for (InterfaceAddress iaddr : iface.getInterfaceAddresses()) {
                addr = iaddr.getAddress();
                if (!(addr instanceof Inet4Address) || addr.isMulticastAddress() || addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addrs.contains(addr.getHostAddress()) || addr.getHostAddress().contains("192.168.122.")) continue;
                addrs.add(addr);
            }
        }
        return addrs;
    }

    public static List<String> getAllAddresses() {
        return Lists.transform(Internets.getAllInetAddresses(), (Function)new Function<InetAddress, String>(){

            public String apply(InetAddress arg0) {
                return arg0.getHostAddress();
            }
        });
    }

    public static boolean testReachability(InetAddress inetAddr) {
        Parameters.checkParam("BUG: inetAddr is null.", inetAddr, Matchers.notNullValue());
        try {
            return inetAddr.isReachable(10000);
        }
        catch (IOException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    public static boolean testReachability(String addr) {
        Parameters.checkParam("BUG: addr is null.", addr, Matchers.notNullValue());
        try {
            InetAddress inetAddr = Inet4Address.getByName(addr);
            return Internets.testReachability(inetAddr);
        }
        catch (UnknownHostException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    public static InetAddress toAddress(URI uri) {
        Parameters.checkParam("BUG: uri is null.", uri, Matchers.notNullValue());
        try {
            return InetAddress.getByName(uri.getHost());
        }
        catch (UnknownHostException e) {
            throw Exceptions.toUndeclared((String)("Failed to resolve address for host: " + uri.getHost()), (Throwable[])new UnknownHostException[]{e});
        }
    }

    public static InetAddress toAddress(String maybeUrlMaybeHostname) {
        Parameters.checkParam("BUG: maybeUrlMaybeHostname is null.", maybeUrlMaybeHostname, Matchers.notNullValue());
        if (maybeUrlMaybeHostname.startsWith("vm:")) {
            maybeUrlMaybeHostname = "localhost";
        }
        URI uri = null;
        String hostAddress = null;
        try {
            uri = new URI(maybeUrlMaybeHostname);
            hostAddress = uri.getHost();
        }
        catch (URISyntaxException e) {
            hostAddress = maybeUrlMaybeHostname;
        }
        InetAddress ret = null;
        try {
            ret = InetAddress.getByName(hostAddress);
        }
        catch (UnknownHostException e1) {
            Exceptions.error("Failed to resolve address for host: " + maybeUrlMaybeHostname, e1);
        }
        return ret;
    }

    public static boolean testLocal(final InetAddress addr) {
        if (addr == null) {
            return true;
        }
        try {
            Boolean result = addr.isAnyLocalAddress();
            result = result | Iterables.any(Internets.getNetworkInterfaces(), (Predicate)new Predicate<NetworkInterface>(){

                public boolean apply(NetworkInterface arg0) {
                    return Iterables.any(arg0.getInterfaceAddresses(), (Predicate)new Predicate<InterfaceAddress>(){

                        public boolean apply(InterfaceAddress arg0) {
                            return arg0.getAddress().equals(addr);
                        }
                    });
                }
            });
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean testLocal(String address) {
        if (address == null) {
            return true;
        }
        try {
            InetAddress addr = InetAddress.getByName(address);
            return Internets.testLocal(addr);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)e.getMessage());
            return address.endsWith("Internal");
        }
    }

    public static boolean testGoodAddress(String address) throws Exception {
        InetAddress addr = InetAddress.getByName(address);
        LOG.debug((Object)(addr + " site=" + addr.isSiteLocalAddress()));
        LOG.debug((Object)(addr + " any=" + addr.isAnyLocalAddress()));
        LOG.debug((Object)(addr + " loop=" + addr.isLoopbackAddress()));
        LOG.debug((Object)(addr + " link=" + addr.isLinkLocalAddress()));
        LOG.debug((Object)(addr + " multi=" + addr.isMulticastAddress()));
        return addr.isSiteLocalAddress() || !addr.isAnyLocalAddress() && !addr.isLoopbackAddress() && !addr.isLinkLocalAddress() && !addr.isMulticastAddress();
    }

    private static void addAddress(Set<String> out, InetAddress addr) {
        if (addr instanceof Inet4Address && !addr.isMulticastAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress()) {
            out.add(addr.getCanonicalHostName());
            out.add(addr.getHostName());
            out.add(addr.getHostAddress());
        }
    }

    private static void addName(Set<String> out, String name) {
        try {
            for (InetAddress addr : InetAddress.getAllByName(name)) {
                Internets.addAddress(out, addr);
            }
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)("Failed to get addresses for name " + name + ": " + uhe), (Throwable)uhe);
        }
    }

    public static Set<String> getAllLocalHostNamesIps() {
        HashSet<String> results = new HashSet<String>();
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            Internets.addAddress(results, localHost);
            Internets.addName(results, localHost.getCanonicalHostName());
            Internets.addName(results, localHost.getHostName());
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)("Failed to get localhost: " + uhe), (Throwable)uhe);
        }
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            if (ifaces != null) {
                while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    Enumeration<InetAddress> addrs = iface.getInetAddresses();
                    if (addrs == null) continue;
                    while (addrs.hasMoreElements()) {
                        Internets.addAddress(results, addrs.nextElement());
                    }
                }
            }
        }
        catch (SocketException se) {
            LOG.error((Object)("Failed to get all network interfaces: " + se));
        }
        return results;
    }

    public static Optional<Cidr> getInterfaceCidr(InetAddress address) {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(address);
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                if (!address.equals(interfaceAddress.getAddress())) continue;
                short prefix = interfaceAddress.getNetworkPrefixLength();
                return Optional.of((Object)Cidr.fromAddress(address, prefix));
            }
        }
        catch (SocketException e) {
            LOG.debug((Object)("Error finding interface CIDR for address '" + address + "'"), (Throwable)e);
        }
        return Optional.absent();
    }

    public static Function<InetAddress, Optional<Cidr>> interfaceCidr() {
        return InetAddressToCidr.INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        for (String addr : Internets.getAllAddresses()) {
            System.out.println(addr);
        }
        for (String addr : Internets.getAllLocalHostNamesIps()) {
            System.out.println("Address: " + addr);
        }
        System.out.println("Testing if 192.168.7.8 is reachable: " + Internets.testReachability("192.168.7.8"));
    }

    private static enum InetAddressToCidr implements Function<InetAddress, Optional<Cidr>>
    {
        INSTANCE;


        public Optional<Cidr> apply(InetAddress address) {
            return Internets.getInterfaceCidr(address);
        }
    }

    public static class Inet4AddressComparator
    implements Comparator<InetAddress>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(InetAddress o1, InetAddress o2) {
            return o1.getHostAddress().compareTo(o2.getHostAddress());
        }
    }
}

