/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;

public interface FullName
extends Serializable {
    public static final String EMPTY = "";
    public static final String SEP_PATH = "/";
    public static final String SEP = ":";
    public static final String PREFIX = "arn:aws";
    public static final String NOBODY_ID = "d00d";
    public static final String SYSTEM_ID = Integer.toString(12648430, 2);
    public static final Function<String[], String> ASSEMBLE_PATH_PARTS = new Function<String[], String>(){

        public String apply(String[] pathParts) {
            StringBuilder rId = new StringBuilder();
            for (String pathPart : pathParts) {
                rId.append(FullName.SEP_PATH.substring(0, rId.length() == 0 ? 0 : 1)).append(pathPart);
            }
            return rId.toString();
        }
    };

    public String getUniqueId();

    public String getVendor();

    public String getRegion();

    public String getNamespace();

    public String getAuthority();

    public String getRelativeId();

    public String getPartition();

    public String toString();

    public int hashCode();

    public boolean equals(Object var1);

    public static class create {
        private Map<part, String> partMap = Maps.newHashMap();
        private part current = part.VENDOR;
        private final StringBuilder buf = new StringBuilder();

        create(String name) {
            this.buf.append(FullName.PREFIX).append(FullName.SEP).append(name).append(FullName.SEP);
            this.current = part.REGION;
        }

        public static create vendor(String name) {
            return new create(name);
        }

        public create service(String service) {
            return new create(service);
        }

        public create region(String region) {
            if (this.current.ordinal() != part.REGION.ordinal()) {
                throw new IllegalStateException("Attempt to set region when the current part is: " + (Object)((Object)this.current));
            }
            this.buf.append(region).append(FullName.SEP);
            this.current = part.NAMESPACE;
            this.partMap.put(part.REGION, region == null || region.length() == 0 ? FullName.EMPTY : region);
            return this;
        }

        public create accountId(String accountId) {
            try {
                return this.namespace(accountId);
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("Attempt to set accountId when the current part is: " + (Object)((Object)this.current));
            }
        }

        public create namespace(String namespace) {
            if (this.current.ordinal() != part.NAMESPACE.ordinal()) {
                throw new IllegalStateException("Attempt to set namespace when the current part is: " + (Object)((Object)this.current));
            }
            this.buf.append(namespace).append(FullName.SEP);
            this.current = part.RELATIVEID;
            this.partMap.put(part.NAMESPACE, namespace == null || namespace.length() == 0 ? FullName.EMPTY : namespace);
            return this;
        }

        public FullName end() {
            return this.relativeId(new String[0]);
        }

        public FullName relativeId(String ... relativePath) {
            StringBuilder rId;
            if (this.current.ordinal() == part.RELATIVEID.ordinal()) {
                rId = new StringBuilder();
                for (String s : relativePath) {
                    rId.append(s).append(FullName.SEP_PATH);
                }
            } else {
                throw new IllegalStateException("Attempt to set relative path when the current part is: " + (Object)((Object)this.current));
            }
            this.partMap.put(part.DONE, this.buf.toString());
            this.buf.append(rId.toString());
            this.partMap.put(part.RELATIVEID, rId.toString());
            this.current = part.DONE;
            return new FullName(){

                @Override
                public String getUniqueId() {
                    return this.getNamespace();
                }

                @Override
                public String getVendor() {
                    return (String)create.this.partMap.get((Object)part.VENDOR);
                }

                @Override
                public String getRegion() {
                    return (String)create.this.partMap.get((Object)part.REGION);
                }

                @Override
                public String getNamespace() {
                    return (String)create.this.partMap.get((Object)part.NAMESPACE);
                }

                @Override
                public String getAuthority() {
                    return (String)create.this.partMap.get((Object)part.DONE);
                }

                @Override
                public String getRelativeId() {
                    return (String)create.this.partMap.get((Object)part.RELATIVEID);
                }

                @Override
                public String getPartition() {
                    return (String)create.this.partMap.get((Object)part.REGION);
                }

                @Override
                public String toString() {
                    return create.this.buf.toString();
                }
            };
        }

        static enum part {
            VENDOR,
            REGION,
            NAMESPACE,
            RELATIVEID,
            DONE;

        }
    }
}

