/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.ws.WebServicesException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Exceptions {
    private static Logger LOG = Logger.getLogger(Exceptions.class);
    private static final List<String> DEFAULT_FILTER_MATCHES = Lists.newArrayList((Object[])new String[]{"com.eucalyptus", "edu.ucsb.eucalyptus"});
    private static final Integer DEFAULT_FILTER_MAX_DEPTH = 10;
    private static final StackTraceElement[] steArrayType = new StackTraceElement[1];
    private static final LoadingCache<Class, ErrorMessageBuilder> builders = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, ErrorMessageBuilder>(){

        public ErrorMessageBuilder load(Class input) {
            return new ErrorMessageBuilder(input);
        }
    });
    private static final Map<Class, LoadingCache<Class, String>> classErrorMessages = Maps.newConcurrentMap();

    public static WebServicesException notFound(String message, Throwable ... t) {
        if (Logs.isExtrrreeeme() && t != null && t.length > 0) {
            return new ServiceDispatchException(message + "\n" + Exceptions.string(message, t[0]));
        }
        return new ServiceDispatchException(message);
    }

    private static <T> Function<T, String> toStringFunction() {
        return ToString.INSTANCE;
    }

    public static <T> Predicate<StackTraceElement> stackTraceElementFilter(List<String> patterns) {
        Function<T, String> toString = Exceptions.toStringFunction();
        return Predicates.compose(Exceptions.makeSteFilter(patterns), toString);
    }

    private static Predicate<String> makeSteFilter(List<String> patterns) {
        Predicate filter = Predicates.alwaysTrue();
        for (String f : patterns) {
            filter = Predicates.or((Predicate)filter, (Predicate)Predicates.containsPattern((String)f));
        }
        return filter;
    }

    public static <T extends Throwable> T maybeInterrupted(T t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return t;
    }

    public static List<Throwable> causes(Throwable ex) {
        return ExceptionCauses.INSTANCE.apply(ex);
    }

    public static <T extends Throwable> String string(String message, T ex) {
        return message + "\n" + Exceptions.string(ex);
    }

    public static <T extends Throwable> String string(T ex) {
        RuntimeException t = ex == null ? new RuntimeException() : ex;
        String allMessages = Exceptions.causeString(ex);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter p = new PrintWriter(os);
        p.println(allMessages);
        t.printStackTrace(p);
        p.flush();
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            p.print("Caused by: ");
            cause.printStackTrace(p);
        }
        p.close();
        return os.toString();
    }

    public static <T extends Throwable> String causeString(T ex) {
        return Joiner.on((String)"\nCaused by: ").join(Exceptions.causes(ex));
    }

    public static String getCauseMessage(Throwable throwable) {
        return (String)FluentIterable.from((Iterable)Lists.reverse(Exceptions.causes(throwable))).transform(Exceptions.message()).firstMatch(Predicates.notNull()).orNull();
    }

    public static <T extends Throwable> RuntimeException toUndeclared(String message, T ... exs) {
        RuntimeException ex = null;
        ex = exs != null && exs.length > 0 ? exs[0] : new RuntimeException(message);
        if (ex instanceof RuntimeException) {
            return ex;
        }
        if (ex instanceof ExecutionException) {
            if (ex.getCause() != null && RuntimeException.class.isAssignableFrom(ex.getCause().getClass())) {
                return (RuntimeException)ex.getCause();
            }
            return new RuntimeException(message, ex.getCause());
        }
        return new RuntimeException(message, ex);
    }

    public static RuntimeException toUndeclared(Throwable cause) {
        return Exceptions.toUndeclared((String)cause.getMessage(), (Throwable[])new Throwable[]{cause});
    }

    public static <T extends Throwable> RuntimeException rethrow(@Nonnull RuntimeException e, @Nonnull Class<T> cause) throws T {
        Exceptions.doRethrow(e, cause);
        throw e;
    }

    public static <T1 extends Throwable, T2 extends Throwable> RuntimeException rethrow(@Nonnull RuntimeException e, @Nonnull Class<T1> cause1, @Nonnull Class<T2> cause2) throws T1, T2 {
        Exceptions.doRethrow(e, cause1);
        Exceptions.doRethrow(e, cause2);
        throw e;
    }

    public static <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> RuntimeException rethrow(@Nonnull RuntimeException e, @Nonnull Class<T1> cause1, @Nonnull Class<T2> cause2, @Nonnull Class<T3> cause3) throws T1, T2, T3 {
        Exceptions.doRethrow(e, cause1);
        Exceptions.doRethrow(e, cause2);
        Exceptions.doRethrow(e, cause3);
        throw e;
    }

    private static <T extends Throwable> void doRethrow(@Nonnull RuntimeException e, @Nonnull Class<T> cause) throws T {
        if (e.getCause() != null && cause.isAssignableFrom(e.getCause().getClass())) {
            throw (Throwable)cause.cast(e.getCause());
        }
    }

    public static <T extends Throwable> void findAndRethrow(@Nonnull Throwable e, @Nonnull Class<T> cause) throws T {
        Exceptions.doFindAndRethrow(e, cause);
    }

    public static <T1 extends Throwable, T2 extends Throwable> void findAndRethrow(@Nonnull Throwable e, @Nonnull Class<T1> cause1, @Nonnull Class<T2> cause2) throws T1, T2 {
        Exceptions.doFindAndRethrow(e, cause1);
        Exceptions.doFindAndRethrow(e, cause2);
    }

    public static <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> void findAndRethrow(@Nonnull Throwable e, @Nonnull Class<T1> cause1, @Nonnull Class<T2> cause2, @Nonnull Class<T3> cause3) throws T1, T2, T3 {
        Exceptions.doFindAndRethrow(e, cause1);
        Exceptions.doFindAndRethrow(e, cause2);
        Exceptions.doFindAndRethrow(e, cause3);
    }

    private static <T extends Throwable> void doFindAndRethrow(@Nonnull Throwable e, @Nonnull Class<T> causeClass) throws T {
        T cause = Exceptions.findCause(e, causeClass);
        if (cause != null) {
            throw cause;
        }
    }

    public static <T extends Throwable> T filterStackTrace(T ex) {
        ex.setStackTrace(Exceptions.filterStackTraceElements(ex, DEFAULT_FILTER_MATCHES).toArray(steArrayType));
        return ex;
    }

    public static Collection<StackTraceElement> filterStackTraceElements(Throwable ex) {
        return Exceptions.filterStackTraceElements(ex, DEFAULT_FILTER_MATCHES);
    }

    private static Collection<StackTraceElement> filterStackTraceElements(Throwable ex, List<String> patterns) {
        Predicate<StackTraceElement> filter = Exceptions.stackTraceElementFilter(patterns);
        return Collections2.filter(Arrays.asList(ex.getStackTrace()), filter);
    }

    public static RuntimeException trace(String message) {
        return Exceptions.trace(new RuntimeException(message));
    }

    public static <T extends Throwable> T trace(T t) {
        return Exceptions.trace(t.getMessage(), t);
    }

    public static <T extends Throwable> T trace(String message, T t) {
        RuntimeException filtered = new RuntimeException(t.getMessage());
        filtered.setStackTrace(Exceptions.filterStackTraceElements(t).toArray(steArrayType));
        LOG.info((Object)message);
        LOG.trace((Object)message, (Throwable)filtered);
        return t;
    }

    public static RuntimeException error(String message) {
        return Exceptions.error(new RuntimeException(message));
    }

    public static <T extends Throwable> T error(T t) {
        return Exceptions.error(t.getMessage(), t);
    }

    public static <T extends Throwable> T error(String message, T t) {
        RuntimeException filtered = new RuntimeException(message);
        filtered.setStackTrace(Exceptions.filterStackTraceElements(t).toArray(steArrayType));
        LOG.error((Object)message, (Throwable)filtered);
        return t;
    }

    public static <T extends Throwable> boolean isCausedBy(Throwable ex, Class<T> class1) {
        return Exceptions.findCause(ex, class1) != null;
    }

    public static Throwable unwrapCause(Throwable ex) {
        return (Throwable)Iterables.find(Exceptions.causes(ex), (Predicate)FilterCauses.INSTANCE, (Object)ex);
    }

    public static <T extends Throwable> T findCause(Throwable ex, Class<T> class1) {
        try {
            return (T)((Throwable)Iterables.find(Exceptions.causes(ex), (Predicate)Predicates.instanceOf(class1)));
        }
        catch (NoSuchElementException ex1) {
            return null;
        }
    }

    public static RuntimeException noSuchElement(String message, Throwable ... t) {
        if (Logs.isExtrrreeeme() && t != null && t.length > 0) {
            return new NoSuchElementException(message + "\n" + Exceptions.string(message, t[0]));
        }
        return new NoSuchElementException(message);
    }

    public static ErrorMessageBuilder builder(Class<?> type) {
        return (ErrorMessageBuilder)builders.getUnchecked(type);
    }

    public static Function<Throwable, String> message() {
        return ThrowableToMessageTransform.INSTANCE;
    }

    @Bootstrap.Discovery(value={Function.class}, annotations={ErrorMessages.class}, priority=-0.1)
    public static enum ErrorMessageDiscovery implements Predicate<Class>
    {
        INSTANCE;


        public boolean apply(Class input) {
            if (Function.class.isAssignableFrom(input) && Ats.from(input).has(ErrorMessages.class)) {
                try {
                    ErrorMessages annote = Ats.from(input).get(ErrorMessages.class);
                    Function errorFunction = (Function)Classes.builder(input).newInstance();
                    LoadingCache errorMap = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build(CacheLoader.from((Function)errorFunction));
                    classErrorMessages.put(annote.value(), errorMap);
                    return true;
                }
                catch (UndeclaredThrowableException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return false;
                }
            }
            Bootstrap.Discovery discovery = Ats.from(ErrorMessageDiscovery.class).get(Bootstrap.Discovery.class);
            LOG.error((Object)("Annotated Discovery supplied class argument that does not conform to one of: value()=" + discovery.value() + " (assignable types) or annotations()=" + discovery.annotations()));
            return false;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ErrorMessages {
        public Class<?> value();
    }

    private static enum ThrowableToMessageTransform implements Function<Throwable, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nullable Throwable throwable) {
            return throwable == null ? null : throwable.getMessage();
        }
    }

    public static class ErrorMessageBuilder {
        private Class type;
        private LoadingCache<Class, String> map;

        public ErrorMessageBuilder(Class input) {
            this.type = input;
            this.map = (LoadingCache)classErrorMessages.get(this.type);
        }

        private boolean hasMessage(Class<? extends Throwable> ex) {
            if (this.map != null) {
                return this.map.getUnchecked(ex) != null;
            }
            return false;
        }

        private String getMessage(Class<? extends Throwable> ex) {
            return (String)((LoadingCache)classErrorMessages.get(this.type)).getUnchecked(ex);
        }

        public ExceptionBuilder exception(Throwable ex) {
            return new ExceptionBuilder().exception(ex.getClass());
        }

        public class ExceptionBuilder {
            private String extraMessage;
            private Object[] fArgs;
            private String message;
            private Class<? extends Throwable> ex;
            private String unknownMessage;
            private String fstring;

            public ExceptionBuilder exception(Class<? extends Throwable> ex) {
                this.ex = ex;
                return this;
            }

            public ExceptionBuilder message(String message, Object[] formatArgs) {
                this.message = message;
                this.fArgs = formatArgs;
                return this;
            }

            public ExceptionBuilder append(String appendedMessage) {
                this.extraMessage = appendedMessage;
                return this;
            }

            public ExceptionBuilder unknownException(String unknownExceptionMessage) {
                this.unknownMessage = unknownExceptionMessage;
                return this;
            }

            public String build() {
                if (ErrorMessageBuilder.this.hasMessage(this.ex)) {
                    try {
                        return String.format(this.fstring, this.fArgs) + ": " + ErrorMessageBuilder.this.getMessage(this.ex);
                    }
                    catch (IllegalFormatException ex1) {
                        LOG.error((Object)("Failed to format \"" + this.fstring + "\" with args: " + Arrays.asList(this.fArgs) + " because of: " + ex1.getMessage()), (Throwable)ex1);
                        return ErrorMessageBuilder.this.getMessage(this.ex);
                    }
                }
                return this.unknownMessage;
            }

            public ExceptionBuilder context(String format, Object ... formatArgs) {
                this.fstring = format;
                this.fArgs = formatArgs;
                return this;
            }
        }
    }

    static enum ExceptionCauses implements Function<Throwable, List<Throwable>>
    {
        INSTANCE;


        public List<Throwable> apply(Throwable input) {
            if (input == null || input.getClass().equals(Exception.class)) {
                return Lists.newArrayList();
            }
            ArrayList ret = Lists.newArrayList((Object[])new Throwable[]{input});
            ret.addAll(this.apply(input.getCause()));
            return ret;
        }
    }

    static enum FilterCauses implements Predicate<Throwable>
    {
        INSTANCE;

        private static final Set<Class<? extends Exception>> filtered;

        public boolean apply(Throwable input) {
            return !filtered.contains(input.getClass());
        }

        static {
            filtered = Sets.newHashSet((Object[])new Class[]{UndeclaredThrowableException.class, RuntimeException.class, ExecutionException.class});
        }
    }

    static enum ToString implements Function<Object, String>
    {
        INSTANCE;


        public String apply(Object o) {
            return o == null ? "null" : o.toString();
        }
    }
}

