/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

@ConfigurableClass(root="bootstrap.notifications.email", description="Parameters controlling the delivery of notification emails.")
public class Emails {
    private static Logger LOG = Logger.getLogger(Emails.class);
    @ConfigurableField(description="SMTP host to use when sending email.  If unset, the following values are tried: 1) the value of the 'mail.smtp.host' system property, 2) localhost, 3) mailhost.")
    public static String EMAIL_SMTP_HOST = null;
    @ConfigurableField(description="SMTP port to use when sending email.  Defaults to 25")
    public static Integer EMAIL_SMTP_PORT = 25;

    private static Address validate(String emailAddress, String emailName) {
        if (emailAddress != null) {
            try {
                InternetAddress addr = new InternetAddress(emailAddress, emailName);
                addr.validate();
                return addr;
            }
            catch (AddressException ex) {
                throw new IllegalArgumentException("Provided address could not be validated: " + (emailName != null ? emailName : "") + " <" + emailAddress + ">", ex);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("Provided address could not be validated: " + (emailName != null ? emailName : "") + " <" + emailAddress + ">", ex);
            }
        }
        throw new IllegalArgumentException("Address must be not-null.");
    }

    public static void send(String from, String to, String subject, String content) {
        Emails.send(from, null, to, subject, content);
    }

    public static void send(String from, String fromName, String to, String subject, String content) {
        Address fromAddress = Emails.validate(from, fromName);
        Address toAddress = Emails.validate(to, null);
        Properties properties = new Properties(System.getProperties());
        for (SessionProperties p : SessionProperties.values()) {
            properties.setProperty(p.getPropertyName(), p.getPropertyValue());
        }
        try {
            Emails.doSend(subject, content, fromAddress, toAddress, properties);
        }
        catch (MessagingException ex) {
            try {
                properties.setProperty(SessionProperties.MAIL_SMTP_HOST.getPropertyName(), "mailhost");
                Emails.doSend(subject, content, fromAddress, toAddress, properties);
            }
            catch (MessagingException ex1) {
                LOG.error((Object)ex1, (Throwable)ex1);
            }
        }
    }

    private static void doSend(String subject, String content, Address fromAddress, Address toAddress, Properties properties) throws MessagingException {
        Session session = Session.getDefaultInstance((Properties)properties);
        MimeMessage message = new MimeMessage(session);
        message.setSubject(subject);
        message.setText(content);
        message.setFrom(fromAddress);
        message.setRecipient(Message.RecipientType.TO, toAddress);
        Transport.send((Message)message);
    }

    static enum SessionProperties {
        MAIL_SMTP_HOST{

            @Override
            public String getPropertyValue() {
                if (EMAIL_SMTP_HOST != null) {
                    return EMAIL_SMTP_HOST;
                }
                if (System.getProperty(this.getPropertyName()) != null) {
                    return System.getProperty(this.getPropertyName());
                }
                return "localhost";
            }
        }
        ,
        MAIL_SMTP_PORT(String.valueOf(25)){

            @Override
            public String getPropertyValue() {
                if (EMAIL_SMTP_PORT != null) {
                    return String.valueOf(EMAIL_SMTP_PORT);
                }
                return super.getPropertyValue();
            }
        }
        ,
        MAIL_TRANSPORT_PROTOCOL("smtp"),
        MAIL_DEBUG(String.valueOf(true));

        private final String value;

        private SessionProperties() {
            this.value = null;
        }

        private SessionProperties(String value) {
            this.value = value;
        }

        public String getPropertyValue() {
            return this.value;
        }

        public final String getPropertyName() {
            return this.name().replace("_", ".").toLowerCase();
        }
    }
}

