/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DispatchingClient<MT extends BaseMessage, CT extends ComponentId> {
    @Nullable
    private final String userId;
    private final Class<CT> componentIdClass;
    private ServiceConfiguration configuration;

    public DispatchingClient(@Nullable String userId, @Nonnull Class<CT> componentIdClass) {
        this.userId = userId;
        this.componentIdClass = componentIdClass;
    }

    public DispatchingClient(@Nonnull Class<CT> componentIdClass) {
        this(null, componentIdClass);
    }

    public void init() throws DispatchingClientException {
        try {
            this.configuration = Topology.lookup(this.componentIdClass, new Partition[0]);
        }
        catch (NoSuchElementException e) {
            throw new DispatchingClientException(e);
        }
    }

    public <REQ extends MT, RES extends MT> void dispatch(REQ request, Callback.Checked<RES> callback) {
        this.dispatch(request, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <REQ extends MT, RES extends MT> void dispatch(REQ request, final Callback.Checked<RES> callback, final @Nullable Runnable then) {
        ((BaseMessage)request).setUserId(this.userId);
        ((BaseMessage)request).markPrivileged();
        try {
            final CheckedListenableFuture future = AsyncRequests.dispatch(this.configuration, request);
            future.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        callback.fire(future.get());
                    }
                    catch (InterruptedException e) {
                        callback.fireException(e);
                    }
                    catch (ExecutionException e) {
                        callback.fireException(e.getCause());
                    }
                    finally {
                        if (then != null) {
                            then.run();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                callback.fireException(e);
            }
            finally {
                if (then != null) {
                    then.run();
                }
            }
        }
    }

    public static final class DispatchingClientException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DispatchingClientException(String message) {
            super(message);
        }

        public DispatchingClientException(String message, Throwable cause) {
            super(message, cause);
        }

        public DispatchingClientException(Throwable cause) {
            super(cause);
        }
    }
}

