/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.util.Consumer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Consumers {
    private static final Consumer<Object> DROPPING = new Consumer<Object>(){

        @Override
        public void accept(Object o) {
        }
    };

    public static Consumer<Object> drop() {
        return DROPPING;
    }

    public static <T> Consumer<T> atomic(final AtomicReference<T> reference) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                reference.set(t);
            }
        };
    }

    public static <T> Consumer<T> once(final Consumer<T> consumer) {
        return new Consumer<T>(){
            private final AtomicBoolean accepted = new AtomicBoolean(false);

            @Override
            public void accept(T t) {
                if (this.accepted.compareAndSet(false, true)) {
                    consumer.accept(t);
                }
            }
        };
    }

    public static <T> Consumer<T> forRunnable(final Runnable runnable) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                runnable.run();
            }
        };
    }

    public static <T> Runnable partial(final Consumer<T> consumer, final T value) {
        return new Runnable(){

            @Override
            public void run() {
                consumer.accept(value);
            }
        };
    }
}

