/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.util.NonNullFunction;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionUtils {
    public static <T> void each(Iterable<T> iterable, Function<? super T, ?> function) {
        Iterables.size((Iterable)Iterables.transform(iterable, function));
    }

    public static <T> void each(Iterable<T> iterable, Predicate<? super T> predicate) {
        CollectionUtils.each(iterable, Functions.forPredicate(predicate));
    }

    @Nonnull
    public static <T> FluentIterable<T> fluent(@Nullable Iterable<T> iterable) {
        return FluentIterable.from(iterable == null ? Collections.emptyList() : iterable);
    }

    public static <CIT, CT extends Collection<? super CIT>> Predicate<CT> contains(final CIT item) {
        return new Predicate<CT>(){

            public boolean apply(@Nullable CT collection) {
                return collection != null && collection.contains(item);
            }
        };
    }

    public static <T, PT> Predicate<T> propertyPredicate(PT propertyValue, Function<T, PT> propertyFunction) {
        return Predicates.compose((Predicate)Predicates.equalTo(propertyValue), propertyFunction);
    }

    public static <T, PT> Predicate<T> propertyPredicate(Collection<PT> propertyValues, Function<T, PT> propertyFunction) {
        return Predicates.compose((Predicate)Predicates.in(propertyValues), propertyFunction);
    }

    public static <T, PIT, PCT extends Collection<? super PIT>> Predicate<T> propertyContainsPredicate(PIT propertyValue, Function<T, PCT> propertyFunction) {
        return Predicates.compose(CollectionUtils.contains(propertyValue), propertyFunction);
    }

    public static <T> Function<T, List<T>> listUnit() {
        return new Function<T, List<T>>(){

            public List<T> apply(T t) {
                return t == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Object[]{t});
            }
        };
    }

    public static <T> Function<List<List<T>>, List<T>> listJoin() {
        return new Function<List<List<T>>, List<T>>(){

            public List<T> apply(List<List<T>> t) {
                return t == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)Iterables.concat(t));
            }
        };
    }

    public static <T> Function<T, Optional<T>> optionalUnit() {
        return new Function<T, Optional<T>>(){

            public Optional<T> apply(T t) {
                return Optional.fromNullable(t);
            }
        };
    }

    public static <T> Function<Optional<T>, T> optionalOrNull() {
        return new Function<Optional<T>, T>(){

            @Nullable
            public T apply(Optional<T> optional) {
                return optional == null ? null : optional.orNull();
            }
        };
    }

    public static <T> Function<Optional<T>, T> optionalOr(final T value) {
        return new Function<Optional<T>, T>(){

            @Nullable
            public T apply(Optional<T> optional) {
                return optional == null ? null : optional.or(value);
            }
        };
    }

    public static <F, T> Function<F, T> cast(Class<T> target) {
        return Functions.identity();
    }

    public static <T, I> T reduce(Iterable<? extends I> iterable, T initialValue, Function<T, Function<I, T>> reducer) {
        Object value = initialValue;
        for (I item : iterable) {
            value = ((Function)reducer.apply(value)).apply(item);
        }
        return value;
    }

    public static <I, K, V> Map<K, V> putAll(Iterable<? extends I> iterable, Map<K, V> targetMap, Function<? super I, K> keyFunction, Function<? super I, V> valueFunction) {
        if (iterable != null) {
            for (I item : iterable) {
                targetMap.put(keyFunction.apply(item), valueFunction.apply(item));
            }
        }
        return targetMap;
    }

    public static <I, K, V> Multimap<K, V> putAll(Iterable<? extends I> iterable, Multimap<K, V> targetMap, Function<? super I, K> keyFunction, Function<? super I, V> valueFunction) {
        if (iterable != null) {
            for (I item : iterable) {
                targetMap.put(keyFunction.apply(item), valueFunction.apply(item));
            }
        }
        return targetMap;
    }

    public static <K1, V1, K2, V2> Map<K2, V2> transform(Map<K1, V1> map, Map<K2, V2> targetMap, Function<? super K1, K2> keyFunction, Function<? super V1, V2> valueFunction) {
        if (map != null) {
            for (Map.Entry<K1, V1> entry : map.entrySet()) {
                Object targetKey = keyFunction.apply(entry.getKey());
                Object targetValue = valueFunction.apply(entry.getValue());
                if (targetKey == null || targetValue == null) continue;
                targetMap.put(targetKey, targetValue);
            }
        }
        return targetMap;
    }

    public static NonNullFunction<Integer, Function<Integer, Integer>> min() {
        return new NonNullFunction<Integer, Function<Integer, Integer>>(){

            @Override
            @Nonnull
            public Function<Integer, Integer> apply(final Integer integer1) {
                return new Function<Integer, Integer>(){

                    public Integer apply(Integer integer2) {
                        return Math.min(integer1, integer2);
                    }
                };
            }
        };
    }

    public static NonNullFunction<Long, Function<Long, Long>> lmin() {
        return new NonNullFunction<Long, Function<Long, Long>>(){

            @Override
            @Nonnull
            public Function<Long, Long> apply(final Long long1) {
                return new Function<Long, Long>(){

                    public Long apply(Long long2) {
                        return Math.min(long1, long2);
                    }
                };
            }
        };
    }

    public static <I> Function<Integer, Function<I, Integer>> count(final Predicate<I> evaluator) {
        return CollectionUtils.sum(new Function<I, Integer>(){

            public Integer apply(@Nullable I item) {
                return evaluator.apply(item) ? 1 : 0;
            }
        });
    }

    public static <I> Function<Integer, Function<I, Integer>> sum(final Function<I, Integer> evaluator) {
        return new Function<Integer, Function<I, Integer>>(){

            public Function<I, Integer> apply(final Integer sum) {
                return new Function<I, Integer>(){

                    public Integer apply(I item) {
                        return sum + (Integer)evaluator.apply(item);
                    }
                };
            }
        };
    }

    public static <F1, F2, T> NonNullFunction<F2, Function<F1, T>> flipCurried(final Function<F1, Function<F2, T>> curried) {
        return new NonNullFunction<F2, Function<F1, T>>(){

            @Override
            @Nonnull
            public Function<F1, T> apply(final @Nullable F2 f2) {
                return new Function<F1, T>(){

                    public T apply(@Nullable F1 f1) {
                        return ((Function)curried.apply(f1)).apply(f2);
                    }
                };
            }
        };
    }

    public static <T> Function<T, Function<T, T>> comparator(final Comparator<T> comparator) {
        return new Function<T, Function<T, T>>(){

            public Function<T, T> apply(final T t1) {
                return new Function<T, T>(){

                    public T apply(T t2) {
                        return comparator.compare(t1, t2) < 0 ? t1 : t2;
                    }
                };
            }
        };
    }
}

