/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Classes {
    public static Predicate<Class> assignableTo(final Class<?> type) {
        return new Predicate<Class>(){

            public boolean apply(Class input) {
                return input.isAssignableFrom(type);
            }
        };
    }

    public static Function<Object, String> simpleNameFunction() {
        return ClassNameToSimpleName.INSTANCE;
    }

    public static Function<Object, String> canonicalNameFunction() {
        return ClassNameToCanonicalName.INSTANCE;
    }

    public static Predicate<Class<?>> subclassOf(final Class<?> target) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> value) {
                return value != null && target.isAssignableFrom(value);
            }
        };
    }

    public static <T> InstanceBuilder<T> builder(Class<T> type) {
        return new InstanceBuilder<T>(type);
    }

    public static <T> T newInstance(Class<T> type, final Object ... args) {
        return new InstanceBuilder<T>(type){
            {
                super(x0);
                for (Object o : args) {
                    this.arg(o);
                }
            }
        }.newInstance();
    }

    public static Function<Object, List<Class>> ancestors() {
        return BreadthFirstTransitiveClosure.INSTANCE;
    }

    public static List<Class> ancestors(Object o) {
        return (List)Classes.ancestors().apply(o);
    }

    public static Function<Object, List<Class>> classAncestors() {
        return ClassBreadthFirstTransitiveClosure.INSTANCE;
    }

    public static List<Class> classAncestors(Object o) {
        return ClassBreadthFirstTransitiveClosure.INSTANCE.apply(o);
    }

    public static <T> Class<T> typeOf(Object obj) {
        return WhateverAsClass.INSTANCE.apply(obj);
    }

    public static Function<Object, List<Class>> interfaceAncestors() {
        return InterfaceBreadthFirstTransitiveClosure.INSTANCE;
    }

    public static List<Class> interfaceAncestors(Object o) {
        return (List)Classes.interfaceAncestors().apply(o);
    }

    public static List<Class> genericsToClasses(Object o) {
        return (List)Classes.genericsToClasses().apply(o);
    }

    private static Function<Object, List<Class>> genericsToClasses() {
        return GenericsBreadthFirstTransitiveClosure.INSTANCE;
    }

    static enum GenericsBreadthFirstTransitiveClosure implements Function<Object, List<Class>>
    {
        INSTANCE;


        public List<Class> apply(Object input) {
            ArrayList ret = Lists.newArrayList();
            Class inputClass = WhateverAsClass.INSTANCE.apply(input);
            if (!inputClass.isEnum()) {
                ret.addAll(GenericsBreadthFirstTransitiveClosure.processTypeForGenerics(inputClass.getGenericSuperclass()));
            }
            ret.addAll(GenericsBreadthFirstTransitiveClosure.processTypeForGenerics(inputClass.getGenericInterfaces()));
            return ret;
        }

        private static List<Class> processTypeForGenerics(Type ... types) {
            ArrayList ret = Lists.newArrayList();
            for (Type t : types) {
                if (t instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)t;
                    for (Type ptType : pt.getActualTypeArguments()) {
                        if (!(ptType instanceof Class)) continue;
                        ret.add((Class)ptType);
                    }
                }
                if (!(t instanceof Class)) continue;
                ret.addAll(GenericsBreadthFirstTransitiveClosure.processTypeForGenerics(((Class)t).getGenericSuperclass()));
                ret.addAll(GenericsBreadthFirstTransitiveClosure.processTypeForGenerics(((Class)t).getGenericInterfaces()));
            }
            return ret;
        }
    }

    static enum InterfaceBreadthFirstTransitiveClosure implements Function<Object, List<Class>>
    {
        INSTANCE;


        public List<Class> apply(Object input) {
            ArrayList ret = Lists.newArrayList();
            Class type = WhateverAsClass.INSTANCE.apply(input);
            if (type == Object.class || type == null) {
                return ret;
            }
            List<Class> superInterfaces = TransitiveClosureImplementedInterfaces.INSTANCE.apply(new Class[]{type});
            ret.addAll(superInterfaces);
            Object next = this.apply(type.getSuperclass());
            ret.addAll(next);
            return ret;
        }
    }

    static enum ClassBreadthFirstTransitiveClosure implements Function<Object, List<Class>>
    {
        INSTANCE;


        public List<Class> apply(Object input) {
            ArrayList ret = Lists.newArrayList();
            Class type = WhateverAsClass.INSTANCE.apply(input);
            if (type == Object.class || type == null) {
                return ret;
            }
            if (type.isInterface()) {
                return ret;
            }
            ret.add(type);
            Object next = this.apply(type.getSuperclass());
            ret.addAll(next);
            return ret;
        }
    }

    static enum BreadthFirstTransitiveClosure implements Function<Object, List<Class>>
    {
        INSTANCE;


        public List<Class> apply(Object input) {
            ArrayList ret = Lists.newArrayList();
            Class type = WhateverAsClass.INSTANCE.apply(input);
            if (type == Object.class || type == null) {
                return ret;
            }
            if (type.isInterface()) {
                ret.add(type);
                List<Class> superInterfaces = TransitiveClosureImplementedInterfaces.INSTANCE.apply(new Class[]{type});
                ret.addAll(superInterfaces);
                return ret;
            }
            ret.add(type);
            List<Class> superInterfaces = TransitiveClosureImplementedInterfaces.INSTANCE.apply(new Class[]{type});
            ret.addAll(superInterfaces);
            Object next = this.apply(type.getSuperclass());
            ret.addAll(next);
            return ret;
        }
    }

    static enum TransitiveClosureImplementedInterfaces implements Function<Class[], List<Class>>
    {
        INSTANCE;


        public List<Class> apply(Class[] types) {
            ArrayList ret = Lists.newArrayList();
            if (types.length == 0) {
                return ret;
            }
            for (Class t : types) {
                if (t == null || t == Object.class) continue;
                if (t.isInterface()) {
                    ret.add(t);
                }
                if (t.getInterfaces().length == 0) continue;
                List<Class> next = INSTANCE.apply(t.getInterfaces());
                ret.addAll(next);
            }
            return ret;
        }
    }

    static enum ParentClass implements Function<Class, Class>
    {
        INSTANCE;


        public Class apply(Class type) {
            return type.getSuperclass();
        }
    }

    static enum WhateverAsClass implements Function<Object, Class>
    {
        INSTANCE;


        public Class apply(Object o) {
            return o instanceof Class ? (Class<?>)o : (o != null ? o.getClass() : null);
        }
    }

    public static class InstanceBuilder<T> {
        private final Class<T> type;
        private final List<Class> argTypes = Lists.newArrayList();
        private final List<Object> args = Lists.newArrayList();
        private static final String errFstring = "Failed to create new instance of type %s with arguments %s (of types: %s) because of: ";

        public InstanceBuilder(Class<T> type) {
            this.type = type;
        }

        public InstanceBuilder<T> arg(Object arg) {
            if (arg == null) {
                throw new IllegalArgumentException("Cannot supply a null value argument w/o specifying the type.");
            }
            return this.arg(arg, arg.getClass());
        }

        public InstanceBuilder<T> arg(Object arg, Class type) {
            this.argTypes.add(type);
            this.args.add(arg);
            return this;
        }

        public T newInstance() throws UndeclaredThrowableException {
            if (this.type.isEnum()) {
                return this.type.getEnumConstants()[0];
            }
            try {
                Constructor<T> constructor = this.type.getConstructor(this.argTypes.toArray(new Class[0]));
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(this.args.toArray());
            }
            catch (InvocationTargetException ex) {
                throw new UndeclaredThrowableException(ex.getCause(), this.errorMessage(ex));
            }
            catch (NoSuchMethodException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            catch (Exception ex) {
                String message = InstanceBuilder.errorMessage(ex, errFstring, this.type.getClass(), this.args, this.argTypes);
                throw new InstantiationError(Exceptions.string(message, ex));
            }
        }

        private String errorMessage(InvocationTargetException ex) {
            return InstanceBuilder.errorMessage(ex.getCause(), errFstring, this.type.getClass(), this.args, this.argTypes);
        }

        public static String errorMessage(Throwable ex, String message, Object ... formatArgs) {
            return Exceptions.builder(Classes.class).exception(ex).unknownException("An unexpected error: ").context(errFstring, formatArgs).append(" because of: ").build();
        }
    }

    @Exceptions.ErrorMessages(value=Classes.class)
    static enum ErrorMessageMap implements Function<Class, String>
    {
        INSTANCE;

        private static final Map<Class, String> errorMessages;

        public String apply(Class input) {
            return errorMessages.get(input);
        }

        static {
            errorMessages = new ImmutableMap.Builder<Class, String>(){
                {
                    this.put(IllegalAccessException.class, "Either: the number of actual and formal parameters differ;an unwrapping conversion for primitive arguments fails; this constructor pertains to an enum type;a parameter value cannot be converted to the corresponding formal parameter type by a method invocation conversion.");
                    this.put(NoSuchMethodException.class, "");
                    this.put(SecurityException.class, "");
                    this.put(ExceptionInInitializerError.class, "");
                    this.put(InvocationTargetException.class, "");
                    this.put(InstantiationException.class, "");
                    this.put(IllegalArgumentException.class, "");
                }
            }.build();
        }
    }

    static enum ClassNameToCanonicalName implements Function<Object, String>
    {
        INSTANCE;


        public String apply(Object arg0) {
            return WhateverAsClass.INSTANCE.apply(arg0).getCanonicalName();
        }
    }

    static enum ClassNameToSimpleName implements Function<Object, String>
    {
        INSTANCE;


        public String apply(Object arg0) {
            return WhateverAsClass.INSTANCE.apply(arg0).getSimpleName();
        }
    }
}

