/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.Numbers;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedInteger;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Immutable;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class Cidr
implements Predicate<InetAddress>,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private final int ip;
    private final int prefix;
    private /* synthetic */ int $hash$code;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453165405698;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public Cidr(HashMap hashMap) {
        void args;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(args == null)) {
            if (args.get("ip") == null) {
                if (!(null == null)) {
                    Object var3_3 = null;
                    this.ip = DefaultTypeTransformation.intUnbox(var3_3);
                }
            } else {
                Object v = args.get("ip");
                this.ip = DefaultTypeTransformation.intUnbox(v);
            }
            if (args.get("prefix") == null) {
                if (!(null == null)) {
                    Object var5_5 = null;
                    this.prefix = DefaultTypeTransformation.intUnbox(var5_5);
                }
            } else {
                Object v = args.get("prefix");
                this.prefix = DefaultTypeTransformation.intUnbox(v);
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
            if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                if (!(this.$getStaticMetaClass() == null)) {
                    MetaClass metaClass2;
                    this.metaClass = metaClass2 = this.$getStaticMetaClass();
                }
            } else {
                MetaClass metaClass3;
                this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
            }
        }
    }

    public Cidr(int ip, int prefix) {
        this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", ip, "prefix", prefix}), HashMap.class));
    }

    public static Cidr of(int address, int prefix) {
        return new Cidr(address, prefix);
    }

    public static Cidr parse(String cidr) {
        Parameters.checkParam("cidr", cidr, Matchers.notNullValue());
        Iterable parts = Splitter.on((String)"/").trimResults().omitEmptyStrings().limit(2).split((CharSequence)cidr);
        String ipPart = (String)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)parts, (int)0), String.class);
        if (ipPart == null) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cidr}, new String[]{"Invalid cidr: ", ""}), String.class));
        }
        if (!InetAddresses.isInetAddress((String)ipPart)) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cidr}, new String[]{"Invalid cidr: ", ""}), String.class));
        }
        int ip = InetAddresses.coerceToInteger((InetAddress)InetAddresses.forString((String)ipPart));
        String prefixPart = (String)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)parts, (int)1), String.class);
        int prefix = 0;
        try {
            int n;
            prefix = n = prefixPart == null ? 32 : Integer.parseInt(prefixPart);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cidr}, new String[]{"Invalid prefix in cidr: ", ""}), String.class));
        }
        if (prefix < 0 || prefix > 32) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cidr}, new String[]{"Invalid prefix in cidr: ", ""}), String.class));
        }
        BigInteger ipBigInteger = new BigInteger(InetAddresses.forString((String)ipPart).getAddress());
        int i = 0;
        while (i < 32 - prefix) {
            if (ipBigInteger.testBit(i)) {
                Cidr suggestion = new Cidr(ip & Cidr.prefixMask(prefix), prefix);
                throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{cidr, suggestion}, new String[]{"Invalid address for prefix in cidr: ", " (try ", ")"}), String.class));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return new Cidr(ip, prefix);
    }

    public static Cidr fromAddress(InetAddress address, int prefix) {
        BigInteger addressBigInteger = new BigInteger(address.getAddress());
        int i = 0;
        while (i < 32 - prefix) {
            BigInteger bigInteger;
            addressBigInteger = bigInteger = addressBigInteger.clearBit(i);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return new Cidr(addressBigInteger.intValue(), prefix);
    }

    public String getIpAsText() {
        return InetAddresses.toAddrString((InetAddress)InetAddresses.fromInteger((int)this.ip));
    }

    public boolean contains(String ip) {
        Optional cidr = (Optional)ScriptBytecodeAdapter.castToType(Cidr.parse().apply(ip), Optional.class);
        return cidr.isPresent() ? this.contains(((Cidr)cidr.get()).getIp()) : false;
    }

    public boolean contains(int ip) {
        return (ip & Cidr.prefixMask(this.prefix)) == this.ip;
    }

    public boolean contains(Cidr cidr) {
        return (cidr.getIp() & Cidr.prefixMask(this.prefix)) == this.ip && cidr.getPrefix() >= this.prefix;
    }

    public Predicate<Cidr> contains() {
        return (Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Cidr cidr) {
                return ((Cidr)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), Cidr.class)).contains(cidr);
            }

            public Object call(Cidr cidr) {
                return this.doCall(cidr);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _contains_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _contains_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_contains_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _contains_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, Predicate.class);
    }

    public Predicate<Cidr> containedBy() {
        return (Predicate)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Cidr cidr) {
                return cidr.contains((Cidr)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Cidr.class));
            }

            public Object call(Cidr cidr) {
                return this.doCall(cidr);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _containedBy_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _containedBy_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_containedBy_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _containedBy_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, Predicate.class);
    }

    public Iterable<Cidr> split(int parts) {
        ArrayList cidrs = Lists.newArrayList();
        int bits = parts == 1 ? 0 : Numbers.log2(parts - 1) + 1;
        int maxParts = (int)Math.pow(2, bits);
        UnsignedInteger size = UnsignedInteger.fromIntBits((int)((int)Math.pow(2, 32 - this.prefix))).dividedBy(UnsignedInteger.fromIntBits((int)maxParts));
        int i = 0;
        while (i < parts) {
            cidrs.add(Cidr.of(UnsignedInteger.fromIntBits((int)this.getIp()).plus(size.times(UnsignedInteger.fromIntBits((int)i))).intValue(), this.prefix + bits));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return cidrs;
    }

    public static int prefixMask(int prefix) {
        if (prefix == 0) {
            return 0;
        }
        BitSet bitSet = new BitSet(32);
        bitSet.flip(32 - prefix, 32);
        byte[] bytes = Longs.toByteArray((long)BytecodeInterface8.lArrayGet((long[])bitSet.toLongArray(), (int)0));
        return Ints.fromBytes((byte)BytecodeInterface8.bArrayGet((byte[])bytes, (int)4), (byte)BytecodeInterface8.bArrayGet((byte[])bytes, (int)5), (byte)BytecodeInterface8.bArrayGet((byte[])bytes, (int)6), (byte)BytecodeInterface8.bArrayGet((byte[])bytes, (int)7));
    }

    public static NonNullFunction<String, Optional<Cidr>> parse() {
        return CidrParse.INSTANCE;
    }

    public static NonNullFunction<Cidr, Integer> prefix() {
        return CidrPrefix.INSTANCE;
    }

    public static NonNullFunction<String, Cidr> parseUnsafe() {
        return CidrParseUnsafe.INSTANCE;
    }

    public String toString() {
        return (String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{this.getIpAsText(), this.prefix}, new String[]{"", "/", ""}), String.class);
    }

    public boolean equals(Object o) {
        if (DefaultGroovyMethods.is((Object)this, (Object)o)) {
            return true;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(this.getClass(), o.getClass())) {
            return false;
        }
        Cidr cidr = (Cidr)ScriptBytecodeAdapter.castToType((Object)o, Cidr.class);
        if (this.ip != cidr.getIp()) {
            return false;
        }
        return !(this.prefix != cidr.getPrefix());
    }

    public int hashCode() {
        int n;
        int n2;
        int result = 0;
        result = n2 = this.ip;
        result = n = 31 * result + this.prefix;
        return result;
    }

    public boolean apply(@Nullable InetAddress inetAddress) {
        return inetAddress == null ? false : this.contains(InetAddresses.coerceToInteger((InetAddress)inetAddress));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Cidr.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    private int _hashCode() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
            int n;
            int _result = HashCodeHelper.initHash();
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ip"), (Object)this)) {
                int n2;
                _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"ip"));
            }
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"prefix"), (Object)this)) {
                int n3;
                _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"prefix"));
            }
            this.$hash$code = n = _result;
        }
        return this.$hash$code;
    }

    private boolean _equals(Object other) {
        if (other == null) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }
        if (ScriptBytecodeAdapter.compareNotEqual(Cidr.class, other.getClass())) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        Cidr otherTyped = (Cidr)ScriptBytecodeAdapter.castToType((Object)other, Cidr.class);
        if (!DefaultGroovyMethods.is((Object)this.getIp(), (Object)otherTyped.getIp())) {
            if (DefaultGroovyMethods.is((Object)this.getIp(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getIp(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIp(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)this.getIp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getIp(), (Object)otherTyped)) && this.getIp() != otherTyped.getIp()) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        if (!DefaultGroovyMethods.is((Object)this.getPrefix(), (Object)otherTyped.getPrefix())) {
            if (DefaultGroovyMethods.is((Object)this.getPrefix(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getPrefix(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getPrefix(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrefix(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)this.getPrefix(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getPrefix(), (Object)otherTyped)) && this.getPrefix() != otherTyped.getPrefix()) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
    }

    private String _toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("com.eucalyptus.util.Cidr(");
        if (InvokerHelper.getProperty((Object)this, (String)"ip") != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"ip"), (Object)this)) {
                _result.append("(this)");
            } else {
                _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"ip")));
            }
        }
        if (InvokerHelper.getProperty((Object)this, (String)"prefix") != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl3;
                $toStringFirst = bl3 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"prefix"), (Object)this)) {
                _result.append("(this)");
            } else {
                _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"prefix")));
            }
        }
        _result.append(")");
        return _result.toString();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Cidr.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, Cidr.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(Cidr.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        long l;
        long l2;
        Cidr.__$swapInit();
        __timeStamp__239_neverHappen1453165405698 = l2 = 0L;
        __timeStamp = l = 1453165405697L;
    }

    public final int getIp() {
        return this.ip;
    }

    public final int getPrefix() {
        return this.prefix;
    }

    public /* synthetic */ int this$2$_hashCode() {
        return this._hashCode();
    }

    public /* synthetic */ boolean this$2$_equals(Object object) {
        return this._equals(object);
    }

    public /* synthetic */ String this$2$_toString() {
        return this._toString();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(Cidr.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Cidr.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CidrParse
    extends Enum<CidrParse>
    implements NonNullFunction<String, Optional<Cidr>>,
    GroovyObject {
        public static final /* enum */ CidrParse INSTANCE;
        public static final CidrParse MIN_VALUE;
        public static final CidrParse MAX_VALUE;
        private static final /* synthetic */ CidrParse[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CidrParse(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.util.Cidr$CidrParse was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)__namedArgs);
        }

        public CidrParse() {
            this(new LinkedHashMap());
        }

        @Override
        public Optional<Cidr> apply(@Nullable String cidr) {
            Optional optional = Optional.of((Object)Cidr.parse(cidr));
            try {
                return optional;
            }
            catch (Exception IllegalArgumentException2) {
                Optional optional2 = Optional.absent();
                return optional2;
            }
        }

        public static final CidrParse[] values() {
            return (CidrParse[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), CidrParse[].class);
        }

        public /* synthetic */ CidrParse next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (CidrParse)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrParse.class);
        }

        public /* synthetic */ CidrParse previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (CidrParse)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrParse.class);
        }

        public static CidrParse valueOf(String name) {
            return (CidrParse)ScriptBytecodeAdapter.castToType((Object)Enum.valueOf(CidrParse.class, name), CidrParse.class);
        }

        public static final /* synthetic */ CidrParse $INIT(Object ... para) {
            CidrParse cidrParse;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, CidrParse.class)) {
                case -1348271900: {
                    CidrParse cidrParse2;
                    cidrParse = cidrParse2;
                    Object[] objectArray2 = objectArray;
                    cidrParse2 = new CidrParse();
                    break;
                }
                case -242181752: {
                    CidrParse cidrParse2;
                    cidrParse = cidrParse2;
                    Object[] objectArray2 = objectArray;
                    cidrParse2 = new CidrParse((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return cidrParse;
        }

        static {
            CidrParse cidrParse;
            CidrParse cidrParse2;
            CidrParse cidrParse3;
            CidrParse.__$swapInit();
            INSTANCE = cidrParse3 = CidrParse.$INIT("INSTANCE", 0);
            MIN_VALUE = cidrParse2 = INSTANCE;
            MAX_VALUE = cidrParse = INSTANCE;
            CidrParse[] cidrParseArray = new CidrParse[]{INSTANCE};
            $VALUES = cidrParseArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CidrParse.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CidrParse.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CidrParse.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CidrParseUnsafe
    extends Enum<CidrParseUnsafe>
    implements NonNullFunction<String, Cidr>,
    GroovyObject {
        public static final /* enum */ CidrParseUnsafe INSTANCE;
        public static final CidrParseUnsafe MIN_VALUE;
        public static final CidrParseUnsafe MAX_VALUE;
        private static final /* synthetic */ CidrParseUnsafe[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CidrParseUnsafe(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.util.Cidr$CidrParseUnsafe was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)__namedArgs);
        }

        public CidrParseUnsafe() {
            this(new LinkedHashMap());
        }

        @Override
        public Cidr apply(@Nullable String cidr) {
            return Cidr.parse(cidr);
        }

        public static final CidrParseUnsafe[] values() {
            return (CidrParseUnsafe[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), CidrParseUnsafe[].class);
        }

        public /* synthetic */ CidrParseUnsafe next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (CidrParseUnsafe)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrParseUnsafe.class);
        }

        public /* synthetic */ CidrParseUnsafe previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (CidrParseUnsafe)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrParseUnsafe.class);
        }

        public static CidrParseUnsafe valueOf(String name) {
            return (CidrParseUnsafe)ScriptBytecodeAdapter.castToType((Object)Enum.valueOf(CidrParseUnsafe.class, name), CidrParseUnsafe.class);
        }

        public static final /* synthetic */ CidrParseUnsafe $INIT(Object ... para) {
            CidrParseUnsafe cidrParseUnsafe;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, CidrParseUnsafe.class)) {
                case -1348271900: {
                    CidrParseUnsafe cidrParseUnsafe2;
                    cidrParseUnsafe = cidrParseUnsafe2;
                    Object[] objectArray2 = objectArray;
                    cidrParseUnsafe2 = new CidrParseUnsafe();
                    break;
                }
                case -242181752: {
                    CidrParseUnsafe cidrParseUnsafe2;
                    cidrParseUnsafe = cidrParseUnsafe2;
                    Object[] objectArray2 = objectArray;
                    cidrParseUnsafe2 = new CidrParseUnsafe((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return cidrParseUnsafe;
        }

        static {
            CidrParseUnsafe cidrParseUnsafe;
            CidrParseUnsafe cidrParseUnsafe2;
            CidrParseUnsafe cidrParseUnsafe3;
            CidrParseUnsafe.__$swapInit();
            INSTANCE = cidrParseUnsafe3 = CidrParseUnsafe.$INIT("INSTANCE", 0);
            MIN_VALUE = cidrParseUnsafe2 = INSTANCE;
            MAX_VALUE = cidrParseUnsafe = INSTANCE;
            CidrParseUnsafe[] cidrParseUnsafeArray = new CidrParseUnsafe[]{INSTANCE};
            $VALUES = cidrParseUnsafeArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CidrParseUnsafe.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CidrParseUnsafe.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CidrParseUnsafe.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CidrPrefix
    extends Enum<CidrPrefix>
    implements NonNullFunction<Cidr, Integer>,
    GroovyObject {
        public static final /* enum */ CidrPrefix INSTANCE;
        public static final CidrPrefix MIN_VALUE;
        public static final CidrPrefix MAX_VALUE;
        private static final /* synthetic */ CidrPrefix[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CidrPrefix(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.util.Cidr$CidrPrefix was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)__namedArgs);
        }

        public CidrPrefix() {
            this(new LinkedHashMap());
        }

        @Override
        public Integer apply(@Nullable Cidr cidr) {
            Cidr cidr2 = cidr;
            return cidr2 != null ? Integer.valueOf(cidr2.getPrefix()) : null;
        }

        public static final CidrPrefix[] values() {
            return (CidrPrefix[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), CidrPrefix[].class);
        }

        public /* synthetic */ CidrPrefix next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (CidrPrefix)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrPrefix.class);
        }

        public /* synthetic */ CidrPrefix previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (CidrPrefix)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), CidrPrefix.class);
        }

        public static CidrPrefix valueOf(String name) {
            return (CidrPrefix)ScriptBytecodeAdapter.castToType((Object)Enum.valueOf(CidrPrefix.class, name), CidrPrefix.class);
        }

        public static final /* synthetic */ CidrPrefix $INIT(Object ... para) {
            CidrPrefix cidrPrefix;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, CidrPrefix.class)) {
                case -1348271900: {
                    CidrPrefix cidrPrefix2;
                    cidrPrefix = cidrPrefix2;
                    Object[] objectArray2 = objectArray;
                    cidrPrefix2 = new CidrPrefix();
                    break;
                }
                case -242181752: {
                    CidrPrefix cidrPrefix2;
                    cidrPrefix = cidrPrefix2;
                    Object[] objectArray2 = objectArray;
                    cidrPrefix2 = new CidrPrefix((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return cidrPrefix;
        }

        static {
            CidrPrefix cidrPrefix;
            CidrPrefix cidrPrefix2;
            CidrPrefix cidrPrefix3;
            CidrPrefix.__$swapInit();
            INSTANCE = cidrPrefix3 = CidrPrefix.$INIT("INSTANCE", 0);
            MIN_VALUE = cidrPrefix2 = INSTANCE;
            MAX_VALUE = cidrPrefix = INSTANCE;
            CidrPrefix[] cidrPrefixArray = new CidrPrefix[]{INSTANCE};
            $VALUES = cidrPrefixArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CidrPrefix.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CidrPrefix.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CidrPrefix.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

