/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.upgrade;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DatabaseBootstrapper;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.annotation.DatabaseNamingStrategy;
import com.eucalyptus.component.id.Database;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import groovy.sql.GroovyRowResult;
import groovy.sql.Sql;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class Upgrades {
    private static Logger LOG = Logger.getLogger(Upgrades.class);
    private static final Map<Version, Map<Class<? extends ComponentId>, ComponentUpgradeInfo>> versionedComponentUpgrades = Maps.newHashMap();

    private static boolean isForceUpgrade() {
        return Boolean.parseBoolean(System.getProperty("euca.upgrade.force"));
    }

    private static void runSchemaUpdate(DatabaseFilters dbName) throws RuntimeException {
        try {
            Map<String, String> props = UpgradeState.getDatabaseProperties();
            for (String ctx : PersistenceContexts.list()) {
                Properties p = new Properties();
                p.putAll(props);
                String databaseName = (String)PersistenceContexts.toDatabaseName().apply((Object)ctx);
                String schemaName = (String)PersistenceContexts.toSchemaName().apply((Object)ctx);
                UpgradeState.putContextProperties(p, schemaName, dbName.getVersionedName(databaseName));
                Ejb3Configuration config = new Ejb3Configuration();
                config.setProperties(p);
                for (Class c : PersistenceContexts.listEntities(ctx)) {
                    config.addAnnotatedClass(c);
                }
                new SchemaUpdate(config.getHibernateConfiguration()).execute(true, true);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            LOG.fatal((Object)"Failed to initialize the persistence layer.");
            throw Exceptions.toUndeclared(e);
        }
    }

    static enum UpgradeState implements Callable<Boolean>
    {
        START{

            @Override
            public boolean callAndLog() throws Exception {
                return (Boolean)this.call();
            }
        }
        ,
        CHECK_NAMING{

            @Override
            public boolean callAndLog() throws Exception {
                return this.call();
            }

            @Override
            public Boolean call() throws Exception {
                return BootstrapArgs.isCloudController() != false && !this.databaseNamingConflict();
            }

            private boolean databaseNamingConflict() {
                if (BootstrapArgs.isUpgradeSystem() || Upgrades.isForceUpgrade()) {
                    return false;
                }
                Set<String> databaseNames = this.getDatabaseNames();
                Set<String> schemaNames = this.getSchemaNames(databaseNames);
                databaseNames.retainAll(schemaNames);
                if (!databaseNames.isEmpty()) {
                    LOG.fatal((Object)("Conflicting schema/database for contexts: " + databaseNames + ", resolve conflicts and restart."));
                    System.exit(1);
                }
                return false;
            }
        }
        ,
        PARSE_ARGS{

            @Override
            public boolean callAndLog() throws Exception {
                try {
                    Version.getCurrentVersion();
                    Version.getOldVersion();
                    Version.getNewVersion();
                }
                catch (IllegalArgumentException ex) {
                    LOG.fatal((Object)ex);
                    throw ex;
                }
                return true;
            }
        }
        ,
        UPGRADE_NAMING{

            @Override
            public boolean callAndLog() throws Exception {
                return this.call();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public Boolean call() throws Exception {
                final Set<String> databaseNames = this.getDatabaseNames();
                final Set<String> schemaNames = this.getSchemaNames(databaseNames);
                int exitCode = -1;
                for (final String ctx : PersistenceContexts.list()) {
                    block29: {
                        Sql sql;
                        String schemaToDelete;
                        String databaseToDelete;
                        DatabaseNamingStrategy strategy = PersistenceContexts.getNamingStrategy(ctx);
                        EnumSet<DatabaseNamingStrategy> otherStrategies = EnumSet.complementOf(EnumSet.of(strategy));
                        Collection presentStrategies = Collections2.filter(otherStrategies, (Predicate)new Predicate<DatabaseNamingStrategy>(){

                            public boolean apply(@Nullable DatabaseNamingStrategy strategy) {
                                String databaseName = strategy.getDatabaseName(ctx);
                                String schemaName = strategy.getSchemaName(ctx);
                                return schemaName == null && databaseNames.contains(databaseName) || schemaName != null && schemaNames.contains(schemaName);
                            }
                        });
                        if (!(presentStrategies.isEmpty() || BootstrapArgs.isUpgradeSystem() || Upgrades.isForceUpgrade())) {
                            LOG.fatal((Object)("Database layout update required for '" + ctx + "', but upgrade not enabled (add '-Deuca.upgrade.force=true' in CLOUD_OPTS to force)"));
                            exitCode = 1;
                            break;
                        }
                        if (presentStrategies.size() > 1) {
                            LOG.fatal((Object)("Error updating naming for context '" + ctx + "', multiple sources."));
                            exitCode = 1;
                            break;
                        }
                        if (presentStrategies.size() != 1) continue;
                        exitCode = 123;
                        String targetDatabaseName = strategy.getDatabaseName(ctx);
                        String targetSchemaName = (String)Objects.firstNonNull((Object)strategy.getSchemaName(ctx), (Object)Databases.getDefaultSchemaName());
                        String sourceDatabaseName = ((DatabaseNamingStrategy)((Object)Iterables.getOnlyElement((Iterable)presentStrategies))).getDatabaseName(ctx);
                        String sourceSchemaName = (String)Objects.firstNonNull((Object)((DatabaseNamingStrategy)((Object)Iterables.getOnlyElement((Iterable)presentStrategies))).getSchemaName(ctx), (Object)Databases.getDefaultSchemaName());
                        boolean copied = false;
                        Databases.getBootstrapper().copyDatabaseSchema(sourceDatabaseName, sourceSchemaName, targetDatabaseName, targetSchemaName);
                        copied = true;
                        try {
                            databaseToDelete = copied ? sourceDatabaseName : targetDatabaseName;
                            String string = schemaToDelete = copied ? sourceSchemaName : targetSchemaName;
                            if (!"eucalyptus_shared".equals(databaseToDelete)) {
                                Databases.getBootstrapper().deleteDatabase(databaseToDelete);
                                break block29;
                            }
                            if (!this.getSchemaNames(Collections.singleton(databaseToDelete)).contains(schemaToDelete)) break block29;
                            LOG.info((Object)("Dropping schema " + schemaToDelete + " for database " + databaseToDelete));
                            sql = Databases.getBootstrapper().getConnection(databaseToDelete, null);
                            try {
                                sql.executeUpdate("DROP SCHEMA " + schemaToDelete + " CASCADE");
                                break block29;
                            }
                            finally {
                                if (sql != null) {
                                    sql.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            LOG.fatal((Object)("Error cleaning up after updating naming for context '" + ctx + "'"), (Throwable)e);
                            exitCode = 1;
                        }
                        break block29;
                        catch (Exception e) {
                            try {
                                LOG.fatal((Object)("Error updating naming for context '" + ctx + "'"), (Throwable)e);
                                exitCode = 1;
                            }
                            catch (Throwable throwable) {
                                block30: {
                                    try {
                                        String schemaToDelete2;
                                        String databaseToDelete2 = copied ? sourceDatabaseName : targetDatabaseName;
                                        String string = schemaToDelete2 = copied ? sourceSchemaName : targetSchemaName;
                                        if (!"eucalyptus_shared".equals(databaseToDelete2)) {
                                            Databases.getBootstrapper().deleteDatabase(databaseToDelete2);
                                            break block30;
                                        }
                                        if (!this.getSchemaNames(Collections.singleton(databaseToDelete2)).contains(schemaToDelete2)) break block30;
                                        LOG.info((Object)("Dropping schema " + schemaToDelete2 + " for database " + databaseToDelete2));
                                        try (Sql sql2 = Databases.getBootstrapper().getConnection(databaseToDelete2, null);){
                                            sql2.executeUpdate("DROP SCHEMA " + schemaToDelete2 + " CASCADE");
                                        }
                                    }
                                    catch (Exception e2) {
                                        LOG.fatal((Object)("Error cleaning up after updating naming for context '" + ctx + "'"), (Throwable)e2);
                                        exitCode = 1;
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                databaseToDelete = copied ? sourceDatabaseName : targetDatabaseName;
                                String string = schemaToDelete = copied ? sourceSchemaName : targetSchemaName;
                                if (!"eucalyptus_shared".equals(databaseToDelete)) {
                                    Databases.getBootstrapper().deleteDatabase(databaseToDelete);
                                }
                                if (!this.getSchemaNames(Collections.singleton(databaseToDelete)).contains(schemaToDelete)) break block29;
                                LOG.info((Object)("Dropping schema " + schemaToDelete + " for database " + databaseToDelete));
                                sql = Databases.getBootstrapper().getConnection(databaseToDelete, null);
                                try {
                                    sql.executeUpdate("DROP SCHEMA " + schemaToDelete + " CASCADE");
                                }
                                finally {
                                    if (sql != null) {
                                        sql.close();
                                    }
                                }
                            }
                            catch (Exception e3) {
                                LOG.fatal((Object)("Error cleaning up after updating naming for context '" + ctx + "'"), (Throwable)e3);
                                exitCode = 1;
                            }
                        }
                    }
                    if (exitCode != 1) continue;
                    break;
                }
                if (exitCode > -1) {
                    LOG.info((Object)"Restarting due to database renaming.");
                    System.exit(exitCode);
                }
                return true;
            }
        }
        ,
        CHECK_ARGS{

            @Override
            public boolean callAndLog() throws Exception {
                return this.call();
            }

            @Override
            public Boolean call() throws Exception {
                if (BootstrapArgs.isCloudController().booleanValue() && (BootstrapArgs.isUpgradeSystem() || !UpgradeEventLog.exists())) {
                    return true;
                }
                return false;
            }
        }
        ,
        CHECK_UPGRADE_LOG{

            @Override
            public boolean callAndLog() throws Exception {
                return this.call();
            }

            @Override
            public Boolean call() throws Exception {
                if (UpgradeEventLog.create()) {
                    return true;
                }
                UpgradeState previousState = UpgradeEventLog.getLastState();
                boolean continueUpgrade = false;
                switch (previousState) {
                    case START: 
                    case PARSE_ARGS: 
                    case UPGRADE_NAMING: 
                    case CHECK_ARGS: 
                    case CHECK_UPGRADE_LOG: 
                    case PRE_SCHEMA_UPDATE: 
                    case CHECK_VERSIONS: {
                        continueUpgrade = true;
                        break;
                    }
                    case BEGIN_UPGRADE: 
                    case PRE_BACKINGUP_DATABASE: 
                    case PRE_COPYING_DATABASES: 
                    case PRE_SETUP_JPA: 
                    case RUN_PRE_UPGRADE: 
                    case RUN_ENTITY_UPGRADE: 
                    case RUN_POST_UPGRADE: {
                        for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.OLDVERSION)) {
                            Databases.getBootstrapper().deleteDatabase(databaseName);
                        }
                        for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.NEWVERSION)) {
                            Databases.getBootstrapper().deleteDatabase(databaseName);
                        }
                        continueUpgrade = true;
                        break;
                    }
                    case POST_SHUTDOWN_JPA: 
                    case POST_DELETE_ORIG_DB: {
                        for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.NEWVERSION)) {
                            Databases.getBootstrapper().deleteDatabase(databaseName);
                        }
                        for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.EUCALYPTUS)) {
                            Databases.getBootstrapper().deleteDatabase(databaseName);
                        }
                        for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.OLDVERSION)) {
                            Databases.getBootstrapper().renameDatabase(databaseName, DatabaseFilters.EUCALYPTUS.getVersionedName(databaseName));
                        }
                        continueUpgrade = true;
                        break;
                    }
                    case POST_RENAME_NEW_TO_ORIG_DB: 
                    case POST_DELETE_OLD_DB: {
                        POST_DELETE_OLD_DB.callAndLog();
                        COMPLETED.callAndLog();
                        continueUpgrade = false;
                        break;
                    }
                    case COMPLETED: {
                        continueUpgrade = true;
                        break;
                    }
                    case ERROR: {
                        LOG.fatal((Object)"Last upgrade stage executed was ERROR!  We need to bail out and have someone look at what is going on here.");
                        System.exit(1);
                        continueUpgrade = false;
                    }
                }
                return continueUpgrade;
            }
        }
        ,
        CHECK_VERSIONS{

            @Override
            public Boolean call() throws Exception {
                if (Version.getCurrentVersion().equals((Object)UpgradeEventLog.getLastUpgradedVersion())) {
                    return Upgrades.isForceUpgrade();
                }
                if (Version.getCurrentVersion().equals((Object)Version.getOldVersion()) && !BootstrapArgs.isUpgradeSystem()) {
                    return Upgrades.isForceUpgrade();
                }
                return true;
            }

            @Override
            public boolean callAndLog() throws Exception {
                return this.call();
            }
        }
        ,
        BEGIN_UPGRADE,
        PRE_BACKINGUP_DATABASE{

            @Override
            public Boolean call() {
                return true;
            }
        }
        ,
        PRE_COPYING_DATABASES{

            @Override
            public Boolean call() {
                LOG.info((Object)"Creating upgrade databases for old version");
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.OLDVERSION)) {
                    LOG.info((Object)("Deleting stale upgrade databases for old version: " + DatabaseFilters.OLDVERSION.getVersionedName(databaseName)));
                    Databases.getBootstrapper().deleteDatabase(databaseName);
                }
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.EUCALYPTUS)) {
                    LOG.info((Object)("Creating upgrade databases for old version: " + DatabaseFilters.OLDVERSION.getVersionedName(databaseName)));
                    Databases.getBootstrapper().copyDatabase(databaseName, DatabaseFilters.OLDVERSION.getVersionedName(databaseName));
                }
                LOG.info((Object)"Creating upgrade databases for new version");
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.NEWVERSION)) {
                    LOG.info((Object)("Deleting stale upgrade databases for new version: " + DatabaseFilters.NEWVERSION.getVersionedName(databaseName)));
                    Databases.getBootstrapper().deleteDatabase(databaseName);
                }
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.EUCALYPTUS)) {
                    LOG.info((Object)("Creating upgrade databases for new version: " + DatabaseFilters.NEWVERSION.getVersionedName(databaseName)));
                    Databases.getBootstrapper().copyDatabase(databaseName, DatabaseFilters.NEWVERSION.getVersionedName(databaseName));
                }
                return true;
            }
        }
        ,
        PRE_SCHEMA_UPDATE{

            @Override
            public Boolean call() {
                Upgrades.runSchemaUpdate(DatabaseFilters.NEWVERSION);
                return true;
            }
        }
        ,
        PRE_SETUP_JPA{

            @Override
            public Boolean call() {
                try {
                    Map<String, String> props = 11.getDatabaseProperties();
                    for (String ctx : PersistenceContexts.list()) {
                        Properties p = new Properties();
                        p.putAll(props);
                        String databaseName = (String)PersistenceContexts.toDatabaseName().apply((Object)ctx);
                        String schemaName = (String)PersistenceContexts.toSchemaName().apply((Object)ctx);
                        11.putContextProperties(p, schemaName, DatabaseFilters.NEWVERSION.getVersionedName(databaseName));
                        Ejb3Configuration config = new Ejb3Configuration();
                        config.setProperties(p);
                        for (Class c : PersistenceContexts.listEntities(ctx)) {
                            config.addAnnotatedClass(c);
                        }
                        PersistenceContexts.registerPersistenceContext(ctx, config);
                    }
                }
                catch (Exception e) {
                    LOG.fatal((Object)e, (Throwable)e);
                    LOG.fatal((Object)"Failed to initialize the persistence layer.");
                    throw Exceptions.toUndeclared(e);
                }
                return true;
            }
        }
        ,
        RUN_PRE_UPGRADE{

            @Override
            public Boolean call() {
                for (ComponentId c : ComponentIds.list()) {
                    for (Version v : Version.upgradePath()) {
                        ComponentUpgradeInfo upgradeInfo = ComponentUpgradeInfo.get(v, c.getClass());
                        for (Callable<Boolean> p : upgradeInfo.getPreUpgrades()) {
                            try {
                                LOG.info((Object)("Executing @PreUpgrade: " + p.getClass()));
                                p.call();
                            }
                            catch (Exception ex) {
                                throw Exceptions.toUndeclared((String)("Upgrade failed during @PreUpgrade while executing: " + p.getClass() + " because of: " + ex.getMessage()), (Throwable[])new Exception[]{ex});
                            }
                        }
                    }
                }
                return true;
            }
        }
        ,
        RUN_ENTITY_UPGRADE{

            @Override
            public Boolean call() {
                for (ComponentId c : ComponentIds.list()) {
                    for (Version v : Version.upgradePath()) {
                        ComponentUpgradeInfo upgradeInfo = ComponentUpgradeInfo.get(v, c.getClass());
                        for (Map.Entry p : upgradeInfo.getEntityUpgrades().entries()) {
                            try {
                                LOG.info((Object)("Executing @EntityUpgrade: " + ((Predicate)p.getValue()).getClass()));
                                ((Predicate)p.getValue()).apply(p.getKey());
                            }
                            catch (Exception ex) {
                                throw Exceptions.toUndeclared((String)("Upgrade failed during @EntityUpgrade while executing: " + ((Predicate)p.getValue()).getClass() + " for " + p.getKey() + " because of: " + ex.getMessage()), (Throwable[])new Exception[]{ex});
                            }
                        }
                    }
                }
                return true;
            }
        }
        ,
        RUN_POST_UPGRADE{

            @Override
            public Boolean call() {
                for (ComponentId c : ComponentIds.list()) {
                    for (Version v : Version.upgradePath()) {
                        ComponentUpgradeInfo upgradeInfo = ComponentUpgradeInfo.get(v, c.getClass());
                        for (Callable<Boolean> p : upgradeInfo.getPostUpgrades()) {
                            try {
                                LOG.info((Object)("Executing @PostUpgrade: " + p.getClass()));
                                p.call();
                            }
                            catch (Exception ex) {
                                throw Exceptions.toUndeclared((String)("Upgrade failed during @PostUpgrade while executing: " + p.getClass() + " because of: " + ex.getMessage()), (Throwable[])new Exception[]{ex});
                            }
                        }
                    }
                }
                return true;
            }
        }
        ,
        POST_SHUTDOWN_JPA{

            @Override
            public Boolean call() {
                PersistenceContexts.shutdown();
                return true;
            }
        }
        ,
        POST_DELETE_ORIG_DB{

            @Override
            public Boolean call() {
                LOG.info((Object)"Deleting orig databases");
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.EUCALYPTUS)) {
                    LOG.info((Object)("Deleting orig database: " + databaseName));
                    Databases.getBootstrapper().deleteDatabase(databaseName);
                }
                return true;
            }
        }
        ,
        POST_RENAME_NEW_TO_ORIG_DB{

            @Override
            public Boolean call() {
                LOG.info((Object)"Renaming upgraded databases");
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.NEWVERSION)) {
                    LOG.info((Object)("Renaming upgraded database: " + databaseName + " => " + DatabaseFilters.EUCALYPTUS.getVersionedName(databaseName)));
                    Databases.getBootstrapper().renameDatabase(databaseName, DatabaseFilters.EUCALYPTUS.getVersionedName(databaseName));
                }
                return true;
            }
        }
        ,
        POST_DELETE_OLD_DB{

            @Override
            public Boolean call() {
                LOG.info((Object)"Deleting upgrade databases for old version");
                for (String databaseName : Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.OLDVERSION)) {
                    LOG.info((Object)("Deleting upgrade database for old version: " + databaseName));
                    Databases.getBootstrapper().deleteDatabase(databaseName);
                }
                return true;
            }
        }
        ,
        COMPLETED{

            @Override
            public UpgradeState next() {
                LOG.info((Object)("Finished upgrade stage: " + this.name()));
                return this;
            }
        }
        ,
        ERROR{

            @Override
            public UpgradeState next() {
                return this;
            }
        };

        private static UpgradeState currentState;

        @Override
        public Boolean call() throws Exception {
            return true;
        }

        public boolean callAndLog() throws Exception {
            if (this.call().booleanValue()) {
                UpgradeEventLog.INSTANCE.logEvent(Version.getOldVersion(), Version.getNewVersion(), this);
                return true;
            }
            return false;
        }

        UpgradeState next() {
            UpgradeState next = UpgradeState.values()[this.ordinal() + 1];
            LOG.info((Object)("Finished upgrade stage: " + this.name() + "; starting " + next.name()));
            return next;
        }

        Set<String> getDatabaseNames() {
            return Sets.newTreeSet((Iterable)Iterables.filter(Databases.getBootstrapper().listDatabases(), (Predicate)DatabaseFilters.EUCALYPTUS));
        }

        Set<String> getSchemaNames(Set<String> databaseNames) {
            return databaseNames.contains("eucalyptus_shared") ? Sets.newTreeSet((Iterable)Iterables.filter(Databases.getBootstrapper().listSchemas("eucalyptus_shared"), (Predicate)DatabaseFilters.EUCALYPTUS)) : Collections.emptySet();
        }

        public static void putContextProperties(Map<? super String, ? super String> properties, String schema, String ... databasePath) {
            String ctxUrl = String.format("jdbc:%s", ServiceUris.remote(Database.class, InetAddresses.forString((String)"127.0.0.1"), databasePath));
            properties.put("hibernate.connection.url", ctxUrl);
            if (schema != null) {
                properties.put("hibernate.default_schema", schema);
            }
        }

        public static Map<String, String> getDatabaseProperties() {
            DatabaseBootstrapper db = Databases.getBootstrapper();
            ImmutableMap props = ImmutableMap.builder().put((Object)"hibernate.show_sql", (Object)"false").put((Object)"hibernate.format_sql", (Object)"false").put((Object)"hibernate.connection.autocommit", (Object)"false").put((Object)"hibernate.hbm2ddl.auto", (Object)"update").put((Object)"hibernate.generate_statistics", (Object)"false").put((Object)"hibernate.connection.driver_class", (Object)db.getDriverName()).put((Object)"hibernate.connection.username", (Object)db.getUserName()).put((Object)"hibernate.connection.password", (Object)db.getPassword()).put((Object)"hibernate.bytecode.use_reflection_optimizer", (Object)"true").put((Object)"hibernate.cglib.use_reflection_optimizer", (Object)"true").put((Object)"hibernate.dialect", (Object)db.getHibernateDialect()).put((Object)"hibernate.cache.use_second_level_cache", (Object)"false").put((Object)"hibernate.cache.use_query_cache", (Object)"false").build();
            return props;
        }

        public static boolean isFinished() {
            return currentState == COMPLETED;
        }

        public static UpgradeState nextState() {
            currentState = currentState.next();
            return currentState;
        }

        static {
            currentState = START;
        }
    }

    public static enum DatabaseFilters implements Predicate<String>
    {
        EUCALYPTUS{

            @Override
            public String getPrefix() {
                return "eucalyptus_";
            }
        }
        ,
        OLDVERSION{

            @Override
            public String getPrefix() {
                return (Object)((Object)Version.getOldVersion()) + "_" + EUCALYPTUS.getPrefix();
            }
        }
        ,
        NEWVERSION{

            @Override
            public String getPrefix() {
                return (Object)((Object)Version.getNewVersion()) + "_" + EUCALYPTUS.getPrefix();
            }
        };


        public boolean apply(String arg0) {
            return arg0.startsWith(this.getPrefix());
        }

        public abstract String getPrefix();

        public String getVersionedName(String origName) {
            if (origName.startsWith(EUCALYPTUS.getPrefix())) {
                return origName.replace(EUCALYPTUS.getPrefix(), this.getPrefix());
            }
            if (origName.startsWith(NEWVERSION.getPrefix())) {
                return origName.replace(NEWVERSION.getPrefix(), this.getPrefix());
            }
            if (origName.startsWith(OLDVERSION.getPrefix())) {
                return origName.replace(OLDVERSION.getPrefix(), this.getPrefix());
            }
            throw new RuntimeException("Failed to determine correct version name for: " + origName);
        }

        public Sql getConnection(String context) throws Exception {
            return Databases.getBootstrapper().getConnection(this.getVersionedName((String)PersistenceContexts.toDatabaseName().apply((Object)context)), (String)PersistenceContexts.toSchemaName().apply((Object)context));
        }
    }

    @RunDuring(value=Bootstrap.Stage.UpgradeDatabase)
    @Provides(value=Empyrean.class)
    @DependsLocal(value={Eucalyptus.class})
    public static class UpgradeBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            try {
                while (UpgradeState.nextState().callAndLog() && !UpgradeState.isFinished()) {
                }
                Upgrades.runSchemaUpdate(DatabaseFilters.EUCALYPTUS);
                if (BootstrapArgs.isUpgradeSystem()) {
                    System.exit(0);
                    return false;
                }
            }
            catch (Throwable ex) {
                LOG.error((Object)ex, ex);
                if (BootstrapArgs.isUpgradeSystem()) {
                    System.exit(1);
                }
                return false;
            }
            return true;
        }
    }

    public static enum UpgradeEventLog {
        INSTANCE;

        private final String tableName = "database_upgrade_log";
        private final String schema = "CREATE TABLE " + this.tableName + " (\n" + "    id character varying(255) NOT NULL,\n" + "    timestamp timestamp without time zone,\n" + "    upgrade_from_version character varying(255),\n" + "    upgrade_to_version character varying(255),\n" + "    upgrade_state character varying(255)\n" + ");\n" + "ALTER TABLE public." + this.tableName + " OWNER TO eucalyptus;";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logEvent(Version fromVersion, Version toVersion, UpgradeState state) {
            try (Sql sql = null;){
                sql = Databases.Events.getConnection();
                LOG.debug((Object)("Recording upgrade event: " + fromVersion.name() + "=>" + toVersion.name() + " state=" + state.name()));
                sql.execute("INSERT INTO " + this.tableName + " VALUES ('" + UUID.randomUUID() + "','" + new Timestamp(System.currentTimeMillis()) + "','" + fromVersion.name() + "','" + toVersion.name() + "','" + state.name() + "')");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static UpgradeState getLastState() {
            try (Sql sql = null;){
                sql = Databases.Events.getConnection();
                List res = sql.rows("select upgrade_state from database_upgrade_log order by timestamp desc limit 1;");
                if (!res.isEmpty()) {
                    UpgradeState upgradeState = UpgradeState.valueOf((String)((GroovyRowResult)res.listIterator().next()).get((Object)"upgrade_state"));
                    return upgradeState;
                }
                UpgradeState upgradeState = UpgradeState.COMPLETED;
                return upgradeState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Version getLastUpgradedVersion() {
            try (Sql sql = null;){
                sql = Databases.Events.getConnection();
                List res = sql.rows("select upgrade_to_version from database_upgrade_log where upgrade_state='COMPLETED' order by timestamp desc limit 1;");
                if (!res.isEmpty()) {
                    Version version = Version.valueOf((String)((GroovyRowResult)res.listIterator().next()).get((Object)"upgrade_to_version"));
                    return version;
                }
                Version version = Version.v3_1_2;
                return version;
            }
        }

        private static boolean create() {
            if (!UpgradeEventLog.exists()) {
                try (Sql sql = null;){
                    sql = Databases.Events.getConnection();
                    sql.execute(UpgradeEventLog.INSTANCE.schema);
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        public static boolean exists() {
            return Databases.getBootstrapper().listTables(Databases.Events.INSTANCE.getName(), null).contains(UpgradeEventLog.INSTANCE.tableName);
        }
    }

    private static class ComponentUpgradeInfo {
        private Multimap<Class, Predicate> entityUpgrades = ArrayListMultimap.create();
        private List<Callable<Boolean>> preUpgrades = Lists.newArrayList();
        private List<Callable<Boolean>> postUpgrades = Lists.newArrayList();
        private Class<? extends ComponentId> component;

        private ComponentUpgradeInfo(Class<? extends ComponentId> component) {
            this.component = component;
        }

        List<Callable<Boolean>> getPreUpgrades() {
            return this.preUpgrades;
        }

        Multimap<Class, Predicate> getEntityUpgrades() {
            return this.entityUpgrades;
        }

        List<Callable<Boolean>> getPostUpgrades() {
            return this.postUpgrades;
        }

        static ComponentUpgradeInfo get(Version version, Class<? extends ComponentId> component) {
            Map compMap = (Map)versionedComponentUpgrades.get((Object)version);
            if (compMap == null) {
                compMap = Maps.newHashMap();
                versionedComponentUpgrades.put(version, compMap);
            }
            if (!compMap.containsKey(component)) {
                compMap.put(component, new ComponentUpgradeInfo(component));
            }
            return (ComponentUpgradeInfo)compMap.get(component);
        }

        static void put(Class<? extends ComponentId> component, Class upgradeClass) {
            Ats ats = Ats.from(upgradeClass);
            if (ats.has(EntityUpgrade.class)) {
                for (Class c : ats.get(EntityUpgrade.class).entities()) {
                    ComponentUpgradeInfo.get((Version)ats.get(EntityUpgrade.class).since(), component).entityUpgrades.put((Object)c, (Object)((Predicate)Classes.newInstance(upgradeClass, new Object[0])));
                    LOG.info((Object)("Registered @EntityUpgrade: " + component.getSimpleName() + ":" + c.getSimpleName() + " => " + upgradeClass));
                }
            } else if (ats.has(PreUpgrade.class)) {
                ComponentUpgradeInfo.get((Version)ats.get(PreUpgrade.class).since(), component).preUpgrades.add((Callable)Classes.newInstance(upgradeClass, new Object[0]));
                LOG.info((Object)("Registered @PreUpgrade: " + component.getSimpleName() + " => " + upgradeClass));
            } else if (ats.has(PostUpgrade.class)) {
                ComponentUpgradeInfo.get((Version)ats.get(PostUpgrade.class).since(), component).postUpgrades.add((Callable)Classes.newInstance(upgradeClass, new Object[0]));
                LOG.info((Object)("Registered @PostUpgrade: " + component.getSimpleName() + " => " + upgradeClass));
            }
        }
    }

    public static class UpgradeDiscovery
    extends ServiceJarDiscovery {
        @Override
        public Double getPriority() {
            return 0.92;
        }

        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (Ats.from(candidate).has(EntityUpgrade.class)) {
                if (!Predicate.class.isAssignableFrom(candidate)) {
                    throw new IllegalArgumentException("@EntityUpgrade can only be used on a type which implements Predicate:  " + candidate);
                }
                EntityUpgrade upgrade = Ats.from(candidate).get(EntityUpgrade.class);
                ComponentUpgradeInfo.put(upgrade.value(), candidate);
            } else if (Ats.from(candidate).has(PreUpgrade.class)) {
                if (!Callable.class.isAssignableFrom(candidate)) {
                    throw new IllegalArgumentException("@PreUpgrade can only be used on a type which implements Callable:  " + candidate);
                }
                PreUpgrade upgrade = Ats.from(candidate).get(PreUpgrade.class);
                ComponentUpgradeInfo.put(upgrade.value(), candidate);
            } else if (Ats.from(candidate).has(PostUpgrade.class)) {
                if (!Callable.class.isAssignableFrom(candidate)) {
                    throw new IllegalArgumentException("@PostUpgrade can only be used on a type which implements Callable:  " + candidate);
                }
                PostUpgrade upgrade = Ats.from(candidate).get(PostUpgrade.class);
                ComponentUpgradeInfo.put(upgrade.value(), candidate);
            } else {
                return false;
            }
            return true;
        }
    }

    public static enum Version {
        v3_1_0,
        v3_1_1,
        v3_1_2,
        v3_2_0,
        v3_2_1,
        v3_2_2,
        v3_3_0,
        v3_3_1,
        v3_3_2,
        v3_3_3,
        v3_4_0,
        v3_4_1,
        v3_4_2,
        v3_4_3,
        v3_4_4,
        v4_0_0,
        v4_0_1,
        v4_0_2,
        v4_0_3,
        v4_0_4,
        v4_1_0;


        public String getVersion() {
            return this.name().substring(1).replace("_", ".");
        }

        public static Version getOldVersion() {
            return Version.valueOf("v" + Arguments.OLD_VERSION.getValue().replace(".", "_"));
        }

        public static Version getNewVersion() {
            return Version.valueOf("v" + Arguments.NEW_VERSION.getValue().replace(".", "_"));
        }

        public static Version getCurrentVersion() {
            return Version.valueOf("v" + Arguments.CURRENT_VERSION.getValue().replace(".", "_"));
        }

        public static Iterable<Version> upgradePath() {
            return Iterables.filter(Arrays.asList(Version.values()), (Predicate)new Predicate<Version>(){

                public boolean apply(@Nullable Version input) {
                    return Version.getOldVersion().ordinal() < input.ordinal() && Version.getNewVersion().ordinal() >= input.ordinal();
                }
            });
        }
    }

    static enum Arguments {
        CURRENT_VERSION("euca.version"),
        OLD_VERSION("euca.upgrade.old.version"){

            @Override
            public String getValue() {
                return System.getProperty(this.propName, BootstrapArgs.isUpgradeSystem() ? null : CURRENT_VERSION.getValue());
            }
        }
        ,
        NEW_VERSION("euca.version");

        String propName;

        private Arguments(String propName) {
            this.propName = propName;
        }

        public String getValue() {
            return System.getProperty(this.propName);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EntityUpgrade {
        public Class[] entities();

        public Class<? extends ComponentId> value();

        public Version since();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PostUpgrade {
        public Class<? extends ComponentId> value();

        public Version since();
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PreUpgrade {
        public Class<? extends ComponentId> value();

        public Version since();
    }
}

