/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system.tracking;

import com.eucalyptus.system.tracking.MessageCache;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class MessageContexts {
    private static final Logger LOG = Logger.getLogger(MessageContexts.class);
    private static Cache<String, List<MessageCache>> correlationIds = CacheBuilder.newBuilder().maximumSize(3000L).expireAfterAccess(1L, TimeUnit.HOURS).build();

    public static synchronized void remember(String resourceId, Class<? extends BaseMessage> msgType, BaseMessage message) {
        List listIds = null;
        listIds = (List)correlationIds.getIfPresent((Object)resourceId);
        if (listIds == null) {
            listIds = Lists.newArrayList();
            correlationIds.put((Object)resourceId, (Object)listIds);
        }
        int duplicate = -1;
        for (int i = 0; i < listIds.size(); ++i) {
            MessageCache corrId = (MessageCache)listIds.get(i);
            if (!msgType.equals(corrId.getKey())) continue;
            duplicate = i;
            break;
        }
        if (duplicate >= 0) {
            listIds.remove(duplicate);
        }
        try {
            listIds.add(new MessageCache(msgType, message));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared(new EucalyptusCloudException("Correlation Id is in wrong format"));
        }
    }

    public static synchronized boolean contains(String resourceId, Class<? extends BaseMessage> msgType) {
        return MessageContexts.lookup(resourceId, msgType) != null;
    }

    public static synchronized BaseMessage lookupLast(String resourceId, Set<Class> msgTypes) {
        List messages = (List)correlationIds.getIfPresent((Object)resourceId);
        if (messages == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (MessageCache corrId : messages) {
            if (!msgTypes.contains(corrId.getKey())) continue;
            result.add(corrId);
        }
        if (result.size() <= 0) {
            return null;
        }
        BaseMessage lastMsg = (BaseMessage)((MessageCache)result.get(0)).getValue();
        long lastTs = ((MessageCache)result.get(0)).getCreationTime().getTime();
        for (MessageCache corrId : result) {
            if (corrId.getCreationTime().getTime() <= lastTs) continue;
            lastMsg = (BaseMessage)corrId.getValue();
            lastTs = corrId.getCreationTime().getTime();
        }
        return lastMsg;
    }

    public static synchronized List<BaseMessage> lookup(String resourceId, Set<Class> msgTypes) {
        List messages = (List)correlationIds.getIfPresent((Object)resourceId);
        if (messages == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (MessageCache corrId : messages) {
            if (!msgTypes.contains(corrId.getKey())) continue;
            result.add(corrId.getValue());
        }
        return result;
    }

    public static synchronized BaseMessage lookup(String resourceId, Class<? extends BaseMessage> msgType) {
        List messages = (List)correlationIds.getIfPresent((Object)resourceId);
        if (messages == null) {
            return null;
        }
        for (MessageCache corrId : messages) {
            if (!msgType.equals(corrId.getKey())) continue;
            return (BaseMessage)corrId.getValue();
        }
        return null;
    }

    public static synchronized List<BaseMessage> lookup(String resourceId) {
        List messages = (List)correlationIds.getIfPresent((Object)resourceId);
        if (messages == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)messages, (Function)new Function<MessageCache, BaseMessage>(){

            public BaseMessage apply(MessageCache arg0) {
                return (BaseMessage)arg0.getValue();
            }
        });
    }
}

