/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system.log;

import com.eucalyptus.records.Logs;
import com.eucalyptus.util.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoggingResetter {
    private static final Logger LOG = Logger.getLogger(LoggingResetter.class);
    private static final String LOG4J_CONFIGURATION_TAG = "log4j:configuration";
    private static final String LOG4J_OLD_CONFIGURATION_TAG = "configuration";
    private static final String LOG4J_APPENDER_TAG = "appender";
    private static final String LOG4J_PARAM_TAG = "param";
    private static final String LOG4J_CATEGORY_TAG = "category";
    private static final String LOG4J_ROOT_TAG = "root";
    private static final String LOG4J_LOGGER_TAG = "logger";
    private static final String LOG4J_VALUE_ATTRIBUTE = "value";
    private static final String LOG4J_NAME_ATTRIBUTE = "name";
    private static final String LOG4J_LEVEL_TAG = "level";
    private static final String LOG4J_PRIORITY_TAG = "priority";
    private static final String LOG4J_THRESHOLD_ATTRIBUTE_VALUE = "Threshold";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void resetLoggingWithXML() {
        LOG.info((Object)("Resetting log levels to " + System.getProperty("euca.log.level")));
        Logs.reInit();
        SmallLoggingConfiguration smallLoggingConfiguration = null;
        InputStream in = null;
        try {
            DocumentBuilder dBuilder = XMLParser.getDocBuilderWithDTD();
            dBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            URL url2 = Thread.currentThread().getContextClassLoader().getResource("log4j.xml");
            if (url2 != null) {
                in = url2.openStream();
                InputSource inputSource = new InputSource(in);
                inputSource.setSystemId("dummy://log4j.dtd");
                Document document = dBuilder.parse(inputSource);
                Element documentElement = document.getDocumentElement();
                smallLoggingConfiguration = LoggingResetter.parse(documentElement);
            }
            LoggingResetter.resetRootLogLevel(LogManager.getRootLogger(), smallLoggingConfiguration);
            Enumeration e = LogManager.getCurrentLoggers();
            while (e.hasMoreElements()) {
                LoggingResetter.resetLogLevel((Logger)e.nextElement(), smallLoggingConfiguration);
            }
            LOG.info((Object)"Finished resetting log levels");
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            LOG.warn((Object)"Unable to reset log levels");
        }
        catch (SAXException ex) {
            LOG.error((Object)ex);
            LOG.warn((Object)"Unable to reset log levels");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                }
            }
        }
    }

    private static void resetRootLogLevel(Logger rootLogger, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (rootLogger == null) {
            throw new IllegalArgumentException("root logger is null");
        }
        Level level = smallLoggingConfiguration.rootLogLevel;
        if (level != null) {
            LOG.debug((Object)("Resetting root logger level to " + level));
            rootLogger.setLevel(level);
        } else {
            LOG.debug((Object)"Root logger level unspecified, leaving as is.");
        }
        Enumeration appenders = rootLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            LoggingResetter.resetLogLevel((Appender)appenders.nextElement(), smallLoggingConfiguration);
        }
    }

    private static void resetLogLevel(Logger logger, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        String name = logger.getName();
        if (name == null) {
            throw new IllegalArgumentException("logger name is null");
        }
        Level level = smallLoggingConfiguration.loggerLoggingLevels.get(name);
        if (level != null) {
            LOG.debug((Object)("Resetting logger " + name + " level to " + level));
            logger.setLevel(level);
        } else {
            LOG.debug((Object)("Logger " + name + " level unspecified, leaving as is."));
        }
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            LoggingResetter.resetLogLevel((Appender)appenders.nextElement(), smallLoggingConfiguration);
        }
    }

    private static void resetLogLevel(Appender appender, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (appender == null) {
            throw new IllegalArgumentException("appender is null");
        }
        String name = appender.getName();
        if (name == null) {
            throw new IllegalArgumentException("appender name is null");
        }
        Level level = smallLoggingConfiguration.appenderThresholdLevels.get(name);
        if (!(appender instanceof AppenderSkeleton)) {
            LOG.debug((Object)("Unable to set threshold of appender " + name + ", class " + appender.getClass() + " not an AppenderSkeletion"));
        }
        if (level != null) {
            LOG.debug((Object)("Resetting appender threshold " + name + " level to " + level));
            ((AppenderSkeleton)appender).setThreshold((Priority)level);
        } else {
            LOG.debug((Object)("Appender " + name + " threshold unspecified, leaving as is."));
        }
    }

    private static SmallLoggingConfiguration parse(Element element) {
        SmallLoggingConfiguration smallLoggingConfiguration = new SmallLoggingConfiguration();
        if (element == null) {
            LOG.error((Object)"Log4j XML file has no document element");
        } else if (element.getTagName() == null) {
            LOG.error((Object)"Log4j XML file has a null document element tag");
        } else if (!element.getTagName().equalsIgnoreCase(LOG4J_CONFIGURATION_TAG) && !element.getTagName().equalsIgnoreCase(LOG4J_OLD_CONFIGURATION_TAG)) {
            LOG.error((Object)("Log4j XML file has an invalid top level tag " + element.getTagName()));
        } else {
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Element currentElement;
                String tagName;
                Node currentNode = children.item(i);
                if (currentNode.getNodeType() != 1 || (tagName = (currentElement = (Element)currentNode).getTagName()) == null) continue;
                if (tagName.equalsIgnoreCase(LOG4J_APPENDER_TAG)) {
                    LoggingResetter.parseAppender(currentElement, smallLoggingConfiguration);
                    continue;
                }
                if (tagName.equalsIgnoreCase(LOG4J_ROOT_TAG)) {
                    LoggingResetter.parseRoot(currentElement, smallLoggingConfiguration);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(LOG4J_CATEGORY_TAG) && !tagName.equalsIgnoreCase(LOG4J_LOGGER_TAG)) continue;
                LoggingResetter.parseLogger(currentElement, smallLoggingConfiguration);
            }
        }
        return smallLoggingConfiguration;
    }

    private static void parseAppender(Element element, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (element == null) {
            return;
        }
        Level level = null;
        String name = LoggingResetter.subst(element.getAttribute(LOG4J_NAME_ATTRIBUTE));
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element currentElement;
            String tagName;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || (tagName = (currentElement = (Element)currentNode).getTagName()) == null || !tagName.equalsIgnoreCase(LOG4J_PARAM_TAG)) continue;
            String paramName = LoggingResetter.subst(currentElement.getAttribute(LOG4J_NAME_ATTRIBUTE));
            String paramVal = LoggingResetter.subst(currentElement.getAttribute(LOG4J_VALUE_ATTRIBUTE));
            if (paramName == null || !paramName.equalsIgnoreCase(LOG4J_THRESHOLD_ATTRIBUTE_VALUE) || paramVal == null || paramVal.isEmpty()) continue;
            level = Level.toLevel((String)LoggingResetter.unExtremify(paramVal));
        }
        if (level != null && name != null) {
            smallLoggingConfiguration.appenderThresholdLevels.put(name, level);
        }
    }

    private static String subst(String s) {
        return OptionConverter.substVars((String)s, (Properties)System.getProperties());
    }

    private static void parseRoot(Element element, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (element == null) {
            return;
        }
        Level level = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            String levelStr;
            Element currentElement;
            String tagName;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || (tagName = (currentElement = (Element)currentNode).getTagName()) == null || !tagName.equalsIgnoreCase(LOG4J_PRIORITY_TAG) && !tagName.equalsIgnoreCase(LOG4J_LEVEL_TAG) || (levelStr = LoggingResetter.subst(currentElement.getAttribute(LOG4J_VALUE_ATTRIBUTE))) == null || levelStr.isEmpty()) continue;
            level = Level.toLevel((String)LoggingResetter.unExtremify(levelStr));
        }
        if (level != null) {
            smallLoggingConfiguration.rootLogLevel = level;
        }
    }

    private static void parseLogger(Element element, SmallLoggingConfiguration smallLoggingConfiguration) {
        if (element == null) {
            return;
        }
        Level level = null;
        String name = LoggingResetter.subst(element.getAttribute(LOG4J_NAME_ATTRIBUTE));
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            String levelStr;
            Element currentElement;
            String tagName;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || (tagName = (currentElement = (Element)currentNode).getTagName()) == null || !tagName.equalsIgnoreCase(LOG4J_PRIORITY_TAG) && !tagName.equalsIgnoreCase(LOG4J_LEVEL_TAG) || (levelStr = LoggingResetter.subst(currentElement.getAttribute(LOG4J_VALUE_ATTRIBUTE))) == null || levelStr.isEmpty()) continue;
            level = Level.toLevel((String)LoggingResetter.unExtremify(levelStr));
        }
        if (level != null && name != null) {
            smallLoggingConfiguration.loggerLoggingLevels.put(name, level);
        }
    }

    private static String unExtremify(String levelStr) {
        if ("EXTREME".equalsIgnoreCase(levelStr) || "EXHAUST".equalsIgnoreCase(levelStr)) {
            return "TRACE";
        }
        return levelStr;
    }

    private static class SmallLoggingConfiguration {
        public Map<String, Level> appenderThresholdLevels = new HashMap<String, Level>();
        public Level rootLogLevel = null;
        public Map<String, Level> loggerLoggingLevels = new HashMap<String, Level>();

        private SmallLoggingConfiguration() {
        }
    }
}

