/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system.log;

import com.eucalyptus.system.log.EucaLoggingEvent;
import java.text.DecimalFormat;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class EucaPatternParser
extends PatternParser {
    public EucaPatternParser(String pattern) {
        super(pattern);
    }

    protected void finalizeConverter(char c) {
        PatternConverter pc = null;
        switch (c) {
            case 'i': {
                pc = new ThreadIdPatternConverter(this.formattingInfo);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'f': {
                pc = new FileAndLineNumberPatternConverter(this.formattingInfo);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'o': {
                pc = new CorrelationIdPatternConverter(this.formattingInfo);
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                super.finalizeConverter(c);
                return;
            }
        }
        this.addConverter(pc);
    }

    private static class CorrelationIdPatternConverter
    extends PatternConverter {
        CorrelationIdPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            if (event.getProperties().containsKey("correlation-id")) {
                String correlationId = event.getProperty("correlation-id");
                if (correlationId != null && correlationId.length() >= 36) {
                    if (correlationId.contains("::")) {
                        String postfix = correlationId.substring(correlationId.indexOf("::") + 2);
                        String postfixHex = "";
                        if (postfix.length() > 13) {
                            postfixHex = postfix.substring(9, 13);
                        }
                        return correlationId.substring(0, 8) + "-" + postfixHex;
                    }
                    return correlationId.substring(0, 13);
                }
                return "unknown";
            }
            return "unknown";
        }
    }

    private static class ThreadIdPatternConverter
    extends PatternConverter {
        private static final DecimalFormat df = new DecimalFormat("00000000000");
        int type;

        ThreadIdPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            if (event instanceof EucaLoggingEvent) {
                return df.format(((EucaLoggingEvent)event).getThreadId());
            }
            return "unknown";
        }
    }

    private class FileAndLineNumberPatternConverter
    extends PatternConverter {
        FileAndLineNumberPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            LocationInfo locationInfo = event.getLocationInformation();
            return locationInfo.getFileName() + ":" + locationInfo.getLineNumber();
        }
    }
}

