/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.concurrent.GenericCheckedListenableFuture;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jgroups.util.ThreadFactory;

public class Threads {
    private static Logger LOG = Logger.getLogger(Threads.class);
    private static final String PREFIX = "Eucalyptus.";
    private static final Integer NUM_QUEUE_WORKERS = 32;
    private static final AtomicInteger threadIndex = new AtomicInteger(0);
    private static final ConcurrentMap<String, ThreadPool> execServices = new ConcurrentHashMap<String, ThreadPool>();
    private static final Map<Long, String> correlationIdMap = new ConcurrentHashMap<Long, String>();
    private static final ThreadPool SYSTEM = Threads.lookup("SYSTEM");
    private static final ConcurrentMap<String, Queue<?>> workers = Maps.newConcurrentMap();
    private static final AtomicLong currId = new AtomicLong(0L);

    public static void setCorrelationId(String corrId) {
        Threads.setCorrelationId(Thread.currentThread().getId(), corrId);
    }

    public static void setCorrelationId(long threadId, String corrId) {
        if (threadId > 0L && corrId != null) {
            correlationIdMap.put(threadId, corrId);
        }
    }

    public static void unsetCorrelationId() {
        Threads.unsetCorrelationId(Thread.currentThread().getId());
    }

    public static void unsetCorrelationId(long threadId) {
        correlationIdMap.remove(threadId);
    }

    public static String getCorrelationId() {
        return Threads.getCorrelationId(Thread.currentThread().getId());
    }

    public static String getCorrelationId(long threadId) {
        if (correlationIdMap.containsKey(threadId)) {
            return correlationIdMap.get(threadId);
        }
        return null;
    }

    public static ThreadPool lookup(Class<? extends ComponentId> group, Class owningClass) {
        return Threads.lookup(ComponentIds.lookup(group).name() + ":" + owningClass.getSimpleName());
    }

    public static ThreadPool lookup(ServiceConfiguration config) {
        return Threads.lookup(config.getComponentId().getClass(), config.getClass(), config.getFullName().toString());
    }

    public static ThreadPool lookup(Class<? extends ComponentId> group, Class owningClass, String name) {
        return Threads.lookup(ComponentIds.lookup(group).name() + ":" + owningClass.getSimpleName() + ":" + name);
    }

    public static ThreadPool lookup(Class<? extends ComponentId> group) {
        return Threads.lookup(ComponentIds.lookup(group).name());
    }

    private static ThreadPool lookup(String threadGroupName) {
        String groupName = PREFIX + threadGroupName;
        if (execServices.containsKey(groupName)) {
            return (ThreadPool)execServices.get(groupName);
        }
        LOG.trace((Object)("CREATE thread threadpool named: " + groupName));
        ThreadPool f = new ThreadPool(groupName);
        if (execServices.putIfAbsent(f.getName(), f) != null) {
            LOG.warn((Object)("SHUTDOWN:" + f.getName() + " Freeing duplicate thread pool..."));
            f.free();
        }
        return (ThreadPool)execServices.get(groupName);
    }

    public static Thread newThread(Runnable r, String name) {
        LOG.debug((Object)("CREATE new thread named: " + name + " using: " + r.getClass()));
        return new Thread(SYSTEM.getGroup(), r, name);
    }

    public static Thread newThread(Runnable r) {
        LOG.debug((Object)("CREATE new thread using: " + r.getClass()));
        return new Thread(SYSTEM.getGroup(), r);
    }

    public static ExecutorService currentThreadExecutor() {
        return new AbstractExecutorService(){
            private final Lock lock = new ReentrantLock();
            private final Condition termination = this.lock.newCondition();
            private int runningTasks = 0;
            private boolean shutdown = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Runnable command) {
                this.startTask();
                try {
                    command.run();
                }
                finally {
                    this.endTask();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isShutdown() {
                this.lock.lock();
                try {
                    boolean bl = this.shutdown;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown() {
                this.lock.lock();
                try {
                    this.shutdown = true;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public List<Runnable> shutdownNow() {
                this.shutdown();
                return Collections.emptyList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTerminated() {
                this.lock.lock();
                try {
                    boolean bl = this.shutdown && this.runningTasks == 0;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                long nanos = unit.toNanos(timeout);
                this.lock.lock();
                try {
                    while (true) {
                        if (this.isTerminated()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (nanos <= 0L) {
                            boolean bl = false;
                            return bl;
                        }
                        nanos = this.termination.awaitNanos(nanos);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void startTask() {
                this.lock.lock();
                try {
                    if (this.isShutdown()) {
                        throw new RejectedExecutionException("Executor already shutdown");
                    }
                    ++this.runningTasks;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void endTask() {
                this.lock.lock();
                try {
                    --this.runningTasks;
                    if (this.isTerminated()) {
                        this.termination.signalAll();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        };
    }

    public static Predicate<StackTraceElement> filterStackByQualifiedName(String pattern) {
        return Threads.filterStack(pattern, StackTraceElementTransform.FQNAME);
    }

    public static Predicate<StackTraceElement> filterStackByFileName(String pattern) {
        return Threads.filterStack(pattern, StackTraceElementTransform.FQNAME);
    }

    public static Predicate<StackTraceElement> filterStack(final String pattern, final Function<StackTraceElement, CharSequence> toMatch) {
        return new Predicate<StackTraceElement>(){
            final Pattern p;
            {
                this.p = Pattern.compile(pattern);
            }

            public boolean apply(StackTraceElement input) {
                return this.p.matcher((CharSequence)toMatch.apply((Object)input)).matches();
            }
        };
    }

    public static Collection<StackTraceElement> filteredStack(Predicate<StackTraceElement> filter) {
        return Collections2.filter(Arrays.asList(Thread.currentThread().getStackTrace()), filter);
    }

    public static StackTraceElement currentStackFrame(int offset) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int len = stack.length;
        return stack[Ints.min((int[])new int[]{len - 1, 2 + offset})];
    }

    public static StackTraceElement currentStackFrame() {
        return Thread.currentThread().getStackTrace()[2];
    }

    public static String currentStackRange(int start, int end) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int len = stack.length;
        start = Ints.min((int[])new int[]{Ints.max((int[])new int[]{2, start + 2}), len - 1});
        end = Ints.min((int[])new int[]{Ints.max((int[])new int[]{2, end + 2}), len - 1});
        return Joiner.on((String)"\t\n").join((Object[])Arrays.copyOfRange(stack, start, end));
    }

    public static String currentStackString() {
        return Threads.currentStackRange(0, Integer.MAX_VALUE);
    }

    static String key(Class<? extends ComponentId> compId, Object o) {
        return o instanceof HasFullName ? o.getClass().toString() + ":" + ((HasFullName)o).getFullName().toString() : (o instanceof Class ? ((Class)o).getCanonicalName() : o.toString());
    }

    private static <T extends HasFullName<T>> Queue<T> queue(Class<? extends ComponentId> componentId, T owner, int numWorkers) {
        Queue<T> worker = new Queue<T>(componentId, owner, numWorkers);
        if (workers.containsKey(((Queue)worker).key())) {
            return (Queue)workers.get(((Queue)worker).key());
        }
        if (!((Queue)worker).start() && workers.containsKey(((Queue)worker).key())) {
            return (Queue)workers.get(((Queue)worker).key());
        }
        workers.put(((Queue)worker).key(), worker);
        return worker;
    }

    public static <C> Future<C> enqueue(Class<? extends ComponentId> compId, Class<?> ownerType, Callable<C> callable) {
        return Threads.enqueue(compId, ownerType, NUM_QUEUE_WORKERS, callable);
    }

    public static <C> Future<C> enqueue(Class<? extends ComponentId> compId, Class<?> ownerType, Integer workers, Callable<C> callable) {
        return Threads.enqueue(ServiceConfigurations.createBogus(compId, ownerType), workers, callable);
    }

    public static <C> Future<C> enqueue(ServiceConfiguration config, Class<?> ownerType, Integer workers, Callable<C> callable) {
        return Threads.enqueue(ServiceConfigurations.createBogus(config, ownerType), workers, callable);
    }

    public static <C> Future<C> enqueue(ServiceConfiguration config, Callable<C> callable) {
        return ((Queue)Threads.queue(config.getComponentId().getClass(), config, Threads.NUM_QUEUE_WORKERS)).submit(callable);
    }

    public static <C> Future<C> enqueue(ServiceConfiguration config, Integer workers, Callable<C> callable) {
        return ((Queue)Threads.queue(config.getComponentId().getClass(), config, workers)).submit(callable);
    }

    public static <C> Future<C> enqueue(ServiceConfiguration config, Integer workers, Callable<C> callable, String correlationId) {
        return ((Queue)Threads.queue(config.getComponentId().getClass(), config, workers)).submit(correlationId, callable);
    }

    static class Queue<T extends HasFullName<T>>
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final BlockingQueue<FutureTask<?>> msgQueue = new LinkedTransferQueue();
        private final T owner;
        private final Class<?> ownerType;
        private final int numWorkers;
        private final String creationStack;
        private final Class<? extends ComponentId> componentId;
        private final String name;
        private FutureTask<?> currentTask;

        Queue(Class<? extends ComponentId> componentId, T owner, int numWorkers) {
            this.componentId = componentId;
            this.owner = owner;
            this.ownerType = owner.getClass();
            this.name = owner.getFullName().toString();
            this.numWorkers = numWorkers;
            this.creationStack = Threads.currentStackString();
        }

        private boolean start() {
            this.threadPool().limitTo(this.numWorkers);
            if (workers.putIfAbsent(this.key(), this) != null) {
                this.stop();
                return false;
            }
            for (int i = 0; i < this.numWorkers; ++i) {
                this.threadPool().submit(this);
            }
            return true;
        }

        private String key() {
            return this.componentId.getSimpleName() + ":" + this.ownerType.getSimpleName() + ":" + this.owner.getFullName() + "[workers]";
        }

        private void stop() {
            this.running.set(false);
        }

        private ThreadPool threadPool() {
            return Threads.lookup(this.componentId, this.owner.getClass(), this.name);
        }

        private <C> Future<C> submit(Runnable run) {
            return this.submit(null, run);
        }

        private <C> Future<C> submit(String correlationId, final Runnable run) {
            final GenericCheckedListenableFuture f = new GenericCheckedListenableFuture();
            Callable call = new Callable<C>(){

                @Override
                public C call() throws Exception {
                    try {
                        run.run();
                        f.set(null);
                    }
                    catch (Exception ex) {
                        f.setException(ex);
                    }
                    return null;
                }

                public String toString() {
                    return run.toString() + super.toString();
                }
            };
            return this.submit(correlationId, call);
        }

        private <C> Future<C> submit(Callable<C> call) {
            return this.submit(null, call);
        }

        private <C> Future<C> submit(String correlationId, final Callable<C> call) {
            EucaFutureTask f = new EucaFutureTask<C>(correlationId, call){

                @Override
                public String toString() {
                    return Thread.currentThread().getName() + ":" + super.toString() + " " + call.toString();
                }
            };
            this.msgQueue.add(f);
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                try {
                    FutureTask<?> futureTask = this.msgQueue.take();
                    if (futureTask == null) continue;
                    this.currentTask = futureTask;
                    Logs.extreme().debug((Object)((Object)((Object)EventType.QUEUE) + " " + this.currentTask + " " + Thread.currentThread().getName()));
                    try {
                        futureTask.run();
                    }
                    catch (Exception ex) {
                        Exceptions.maybeInterrupted(ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
                catch (InterruptedException e) {
                    Exceptions.maybeInterrupted(e);
                    break;
                }
                finally {
                    this.currentTask = null;
                }
            } while (!this.msgQueue.isEmpty() || this.running.get());
            Logs.extreme().debug((Object)("Shutting down worker: " + this.owner + ":" + this.name + " in thread " + Thread.currentThread().getName()));
        }

        private Object getOwner() {
            return this.owner;
        }

        private String getCreationStack() {
            return this.creationStack;
        }

        private AtomicBoolean getRunning() {
            return this.running;
        }

        private int getNumWorkers() {
            return this.numWorkers;
        }

        private Class<? extends ComponentId> getComponentId() {
            return this.componentId;
        }

        private String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QueuedWorker ");
            if (this.componentId != null) {
                builder.append(this.componentId.getSimpleName()).append(" ");
            }
            if (this.name != null) {
                builder.append(" ").append(this.name).append(":");
            }
            builder.append(this.numWorkers).append(":");
            if (this.running != null) {
                builder.append(this.running.get() ? "RUNNING" : "STOPPED");
            }
            if (this.msgQueue != null) {
                builder.append(":[").append(this.msgQueue.size()).append("]");
            }
            return builder.toString();
        }

        static class EucaFutureTask<C>
        extends FutureTask<C> {
            private String correlationId = null;

            public EucaFutureTask(String correlationId, Callable<C> callable) {
                super(callable);
                this.correlationId = correlationId;
                if (callable instanceof EucaCallable && correlationId == null) {
                    this.correlationId = ((EucaCallable)callable).getCorrelationId();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Threads.setCorrelationId(this.correlationId);
                    super.run();
                }
                finally {
                    Threads.unsetCorrelationId();
                }
            }
        }
    }

    static enum StackTraceElementTransform implements Function<StackTraceElement, CharSequence>
    {
        FQNAME{

            @Override
            public CharSequence apply(StackTraceElement input) {
                return input.getClassName();
            }
        }
        ,
        FILENAME{

            @Override
            public CharSequence apply(StackTraceElement input) {
                return input.getFileName();
            }
        };


        public abstract CharSequence apply(StackTraceElement var1);
    }

    public static class ThreadPool
    implements ThreadFactory,
    ExecutorService {
        private final ThreadGroup group;
        private final String name;
        private ExecutorService pool;
        private Integer numThreads = -1;
        private final StackTraceElement[] creationPoint;
        private final LinkedBlockingQueue<Future<?>> taskQueue = new LinkedBlockingQueue();
        private static final Runnable[] EMPTY = new Runnable[0];

        private ThreadPool(String groupPrefix, Integer threadCount) {
            this(groupPrefix);
            this.numThreads = threadCount;
        }

        private ThreadPool(String groupPrefix) {
            this.creationPoint = Thread.currentThread().getStackTrace();
            this.name = groupPrefix;
            this.group = new ThreadGroup(this.name);
            this.pool = this.makePool();
            OrderedShutdown.registerPostShutdownHook(new Runnable(){

                @Override
                public void run() {
                    LOG.warn((Object)("SHUTDOWN:" + ThreadPool.this.name + " Stopping thread pool..."));
                    if (ThreadPool.this.pool != null) {
                        ThreadPool.this.free();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadPool limitTo(Integer numThreads) {
            if (this.numThreads.equals(numThreads)) {
                return this;
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.numThreads.equals(numThreads)) {
                    return this;
                }
                this.numThreads = numThreads;
                ExecutorService oldExec = this.pool;
                this.pool = null;
                if (oldExec != null) {
                    oldExec.shutdown();
                }
                this.pool = this.makePool();
            }
            return this;
        }

        public ThreadGroup getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getExecutorService() {
            if (this.pool != null) {
                return this.pool;
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.pool == null) {
                    this.pool = this.makePool();
                }
            }
            return this;
        }

        public ExecutorService makePool() {
            ExecutorService newPool;
            ExecutorService executorService = newPool = this.numThreads == -1 ? Executors.newCachedThreadPool((java.util.concurrent.ThreadFactory)((Object)this)) : Executors.newFixedThreadPool(this.numThreads, (java.util.concurrent.ThreadFactory)((Object)this));
            if (newPool instanceof ThreadPoolExecutor) {
                ((ThreadPoolExecutor)newPool).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            }
            return newPool;
        }

        public List<Runnable> free() {
            List<Object> ret = Lists.newArrayList();
            ret = this.pool.shutdownNow();
            for (Runnable r : ret) {
                LOG.warn((Object)("SHUTDOWN:" + this.name + " - Pending task: " + r.getClass() + " [" + r.toString() + "]"));
            }
            try {
                for (int i = 0; i < 10 && !this.pool.awaitTermination(1L, TimeUnit.SECONDS); ++i) {
                    LOG.warn((Object)("SHUTDOWN:" + this.name + " - Waiting for pool to shutdown."));
                    if (i <= 2) continue;
                    LOG.warn((Object)Joiner.on((String)"\n\t\t").join((Object[])this.creationPoint));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error((Object)e, (Throwable)e);
            }
            return ret;
        }

        public Thread newThread(Runnable r) {
            return new Thread(this.group, r, this.group.getName() + "." + r.getClass() + "#" + threadIndex.incrementAndGet());
        }

        @Override
        public void execute(Runnable command) {
            this.pool.execute(command);
        }

        @Override
        public void shutdown() {
            this.pool.shutdown();
            execServices.remove(this.getName());
        }

        @Override
        public List<Runnable> shutdownNow() {
            execServices.remove(this.getName());
            return this.free();
        }

        @Override
        public boolean isShutdown() {
            return this.pool.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.pool.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.pool.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.pool.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.pool.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.pool.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.pool.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.pool.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.pool.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.pool.invokeAny(tasks, timeout, unit);
        }

        public Thread newThread(Runnable r, String name) {
            return this.newThread(this.group, r, name);
        }

        public Thread newThread(ThreadGroup group, Runnable r, String name) {
            return new Thread(group, r, this.group.getName() + "." + r.getClass().getName() + "#" + threadIndex.incrementAndGet() + "#" + name);
        }

        public void setPattern(String pattern) {
        }

        public void setIncludeClusterName(boolean includeClusterName) {
        }

        public void setClusterName(String channelName) {
        }

        public void setAddress(String address) {
        }

        public void renameThread(String base_name, Thread thread) {
            thread.setName(base_name);
        }

        private <T> LinkedBlockingQueue<Future<?>> getTaskQueue() {
            return this.taskQueue;
        }
    }

    public static interface EucaCallable<C>
    extends Callable<C> {
        public String getCorrelationId();
    }
}

