/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.BaseDirectory;
import java.io.File;
import org.apache.log4j.Logger;

public enum SubDirectory {
    SYSFAULTS(BaseDirectory.LIB, "faults"),
    CUSTOMFAULTS(BaseDirectory.HOME, "/etc/eucalyptus/faults"),
    DB(BaseDirectory.STATE, "db"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R 700 " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
    ,
    BACKUPS(BaseDirectory.STATE, "backups"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R 700 " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
    ,
    TX(BaseDirectory.RUN, "/tx"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R 700 " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
    ,
    CLASSCACHE(BaseDirectory.RUN, "/classcache"),
    WWW(BaseDirectory.CONF, "www"),
    WEBAPPS(BaseDirectory.STATE, "webapps"),
    KEYS(BaseDirectory.STATE, "keys"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R 700 " + this.toString());
                Groovyness.exec("chgrp -R -L " + System.getProperty("euca.user") + " " + this.toString());
                Groovyness.exec("chown -R -L " + System.getProperty("euca.user") + " " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
    ,
    SCRIPTS(BaseDirectory.CONF, "scripts"),
    MANAGEMENT(BaseDirectory.CONF, "jmx"),
    STATUS(BaseDirectory.RUN, "status"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R 760 " + this.toString());
                Groovyness.exec("chgrp -R -L " + System.getProperty("euca.status_group") + " " + this.toString());
                Groovyness.exec("chown -R -L " + System.getProperty("euca.user") + " " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
    ,
    UPGRADE(BaseDirectory.VAR, "upgrade"),
    REPORTS(BaseDirectory.CONF, "reports"),
    CONF(BaseDirectory.CONF, "conf"),
    QUEUE(BaseDirectory.VAR, "queue"),
    LIB(BaseDirectory.LIB, ""),
    RUNDB(BaseDirectory.RUN, "/db"){

        @Override
        protected void assertPermissions() {
            super.assertPermissions();
            try {
                Groovyness.exec("chmod -R -L +rwX " + this.toString());
                Groovyness.exec("chgrp -R -L " + System.getProperty("euca.user") + " " + this.toString());
            }
            catch (ScriptExecutionFailedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    };

    private static Logger LOG;
    BaseDirectory parent;
    String dir;

    private SubDirectory(BaseDirectory parent, String dir) {
        this.parent = parent;
        this.dir = dir;
    }

    public String toString() {
        return this.parent.toString() + File.separator + this.dir;
    }

    public File getFile() {
        return new File(this.toString());
    }

    public void check() {
        File dir = new File(this.toString());
        if (dir.exists()) {
            this.assertPermissions();
        } else {
            EventRecord.here(SubDirectory.class, EventType.SYSTEM_DIR_CREATE, this.name(), this.toString()).info();
            if (dir.mkdirs()) {
                this.assertPermissions();
            }
        }
    }

    public File getChildFile(String ... path) {
        return new File(this.getChildPath(path));
    }

    public boolean hasChild(String ... path) {
        return this.getChildFile(path).exists();
    }

    public String getChildPath(String ... path) {
        String ret = this.toString();
        for (String s : path) {
            ret = ret + File.separator + s;
        }
        return ret;
    }

    protected void assertPermissions() {
        try {
            Groovyness.exec("chown -R  " + System.getProperty("euca.user") + " " + this.toString());
            Groovyness.exec("chgrp -R  " + System.getProperty("euca.user") + " " + this.toString());
            Groovyness.exec("chmod -R  +rwX " + this.toString());
        }
        catch (ScriptExecutionFailedException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    static {
        LOG = Logger.getLogger(SubDirectory.class);
    }
}

