/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.system.log.EucaLoggingEvent;
import com.eucalyptus.system.log.EucaPatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.hibernate.exception.GenericJDBCException;

public class RequestTrackingLayout
extends EucaPatternLayout {
    private static final String DEFAULT_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.5p | [%o] %m%n";
    private static final String DEBUG_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.5p %-24.24c{1} | [%o] %m%n";
    private static final String EXTREME_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.9p %-24.24c{1} %-33.33f | [%o] %m%n";
    private String CONTINUATION = "[%o] %m%n";
    private EucaPatternLayout continuation = null;
    private final EucaPatternLayout extremeLayout;
    private final EucaPatternLayout debugLayout = new EucaPatternLayout("%d{yyyy-MM-dd HH:mm:ss} %5.5p %-24.24c{1} | [%o] %m%n");

    public RequestTrackingLayout() {
        super(DEFAULT_LOG_PATTERN);
        this.extremeLayout = new EucaPatternLayout(EXTREME_LOG_PATTERN);
    }

    private String mainFormat(LoggingEvent e) {
        if (Logs.isExtrrreeeme()) {
            return this.extremeLayout.format(e);
        }
        if (Logs.isDebug()) {
            return this.debugLayout.format(e);
        }
        return super.format(e);
    }

    public String format(LoggingEvent event) {
        try {
            Throwable t;
            String corrId = null;
            try {
                corrId = Contexts.lookup().getCorrelationId();
            }
            catch (Exception ex) {
                corrId = Threads.getCorrelationId();
            }
            if (corrId == null || corrId.length() < 36) {
                return "";
            }
            if (event.getThrowableInformation() != null ? (t = event.getThrowableInformation().getThrowable()) != null && t instanceof GenericJDBCException : event.getFQNOfLoggerClass().matches(".*JDBCExceptionReporter.*")) {
                return "";
            }
            String renderedMessage = event.getRenderedMessage();
            if (renderedMessage != null) {
                String[] messages = renderedMessage.split("\n");
                StringBuffer sb = new StringBuffer();
                boolean con = false;
                for (int i = 0; i < messages.length; ++i) {
                    String substring = messages[i];
                    EucaLoggingEvent n = new EucaLoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), substring, event.getThreadName(), event.getThrowableInformation(), null, null, null);
                    n.setProperty("correlation-id", corrId);
                    sb.append(!con ? this.mainFormat(n) : this.continuation.format(n));
                    if (this.continuation == null) {
                        this.continuation = new EucaPatternLayout(sb.toString().split("\\|")[0].replaceAll(".", " ") + "| " + this.CONTINUATION);
                    }
                    con = true;
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

