/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.records.Logs;
import com.eucalyptus.system.log.EucaLoggingEvent;
import com.eucalyptus.system.log.EucaPatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.hibernate.exception.GenericJDBCException;

public class EucaLayout
extends EucaPatternLayout {
    private static final String DEFAULT_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.5p | %m%n";
    private static final String DEBUG_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.5p %9.9i %-24.24c{1} | %m%n";
    private static final String EXTREME_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %5.9p %9.9i %-24.24c{1} %-33.33f | %m%n";
    private String CONTINUATION = "%m%n";
    private EucaPatternLayout continuation = null;
    private final EucaPatternLayout extremeLayout;
    private final EucaPatternLayout debugLayout = new EucaPatternLayout("%d{yyyy-MM-dd HH:mm:ss} %5.5p %9.9i %-24.24c{1} | %m%n");

    public EucaLayout() {
        super(DEFAULT_LOG_PATTERN);
        this.extremeLayout = new EucaPatternLayout(EXTREME_LOG_PATTERN);
    }

    private String mainFormat(LoggingEvent e) {
        if (Logs.isExtrrreeeme()) {
            return this.extremeLayout.format(e);
        }
        if (Logs.isDebug()) {
            return this.debugLayout.format(e);
        }
        return super.format(e);
    }

    public String format(LoggingEvent event) {
        try {
            Throwable t;
            if (event.getThrowableInformation() != null ? (t = event.getThrowableInformation().getThrowable()) != null && t instanceof GenericJDBCException : event.getFQNOfLoggerClass().matches(".*JDBCExceptionReporter.*")) {
                return "";
            }
            String renderedMessage = event.getRenderedMessage();
            if (renderedMessage != null) {
                String[] messages = renderedMessage.split("\n");
                StringBuffer sb = new StringBuffer();
                boolean con = false;
                for (int i = 0; i < messages.length; ++i) {
                    String substring = messages[i];
                    EucaLoggingEvent n = new EucaLoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), substring, event.getThreadName(), event.getThrowableInformation(), null, null, null);
                    sb.append(!con ? this.mainFormat(n) : this.continuation.format(n));
                    if (this.continuation == null) {
                        this.continuation = new EucaPatternLayout(sb.toString().split("\\|")[0].replaceAll(".", " ") + "| " + this.CONTINUATION);
                    }
                    con = true;
                }
                return sb.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

