/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.system.SubDirectory;
import org.apache.log4j.Logger;

@Provides(value=Empyrean.class)
@RunDuring(value=Bootstrap.Stage.UnprivilegedConfiguration)
public class DirectoryBootstrapper
extends Bootstrapper {
    private static Logger LOG = Logger.getLogger(DirectoryBootstrapper.class);

    @Override
    public boolean load() throws Exception {
        for (BaseDirectory baseDirectory : BaseDirectory.values()) {
            EventRecord.here(DirectoryBootstrapper.class, EventType.SYSTEM_DIR_CHECK, baseDirectory.name(), baseDirectory.toString()).info();
            baseDirectory.check();
        }
        for (Enum enum_ : SubDirectory.values()) {
            EventRecord.here(DirectoryBootstrapper.class, EventType.SYSTEM_DIR_CHECK, enum_.name(), ((SubDirectory)enum_).toString()).info();
            ((SubDirectory)enum_).check();
            System.setProperty("com.eucalyptus.dir." + enum_.name().toLowerCase(), ((SubDirectory)enum_).getFile().getAbsolutePath());
        }
        return true;
    }

    @Override
    public boolean start() throws Exception {
        return true;
    }

    @Override
    public boolean enable() throws Exception {
        return true;
    }

    @Override
    public boolean stop() throws Exception {
        return true;
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public boolean disable() throws Exception {
        return true;
    }

    @Override
    public boolean check() throws Exception {
        return true;
    }
}

