/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.util.async.Futures;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class Capabilities {
    private static final Logger logger = Logger.getLogger(Capabilities.class);
    private static final LinkedBlockingQueue<RunnableFuture<?>> capabilitiesRunnableQueue = new LinkedBlockingQueue();
    private static final ReadWriteLock capabilitiesRunnerLock = new ReentrantReadWriteLock();
    private static volatile Thread capabilitiesRunner = null;

    public static <T> T runWithCapabilities(Callable<T> callable) throws Exception {
        Capabilities.checkInitialized();
        RunnableFuture<T> future = Futures.resultOf(callable);
        capabilitiesRunnableQueue.add(future);
        return (T)future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        capabilitiesRunnerLock.writeLock().lock();
        try {
            if (capabilitiesRunner == null) {
                Thread runner = new Thread((Runnable)new CapabilitiesRunnable(), "Capabilities-Thread");
                runner.start();
                capabilitiesRunner = runner;
            }
        }
        finally {
            capabilitiesRunnerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInitialized() {
        capabilitiesRunnerLock.readLock().lock();
        try {
            if (capabilitiesRunner == null) {
                throw new IllegalStateException("Not initialized");
            }
        }
        finally {
            capabilitiesRunnerLock.readLock().unlock();
        }
    }

    private static final class CapabilitiesRunnable
    implements Runnable {
        private CapabilitiesRunnable() {
        }

        @Override
        public void run() {
            logger.debug((Object)"Running capabilities executor");
            try {
                while (true) {
                    RunnableFuture startFuture;
                    if ((startFuture = (RunnableFuture)capabilitiesRunnableQueue.take()) == null) {
                        continue;
                    }
                    logger.debug((Object)("Running capabilities task: " + startFuture));
                    startFuture.run();
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.debug((Object)"Exiting capabilities executor (interrupted)");
                return;
            }
        }
    }
}

