/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.SubDirectory;
import java.io.File;
import org.apache.log4j.Logger;

public enum BaseDirectory {
    HOME("euca.home"),
    VAR("euca.var.dir"),
    CONF("euca.conf.dir"),
    LIB("euca.lib.dir"),
    LOG("euca.log.dir"),
    RUN("euca.run.dir"),
    LIBEXEC("euca.libexec.dir"),
    STATE("euca.state.dir"),
    JNI("euca.jni.dir");

    private static Logger LOGG;
    private String key;

    private BaseDirectory(String key) {
        this.key = key;
    }

    public boolean check() {
        if (System.getProperty(this.key) == null) {
            LOGG.fatal((Object)("System property '" + this.key + "' must be set."));
            return false;
        }
        this.create();
        return true;
    }

    public String toString() {
        return System.getProperty(this.key);
    }

    public File getFile() {
        return new File(this.toString());
    }

    public void create() {
        File dir = new File(this.toString());
        if (!dir.exists()) {
            EventRecord.here(SubDirectory.class, EventType.SYSTEM_DIR_CREATE, this.name(), this.toString()).info();
            if (dir.mkdirs()) {
                this.assertPermissions();
            }
        }
    }

    public File getChildFile(String ... path) {
        return new File(this.getChildPath(path));
    }

    public String getChildPath(String ... args) {
        String ret = this.toString();
        for (String s : args) {
            ret = ret + File.separator + s;
        }
        return ret;
    }

    private void assertPermissions() {
        try {
            Groovyness.exec("chown " + System.getProperty("euca.user") + " " + this.toString());
        }
        catch (ScriptExecutionFailedException ex) {
            LOGG.error((Object)ex, (Throwable)ex);
        }
        try {
            Groovyness.exec("chmod og-rwX " + this.toString());
        }
        catch (ScriptExecutionFailedException ex) {
            LOGG.error((Object)ex, (Throwable)ex);
        }
    }

    static {
        LOGG = Logger.getLogger(BaseDirectory.class);
    }
}

