/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.system;

import com.eucalyptus.util.Classes;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.NoSuchElementException;

public class Ats
implements Predicate<Class> {
    private final List<AnnotatedElement> ancestry = Lists.newArrayList();
    private static final LoadingCache<Object, Ats> atsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Object, Ats>(){

        public Ats load(Object input) {
            if (input instanceof Class) {
                return new Ats(new AnnotatedElement[]{(AnnotatedElement)input});
            }
            if (input instanceof AnnotatedElement) {
                return new Ats(new AnnotatedElement[]{(AnnotatedElement)input});
            }
            return new Ats(new AnnotatedElement[]{input.getClass()});
        }
    });
    private static final LoadingCache<Object, Ats> atsHierarchyCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Object, Ats>(){

        public Ats load(Object input) {
            if (input instanceof AnnotatedElement) {
                return new Ats((AnnotatedElement[])Classes.ancestors(input).toArray(new Class[0]));
            }
            return new Ats((AnnotatedElement[])Classes.ancestors(input).toArray(new Class[0]));
        }
    });

    private Ats(AnnotatedElement ... ancestry) {
        for (AnnotatedElement c : ancestry) {
            if (!(c instanceof AnnotatedElement)) continue;
            this.ancestry.add(c);
        }
    }

    public <A extends Annotation> boolean has(Class<A> annotation) {
        for (AnnotatedElement a : this.ancestry) {
            if (a.isAnnotationPresent(annotation)) {
                return true;
            }
            if (!(a instanceof Class)) continue;
            for (Class<?> inter : ((Class)a).getInterfaces()) {
                if (!inter.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public <A extends Annotation> A get(Class<A> annotation) {
        AnnotatedElement decl = this.find(annotation);
        return decl == null ? null : (A)decl.getAnnotation(annotation);
    }

    public <A extends Annotation, T> Class<T> findAncestor(Class<A> annotation) {
        for (AnnotatedElement a : this.ancestry) {
            if (!(a instanceof Class) || !a.isAnnotationPresent(annotation)) continue;
            return (Class)a;
        }
        throw new NoSuchElementException("Failed to find ancestor with @" + annotation.getSimpleName() + " for root class " + this.getRootClass().getSimpleName());
    }

    public <A extends Annotation> AnnotatedElement find(Class<A> annotation) {
        for (AnnotatedElement a : this.ancestry) {
            if (a.isAnnotationPresent(annotation)) {
                return a;
            }
            if (!(a instanceof Class)) continue;
            for (Class<?> inter : ((Class)a).getInterfaces()) {
                if (!inter.isAnnotationPresent(annotation)) continue;
                return inter;
            }
        }
        return this.getRootClass();
    }

    private Class getRootClass() {
        AnnotatedElement a = this.ancestry.get(0);
        return a instanceof Class ? (Class)a : null;
    }

    public static Ats from(Object o) {
        if (o instanceof AccessibleObject) {
            return (Ats)atsCache.getUnchecked(o);
        }
        return (Ats)atsCache.getUnchecked(Classes.typeOf(o));
    }

    public static Ats inClassHierarchy(Object o) {
        if (o instanceof AccessibleObject) {
            return (Ats)atsHierarchyCache.getUnchecked(o);
        }
        return (Ats)atsHierarchyCache.getUnchecked(Classes.typeOf(o));
    }

    List<AnnotatedElement> getAncestry() {
        return this.ancestry;
    }

    public String toString() {
        return String.format("Ats:class=%s\nAts:ancestor=%s", this.getRootClass(), Joiner.on((String)"Ats:ancestor=").join((Iterable)Lists.transform(this.ancestry, (Function)AnnotatedElementToString.INSTANCE)));
    }

    public boolean apply(Class input) {
        return this.has(input);
    }

    static enum AnnotatedElementToString implements Function<AnnotatedElement, String>
    {
        INSTANCE;


        public String apply(AnnotatedElement input) {
            return input.toString() + ":" + "[" + Joiner.on((String)",").join((Object[])input.getAnnotations()) + "]";
        }
    }
}

