/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.scripting;

import com.eucalyptus.scripting.ScriptExecutionFailedException;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Maps;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.ReadOnlyPropertyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.log4j.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;

public class Groovyness {
    private static Logger LOG = Logger.getLogger(Groovyness.class);
    public static ScriptEngine groovyEngine = Groovyness.getGroovyEngine();

    public static <T extends GroovyObject> T expandoMetaClass(T obj) {
        ExpandoMetaClass emc = new ExpandoMetaClass(obj.getClass(), false);
        emc.initialize();
        obj.setMetaClass((MetaClass)emc);
        return obj;
    }

    private static GroovyClassLoader getGroovyClassLoader() {
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle((MetaClassRegistry.MetaClassCreationHandle)new ExpandoMetaClassCreationHandle());
        CompilerConfiguration config = new CompilerConfiguration();
        config.setDebug(true);
        config.setVerbose(true);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent);
        loader.setShouldRecompile(Boolean.valueOf(true));
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine getGroovyEngine() {
        Class<Groovyness> clazz = Groovyness.class;
        synchronized (Groovyness.class) {
            if (groovyEngine == null) {
                GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle((MetaClassRegistry.MetaClassCreationHandle)new ExpandoMetaClassCreationHandle());
                ScriptEngineManager manager = new ScriptEngineManager((ClassLoader)Groovyness.getGroovyClassLoader());
                groovyEngine = manager.getEngineByName("groovy");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return groovyEngine;
        }
    }

    public static <T> T newInstance(String fileName) throws ScriptExecutionFailedException {
        GroovyObject groovyObject = null;
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                f = new File((Object)((Object)SubDirectory.SCRIPTS) + File.separator + fileName + (fileName.endsWith(".groovy") ? "" : ".groovy"));
            }
            GroovyClassLoader loader = Groovyness.getGroovyClassLoader();
            Class groovyClass = loader.parseClass(f);
            groovyObject = (GroovyObject)groovyClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new ScriptExecutionFailedException(e);
        }
        try {
            return (T)groovyObject;
        }
        catch (ClassCastException e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new ScriptExecutionFailedException(e.getMessage(), e);
        }
    }

    public static <T> T run(SubDirectory dir, String fileName, Map context) {
        fileName = (Object)((Object)dir) + File.separator + fileName;
        String fileNameWExt = fileName + ".groovy";
        if (!new File(fileName).exists() && new File(fileNameWExt).exists()) {
            fileName = fileNameWExt;
        }
        FileReader fileReader = null;
        try {
            Object ret;
            fileReader = new FileReader(fileName);
            SimpleBindings bindings = new SimpleBindings(context);
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setBindings(bindings, 100);
            Object object = ret = Groovyness.getGroovyEngine().eval((Reader)fileReader, (ScriptContext)scriptContext);
            return (T)object;
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new RuntimeException("Executing the requested script failed: " + fileName, e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    public static <T> T run(SubDirectory dir, String fileName) {
        return Groovyness.run(dir, fileName, Maps.newHashMap());
    }

    public static <T> T run(String fileName) {
        return Groovyness.run(SubDirectory.SCRIPTS, fileName);
    }

    public static int exec(final String code) throws ScriptExecutionFailedException {
        try {
            return (Integer)Groovyness.getGroovyEngine().eval("p=hi.execute();p.waitFor();System.out.print(p.in.text);System.err.print(p.err.text);p.exitValue()", (ScriptContext)new SimpleScriptContext(){
                {
                    this.setAttribute("hi", code, 100);
                }
            });
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new ScriptExecutionFailedException("Executing the requested script failed: " + code, e);
        }
    }

    public static <T> T eval(String code, Map context) throws ScriptExecutionFailedException {
        try {
            SimpleBindings bindings = new SimpleBindings(context);
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setBindings(bindings, 100);
            return (T)Groovyness.getGroovyEngine().eval(code, (ScriptContext)scriptContext);
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new ScriptExecutionFailedException("Executing the requested script failed:\n============================\n" + code + "============================\n" + "\nbecause of:\n" + Exceptions.causeString(e), e);
        }
    }

    public static <T> T eval(String code) throws ScriptExecutionFailedException {
        try {
            return (T)Groovyness.getGroovyEngine().eval(code);
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new ScriptExecutionFailedException("Executing the requested script failed:\n============================\n" + code + "============================\n" + "\nbecause of:\n" + Exceptions.causeString(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig(String confFile) {
        block12: {
            try {
                confFile = (Object)((Object)SubDirectory.SCRIPTS) + File.separator + confFile;
                String className = Thread.currentThread().getStackTrace()[2].getClassName();
                LOG.info((Object)("Trying to load config for " + className + " from " + confFile));
                String conf = "import " + className;
                String line = null;
                try (BufferedReader fileReader = null;){
                    fileReader = new BufferedReader(new FileReader(confFile));
                    while ((line = fileReader.readLine()) != null) {
                        conf = conf + (!line.matches("\\s*\\w+\\s*=[\\s\\.\\w*\"']*;{0,1}") ? "" : "\n" + className + "." + line);
                    }
                    LOG.debug((Object)conf);
                    try {
                        Groovyness.getGroovyEngine().eval(conf);
                    }
                    catch (ScriptException e) {
                        if (!(e.getCause() instanceof ReadOnlyPropertyException)) {
                            LOG.warn((Object)e, (Throwable)e);
                            break block12;
                        }
                        LOG.warn((Object)e.getMessage());
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info((Object)"-> No config file found.");
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
            }
        }
    }
}

