/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class VolumeEvent
implements Event {
    private static final long serialVersionUID = 1L;
    private final EventActionInfo<VolumeAction> actionInfo;
    private final String uuid;
    private final String volumeId;
    private final int sizeGB;
    private final OwnerFullName ownerFullName;
    private final String availabilityZone;

    public static EventActionInfo<VolumeAction> forVolumeCreate() {
        return new EventActionInfo<VolumeAction>(VolumeAction.VOLUMECREATE);
    }

    public static EventActionInfo<VolumeAction> forVolumeDelete() {
        return new EventActionInfo<VolumeAction>(VolumeAction.VOLUMEDELETE);
    }

    public static EventActionInfo.InstanceEventActionInfo<VolumeAction> forVolumeAttach(String instanceUuid, String instanceId) {
        return new EventActionInfo.InstanceEventActionInfo<VolumeAction>(VolumeAction.VOLUMEATTACH, instanceUuid, instanceId);
    }

    public static EventActionInfo.InstanceEventActionInfo<VolumeAction> forVolumeDetach(String instanceUuid, String instanceId) {
        return new EventActionInfo.InstanceEventActionInfo<VolumeAction>(VolumeAction.VOLUMEDETACH, instanceUuid, instanceId);
    }

    public static VolumeEvent with(EventActionInfo<VolumeAction> actionInfo, String uuid, String volumeId, int sizeGB, OwnerFullName ownerFullName, String availabilityZone) {
        return new VolumeEvent(actionInfo, uuid, volumeId, sizeGB, ownerFullName, availabilityZone);
    }

    private VolumeEvent(EventActionInfo<VolumeAction> actionInfo, String uuid, String volumeId, int sizeGB, OwnerFullName ownerFullName, String availabilityZone) {
        Parameters.checkParam(actionInfo, Matchers.notNullValue());
        Parameters.checkParam(uuid, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(sizeGB, Matchers.greaterThan((Comparable)Integer.valueOf(-1)));
        Parameters.checkParam(volumeId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(availabilityZone, Matchers.notNullValue());
        Parameters.checkParam(ownerFullName.getUserId(), Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(ownerFullName.getAccountNumber(), Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(ownerFullName.getUserName(), Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        this.ownerFullName = ownerFullName;
        this.actionInfo = actionInfo;
        this.uuid = uuid;
        this.sizeGB = sizeGB;
        this.volumeId = volumeId;
        this.availabilityZone = availabilityZone;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public long getSizeGB() {
        return this.sizeGB;
    }

    public OwnerFullName getOwner() {
        return this.ownerFullName;
    }

    public EventActionInfo<VolumeAction> getActionInfo() {
        return this.actionInfo;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String toString() {
        return "VolumeEvent [actionInfo=" + this.actionInfo + ", uuid=" + this.uuid + ", sizeGB=" + this.sizeGB + ", ownerName=" + this.ownerFullName.getUserName() + ", volumeId=" + this.volumeId + ", availabilityZone=" + this.availabilityZone + "]";
    }

    public static enum VolumeAction {
        VOLUMECREATE,
        VOLUMEDELETE,
        VOLUMEATTACH,
        VOLUMEDETACH;

    }
}

