/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.util.Parameters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class SnapShotEvent
implements Event {
    private static final long serialVersionUID = 1L;
    private final EventActionInfo<SnapShotAction> actionInfo;
    private final String userId;
    private final String snapshotId;
    private final String uuid;

    public static EventActionInfo<SnapShotAction> forSnapShotCreate(Integer size, String volumeUuid, String volumeId) {
        Parameters.checkParam(size, Matchers.greaterThan((Comparable)Integer.valueOf(-1)));
        Parameters.checkParam(volumeUuid, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(volumeId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        return new CreateActionInfo(size, volumeUuid, volumeId);
    }

    public static EventActionInfo<SnapShotAction> forSnapShotDelete() {
        return new EventActionInfo<SnapShotAction>(SnapShotAction.SNAPSHOTDELETE);
    }

    public static SnapShotEvent with(EventActionInfo<SnapShotAction> actionInfo, String snapShotUUID, String snapshotId, String userId) {
        return new SnapShotEvent(actionInfo, snapShotUUID, snapshotId, userId);
    }

    private SnapShotEvent(EventActionInfo<SnapShotAction> actionInfo, String uuid, String snapshotId, String userId) {
        Parameters.checkParam(actionInfo, Matchers.notNullValue());
        Parameters.checkParam(uuid, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(userId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(snapshotId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        this.actionInfo = actionInfo;
        this.userId = userId;
        this.snapshotId = snapshotId;
        this.uuid = uuid;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getUserId() {
        return this.userId;
    }

    public EventActionInfo<SnapShotAction> getActionInfo() {
        return this.actionInfo;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "SnapShotEvent [actionInfo=" + this.actionInfo + ", userId=" + this.userId + ", snapshotId=" + this.snapshotId + ", uuid=" + this.uuid + "]";
    }

    public static class CreateActionInfo
    extends EventActionInfo<SnapShotAction> {
        private static final long serialVersionUID = 1L;
        private final Integer size;
        private final String volumeId;
        private final String volumeUuid;

        private CreateActionInfo(Integer size, String volumeUuid, String volumeId) {
            super(SnapShotAction.SNAPSHOTCREATE);
            this.size = size;
            this.volumeUuid = volumeUuid;
            this.volumeId = volumeId;
        }

        public Integer getSize() {
            return this.size;
        }

        public String getVolumeUuid() {
            return this.volumeUuid;
        }

        public String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public String toString() {
            return String.format("[action:%s,size:%s]", this.getAction(), this.getSize());
        }
    }

    public static enum SnapShotAction {
        SNAPSHOTCREATE,
        SNAPSHOTDELETE;

    }
}

