/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.reporting.event.S3EventSupport;
import com.eucalyptus.util.Parameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class S3ObjectEvent
extends S3EventSupport<S3ObjectAction> {
    private static final long serialVersionUID = 1L;
    private final String objectKey;
    private final String version;

    public static S3ObjectAction forS3ObjectCreate() {
        return S3ObjectAction.OBJECTCREATE;
    }

    public static S3ObjectAction forS3ObjectDelete() {
        return S3ObjectAction.OBJECTDELETE;
    }

    public static S3ObjectEvent with(@Nonnull S3ObjectAction action, @Nonnull String bucketName, @Nonnull String objectKey, @Nullable String version, @Nonnull String ownerUserId, @Nonnull Long size) {
        return new S3ObjectEvent(action, bucketName, objectKey, version, ownerUserId, size);
    }

    S3ObjectEvent(@Nonnull S3ObjectAction action, @Nonnull String bucketName, @Nonnull String objectKey, @Nullable String version, @Nonnull String ownerUserId, @Nonnull Long size) {
        super(action, bucketName, ownerUserId, size);
        Parameters.checkParam(objectKey, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        this.objectKey = objectKey;
        this.version = version;
    }

    @Nonnull
    public String getObjectKey() {
        return this.objectKey;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "S3ObjectEvent [action=" + this.getAction() + ", ownerUserId=" + this.getOwnerUserId() + ", size=" + this.getSize() + ", bucketName=" + this.getBucketName() + ", objectKey=" + this.getObjectKey() + ", version=" + this.getVersion() + "]";
    }

    public static enum S3ObjectAction {
        OBJECTCREATE,
        OBJECTDELETE;

    }
}

