/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.eucalyptus.util.Parameters;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

class S3EventSupport<E extends Enum<E>>
implements Event {
    private static final long serialVersionUID = 1L;
    private final E action;
    private final String ownerUserId;
    private final Long size;
    private final String bucketName;

    S3EventSupport(@Nonnull E action, @Nonnull String bucketName, @Nonnull String ownerUserId, @Nonnull Long size) {
        Parameters.checkParam(action, Matchers.notNullValue());
        Parameters.checkParam(bucketName, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(ownerUserId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(size, Matchers.notNullValue());
        this.action = action;
        this.ownerUserId = ownerUserId;
        this.size = size;
        this.bucketName = bucketName;
    }

    @Nonnull
    public E getAction() {
        return this.action;
    }

    @Nonnull
    public String getOwnerUserId() {
        return this.ownerUserId;
    }

    @Nonnull
    public Long getSize() {
        return this.size;
    }

    @Nonnull
    public String getBucketName() {
        return this.bucketName;
    }
}

