/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class ResourceAvailabilityEvent
implements Event {
    private static final long serialVersionUID = 1L;
    private final ResourceType type;
    private final Collection<Availability> availability;

    public ResourceAvailabilityEvent(ResourceType type, Availability availability) {
        this(type, Collections.singleton(availability));
    }

    public ResourceAvailabilityEvent(ResourceType type, Collection<Availability> availability) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Type is required");
        this.type = type;
        this.availability = ImmutableList.copyOf(availability);
    }

    public ResourceType getType() {
        return this.type;
    }

    public Collection<Availability> getAvailability() {
        return this.availability;
    }

    public String toString() {
        return String.format("[type:%s,availability:%s]", new Object[]{this.getType(), Joiner.on((String)",").join(this.getAvailability())});
    }

    public static Function<Tag, String> tagType() {
        return TagTypeFunction.INSTANCE;
    }

    private static enum TagTypeFunction implements Function<Tag, String>
    {
        INSTANCE;


        public String apply(Tag tag) {
            return tag.getType();
        }
    }

    public static final class Type
    extends Tag {
        private static final long serialVersionUID = 1L;

        public Type(String type, String value) {
            super(type, value);
        }
    }

    public static final class Dimension
    extends Tag {
        private static final long serialVersionUID = 1L;

        public Dimension(String type, String value) {
            super(type, value);
        }
    }

    public static abstract class Tag
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String value;

        protected Tag(String type, String value) {
            Preconditions.checkNotNull((Object)type, (Object)"Type is required");
            Preconditions.checkNotNull((Object)value, (Object)"Value is required");
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("[tag:%s=%s]", this.getType(), this.getValue());
        }
    }

    public static final class Availability
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long total;
        private final long available;
        private final Set<Tag> tags;

        public Availability(long total, long available) {
            this(total, available, Collections.emptySet());
        }

        public Availability(long total, long available, Iterable<Tag> tags) {
            this.total = total;
            this.available = available;
            this.tags = ImmutableSet.copyOf(tags);
        }

        public long getTotal() {
            return this.total;
        }

        public long getAvailable() {
            return this.available;
        }

        public Set<Tag> getTags() {
            return this.tags;
        }

        public String toString() {
            return String.format("[total:%d,available:%d,tags:%s]", this.getTotal(), this.getAvailable(), Joiner.on((String)",").join(this.getTags()));
        }
    }

    public static enum ResourceType {
        Instance,
        Core,
        Memory,
        Disk,
        Address,
        StorageWalrus,
        StorageEBS;

    }
}

