/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.eucalyptus.util.Parameters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class InstanceUsageEvent
implements Event {
    private static final long serialVersionUID = 1L;
    private final String uuid;
    private final String instanceId;
    private final String metric;
    private final Long sequenceNum;
    private final String dimension;
    private final Double value;
    private final Long valueTimestamp;

    public InstanceUsageEvent(String uuid, String instanceId, String metric, Long sequenceNum, String dimension, Double value, Long valueTimestamp) {
        Parameters.checkParam(uuid, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(instanceId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(metric, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(sequenceNum, Matchers.notNullValue());
        Parameters.checkParam(dimension, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(value, Matchers.notNullValue());
        Parameters.checkParam(valueTimestamp, Matchers.notNullValue());
        this.uuid = uuid;
        this.instanceId = instanceId;
        this.metric = metric;
        this.sequenceNum = sequenceNum;
        this.dimension = dimension;
        this.value = value;
        this.valueTimestamp = valueTimestamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getMetric() {
        return this.metric;
    }

    public Long getSequenceNum() {
        return this.sequenceNum;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Double getValue() {
        return this.value;
    }

    public Long getValueTimestamp() {
        return this.valueTimestamp;
    }

    public String toString() {
        return "InstanceUsageEvent [uuid=" + this.uuid + ", instanceId=" + this.instanceId + ", metric=" + this.metric + ", sequenceNum=" + this.sequenceNum + ", dimension=" + this.dimension + ", value=" + this.value + ", valueTimestamp=" + this.valueTimestamp + "]";
    }
}

