/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.util.Parameters;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class EventActionInfo<E extends Enum<E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final E action;

    EventActionInfo(E action) {
        Parameters.checkParam(action, Matchers.notNullValue());
        this.action = action;
    }

    public E getAction() {
        return this.action;
    }

    public String toString() {
        return String.format("[action:%s]", this.getAction());
    }

    public static class InstanceEventActionInfo<E extends Enum<E>>
    extends EventActionInfo<E> {
        private static final long serialVersionUID = 1L;
        private final String instanceUuid;
        private final String instanceId;

        InstanceEventActionInfo(E action, String instanceUuid, String instanceId) {
            super(action);
            Parameters.checkParam(instanceUuid, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
            Parameters.checkParam(instanceId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
            this.instanceUuid = instanceUuid;
            this.instanceId = instanceId;
        }

        public String getInstanceUuid() {
            return this.instanceUuid;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String toString() {
            return String.format("[action:%s,instanceUuid:%s,instanceId:%s]", this.getAction(), this.getInstanceUuid(), this.getInstanceId());
        }
    }
}

