/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event;

import com.eucalyptus.event.Event;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;

public class AddressEvent
implements Event {
    private static final long serialVersionUID = 1L;
    private final String address;
    private final String userId;
    private final String userName;
    private final String accountId;
    private final String accountName;
    private final EventActionInfo<AddressAction> actionInfo;

    public static EventActionInfo<AddressAction> forAllocate() {
        return new EventActionInfo<AddressAction>(AddressAction.ALLOCATE);
    }

    public static EventActionInfo<AddressAction> forRelease() {
        return new EventActionInfo<AddressAction>(AddressAction.RELEASE);
    }

    public static EventActionInfo.InstanceEventActionInfo<AddressAction> forAssociate(String instanceUuid, String instanceId) {
        return new EventActionInfo.InstanceEventActionInfo<AddressAction>(AddressAction.ASSOCIATE, instanceUuid, instanceId);
    }

    public static EventActionInfo.InstanceEventActionInfo<AddressAction> forDisassociate(String instanceUuid, String instanceId) {
        return new EventActionInfo.InstanceEventActionInfo<AddressAction>(AddressAction.DISASSOCIATE, instanceUuid, instanceId);
    }

    public static AddressEvent with(String address, OwnerFullName owner, String accountName, EventActionInfo<AddressAction> action) {
        return new AddressEvent(address, owner.getUserId(), owner.getUserName(), owner.getAccountNumber(), (String)Objects.firstNonNull((Object)owner.getAccountName(), (Object)accountName), action);
    }

    private AddressEvent(String address, String userId, String userName, String accountId, String accountName, EventActionInfo<AddressAction> actionInfo) {
        Parameters.checkParam(address, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(userId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(userName, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(accountId, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(accountName, Matchers.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Parameters.checkParam(actionInfo, Matchers.notNullValue());
        this.address = address;
        this.userId = userId;
        this.userName = userName;
        this.accountId = accountId;
        this.accountName = accountName;
        this.actionInfo = actionInfo;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public EventActionInfo<AddressAction> getActionInfo() {
        return this.actionInfo;
    }

    public String toString() {
        return String.format("[address:%s,userId:%s,accountId:%s,actionInfo:%s]", this.address, this.userId, this.accountId, this.actionInfo);
    }

    public static enum AddressAction {
        ALLOCATE,
        RELEASE,
        ASSOCIATE,
        DISASSOCIATE;

    }
}

