/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.records;

import com.eucalyptus.records.Record;
import com.eucalyptus.records.RecordFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Logger;

public enum RecordLevel {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    FATAL,
    ERROR;

    private static Logger LOG;
    private BlockingQueue<Record> pending = new LinkedBlockingDeque<Record>();

    public void enqueue(Record rec) {
        if (RecordFilter.getInstance().accepts(rec)) {
            try {
                this.pending.put(rec);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)e, (Throwable)e);
            }
        }
    }

    public List<Record> drain() {
        ArrayList newEvents = Lists.newArrayList();
        this.pending.drainTo(newEvents);
        return newEvents;
    }

    static {
        LOG = Logger.getLogger(RecordLevel.class);
    }
}

