/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.records;

import com.eucalyptus.bootstrap.SystemBootstrapper;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Threads;
import com.eucalyptus.system.log.EucaHierarchy;
import com.eucalyptus.system.log.EucaLoggingOutputStream;
import com.eucalyptus.system.log.EucaRootLogger;
import com.eucalyptus.system.log.NullEucaLogger;
import com.eucalyptus.util.LogUtil;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.xml.DOMConfigurator;

public class Logs {
    private static Logger LOG;
    private static final Logger nullLogger;
    private static final LogLevelResupplier logLevel;

    public static Logger extreme() {
        return LogLevel.EXTREME.logger();
    }

    public static Logger exhaust() {
        return LogLevel.EXHAUST.logger();
    }

    public static Logger bootstrap() {
        return Logger.getLogger((String)"BOOTSTRAP");
    }

    public static void init() {
        logLevel.get();
        try {
            Logger stdLogger = Logs.isExtrrreeeme() ? Logger.getLogger(SystemBootstrapper.class) : Logs.extreme();
            PrintStream oldOut = System.out;
            PrintStream oldErr = System.err;
            if (!System.getProperty("euca.log.appender", "").equals("console")) {
                System.setOut(new PrintStream(new EucaLoggingOutputStream(stdLogger, Level.INFO), true));
                System.setErr(new PrintStream(new EucaLoggingOutputStream(stdLogger, Level.ERROR), true));
            }
            Logger.getRootLogger().info((Object)LogUtil.subheader("Starting system with debugging set as: " + logLevel.get()));
        }
        catch (Exception t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void reInit() {
        logLevel.recalculate();
        try {
            Logger stdLogger = Logs.isExtrrreeeme() ? Logger.getLogger(SystemBootstrapper.class) : Logs.extreme();
            PrintStream oldOut = System.out;
            PrintStream oldErr = System.err;
            if (!System.getProperty("euca.log.appender", "").equals("console")) {
                System.setOut(new PrintStream(new EucaLoggingOutputStream(stdLogger, Level.INFO), true));
                System.setErr(new PrintStream(new EucaLoggingOutputStream(stdLogger, Level.ERROR), true));
            }
            Logger.getRootLogger().info((Object)LogUtil.subheader("Starting system with debugging set as: " + logLevel.get()));
        }
        catch (Exception t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean isExtrrreeeme() {
        return LogLevel.EXTREME.call();
    }

    public static boolean isDebug() {
        return LogLevel.DEBUG.call();
    }

    public static boolean isTrace() {
        return LogLevel.TRACE.call();
    }

    public static String dump(Object o) {
        String ret = null;
        ret = Logs.groovyDump(o);
        if (ret != null) {
            return ret;
        }
        ret = Logs.groovyInspect(o);
        if (ret != null) {
            return ret;
        }
        return o == null ? Threads.currentStackFrame(1) + ": null" : "" + o;
    }

    public static String groovyDump(final Object o) {
        HashMap ctx = new HashMap(){
            private static final long serialVersionUID = 1L;
            {
                this.put("o", o);
            }
        };
        try {
            return "" + Groovyness.eval("try {return o.dump().replaceAll(\"<\",\"[\").replaceAll(\">\",\"]\").replaceAll(\"[\\\\w\\\\.]+\\\\.(\\\\w+)@\\\\w*\", { Object[] it -> it[1] }).replaceAll(\"class:class [\\\\w\\\\.]+\\\\.(\\\\w+),\", { Object[] it -> it[1] });} catch( Exception e ) {return \"\"+o;}", ctx);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public static String groovyInspect(final Object o) {
        HashMap ctx = new HashMap(){
            private static final long serialVersionUID = 1L;
            {
                this.put("o", o);
            }
        };
        try {
            return "" + Groovyness.eval("try{return o.inspect();}catch(Exception e){return \"\"+o;}", ctx);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return null;
        }
    }

    static {
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %p %m%n")));
        String logLevelProp = "euca.log.level";
        String oldLogLevel = System.getProperty(logLevelProp);
        if ("EXHAUST".equals(oldLogLevel) || "EXTREME".equals(oldLogLevel)) {
            System.setProperty(logLevelProp, "TRACE");
        }
        URL url2 = Thread.currentThread().getContextClassLoader().getResource("log4j.xml");
        EucaHierarchy eucaHierarchy = new EucaHierarchy(new EucaRootLogger(Level.DEBUG));
        new DOMConfigurator().doConfigure(url2, (LoggerRepository)eucaHierarchy);
        LogManager.setRepositorySelector((RepositorySelector)new DefaultRepositorySelector((LoggerRepository)eucaHierarchy), null);
        if (oldLogLevel != null) {
            System.setProperty(logLevelProp, oldLogLevel);
        }
        LOG = Logger.getLogger(Logs.class);
        nullLogger = new NullEucaLogger();
        logLevel = new LogLevelResupplier();
    }

    private static final class LogLevelResupplier {
        private Supplier<LogLevel> realLogLevel;

        LogLevelResupplier() {
            this.recalculate();
        }

        public LogLevel get() {
            return (LogLevel)this.realLogLevel.get();
        }

        public void recalculate() {
            this.realLogLevel = Suppliers.memoize((Supplier)new Supplier<LogLevel>(){

                public LogLevel get() {
                    return LogLevel.get();
                }
            });
        }
    }

    static enum LogLevel implements Callable<Boolean>
    {
        ALL,
        EXHAUST{

            @Override
            String level() {
                return TRACE.name();
            }

            @Override
            String exhaustLevel() {
                return this.level();
            }
        }
        ,
        EXTREME{

            @Override
            String level() {
                return TRACE.name();
            }

            @Override
            String exhaustLevel() {
                return this.level();
            }
        }
        ,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

        private static final String PROP_LOG_LEVEL = "euca.log.level";
        private final Logger logger = Logger.getLogger((String)this.name());

        @Override
        public Boolean call() {
            return logLevel.get().ordinal() <= this.ordinal();
        }

        public Logger logger() {
            if (this.call().booleanValue()) {
                return this.logger;
            }
            return nullLogger;
        }

        private LogLevel init() {
            System.setProperty(PROP_LOG_LEVEL, this.level());
            System.setProperty("euca.exhaust.level", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive.cc", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive.user", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive.db", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive.external", this.exhaustLevel());
            System.setProperty("euca.log.exhaustive.user", this.exhaustLevel());
            return this;
        }

        String level() {
            return this.name();
        }

        String exhaustLevel() {
            return this.ordinal() <= TRACE.ordinal() ? TRACE.name() : FATAL.name();
        }

        static LogLevel get() {
            try {
                return LogLevel.valueOf(System.getProperty(PROP_LOG_LEVEL).toUpperCase()).init();
            }
            catch (IllegalArgumentException ex) {
                if (EXTREME.name().equals(System.getProperty(PROP_LOG_LEVEL).toUpperCase())) {
                    return EXTREME.init();
                }
                throw ex;
            }
            catch (NullPointerException ex) {
                return INFO.init();
            }
        }
    }
}

