/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.records;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.LogFileRecord;
import com.eucalyptus.records.Record;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;

public class EventRecord
extends BaseMessage {
    private static final Logger LOG = Logger.getLogger(EventRecord.class);
    private static final BaseMessage BOGUS = EventRecord.getBogusMessage();
    private static final Supplier<BaseMessage> messageSupplier = EventRecord.getCurrentBaseMessageSupplier();

    private static Record create(Class component, EventClass eventClass, EventType eventName, String other, int dist) {
        StackTraceElement[] stack;
        BaseMessage msg = EventRecord.tryForMessage();
        StackTraceElement ste = stack[dist + 3 < (stack = Thread.currentThread().getStackTrace()).length ? dist + 3 : stack.length - 1];
        String userFn = Bootstrap.isFinished() != false ? "" : "bootstrap";
        try {
            Context ctx = Contexts.lookup(msg.getCorrelationId());
            userFn = ctx.getUserFullName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new LogFileRecord(eventClass, eventName, component, ste, userFn, msg.getCorrelationId(), other);
    }

    public static Record here(Class component, EventClass eventClass, EventType eventName, String ... other) {
        return EventRecord.create(component, eventClass, eventName, EventRecord.getMessageString(other), 1);
    }

    public static Record caller(Class component, EventClass eventClass, EventType eventName, Object ... other) {
        return EventRecord.create(component, eventClass, eventName, EventRecord.getMessageString(other), 2);
    }

    public static Record here(Class component, EventType eventName, String ... other) {
        return EventRecord.create(component, EventClass.ORPHAN, eventName, EventRecord.getMessageString(other), 1);
    }

    public static Record caller(Class component, EventType eventName, Object ... other) {
        return EventRecord.create(component, EventClass.ORPHAN, eventName, EventRecord.getMessageString(other), 2);
    }

    public static boolean isTraceEnabled(Class component) {
        return EventRecord.isEnabledFor(component, Level.TRACE);
    }

    public static boolean isDebugEnabled(Class component) {
        return EventRecord.isEnabledFor(component, Level.DEBUG);
    }

    private static boolean isEnabledFor(Class component, Level level) {
        return Logger.getLogger((Class)component).isEnabledFor((Priority)level);
    }

    private static String getMessageString(Object[] other) {
        StringBuffer last = new StringBuffer();
        if (other != null) {
            for (Object x : other) {
                last.append(":").append(x);
            }
        }
        return last.length() > 1 ? last.substring(1) : last.toString();
    }

    private static BaseMessage getBogusMessage() {
        EucalyptusMessage hi = new EucalyptusMessage();
        hi.setCorrelationId("");
        hi.setUserId("");
        return hi;
    }

    private static BaseMessage tryForMessage() {
        return (BaseMessage)messageSupplier.get();
    }

    private static Supplier<BaseMessage> getCurrentBaseMessageSupplier() {
        try {
            MuleEvent.class.getName();
            return new Supplier<BaseMessage>(){

                public BaseMessage get() {
                    BaseMessage msg = null;
                    MuleEvent event = RequestContext.getEvent();
                    if (event != null && event.getMessage() != null && event.getMessage().getPayload() != null && event.getMessage().getPayload() instanceof BaseMessage) {
                        msg = (BaseMessage)event.getMessage().getPayload();
                    }
                    return msg == null ? BOGUS : msg;
                }
            };
        }
        catch (NoClassDefFoundError e) {
            return Suppliers.ofInstance((Object)BOGUS);
        }
    }
}

