/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.records;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.LogFileRecord;
import com.eucalyptus.records.Logs;
import com.eucalyptus.records.Record;
import com.eucalyptus.records.RecordLevel;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_records")
@Table(name="records")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@DiscriminatorColumn(name="record_class", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="base")
public class BaseRecord
extends AbstractPersistent
implements Serializable,
Record {
    @Transient
    private static Logger LOG = Logger.getLogger(BaseRecord.class);
    @Column(name="record_timestamp")
    private Date timestamp;
    @Column(name="record_type")
    @Enumerated(value=EnumType.STRING)
    private EventType type;
    @Column(name="record_class")
    @Enumerated(value=EnumType.STRING)
    private EventClass eventClass;
    @Column(name="record_creator")
    private String creator;
    @Column(name="record_code_location")
    private String codeLocation;
    @Column(name="record_user_id")
    private String userId;
    @Column(name="record_correlation_id")
    private String correlationId;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="record_extra")
    private String extra;
    @Column(name="record_level")
    @Enumerated(value=EnumType.STRING)
    private RecordLevel level;
    @Transient
    private ArrayList others = Lists.newArrayList();
    @Transient
    private static final String ISNULL = "NULL";
    @Transient
    protected static final String NEXT = "\n";
    @Transient
    private transient String lead;
    @Transient
    private Class realCreator;
    @Transient
    private static BlockingQueue<EventRecord> trace = new LinkedBlockingDeque<EventRecord>();
    @Transient
    private static BlockingQueue<EventRecord> debug = new LinkedBlockingDeque<EventRecord>();
    @Transient
    private static BlockingQueue<EventRecord> info = new LinkedBlockingDeque<EventRecord>();
    @Transient
    private static BlockingQueue<EventRecord> warn = new LinkedBlockingDeque<EventRecord>();
    @Transient
    private static BlockingQueue<EventRecord> error = new LinkedBlockingDeque<EventRecord>();
    @Transient
    private static BlockingQueue<EventRecord> fatal = new LinkedBlockingDeque<EventRecord>();

    public BaseRecord(EventType type, EventClass clazz, Class creator, StackTraceElement codeLocation, String userId, String correlationId, String other) {
        this.type = type;
        this.eventClass = clazz;
        this.realCreator = creator;
        this.creator = creator != null ? creator.getSimpleName() : "";
        this.codeLocation = codeLocation != null ? codeLocation.toString() : "";
        this.userId = userId;
        this.correlationId = correlationId;
        this.timestamp = new Date();
        this.extra = other;
        this.others.add(other);
    }

    public BaseRecord() {
    }

    @Override
    public Record info() {
        this.level = RecordLevel.INFO;
        Logger.getLogger((Class)this.realCreator).info((Object)this);
        return this;
    }

    @Override
    public Record error() {
        this.level = RecordLevel.ERROR;
        Logger.getLogger((Class)this.realCreator).error((Object)this);
        return this;
    }

    @Override
    public Record trace() {
        this.level = RecordLevel.TRACE;
        Logger.getLogger((Class)this.realCreator).trace((Object)this);
        return this;
    }

    @Override
    public Record debug() {
        this.level = RecordLevel.DEBUG;
        Logger.getLogger((Class)this.realCreator).debug((Object)this);
        return this;
    }

    @Override
    public Record extreme() {
        this.level = RecordLevel.TRACE;
        Logs.extreme().trace((Object)this);
        return this;
    }

    @Override
    public Record exhaust() {
        this.level = RecordLevel.TRACE;
        Logs.exhaust().trace((Object)this);
        return this;
    }

    @Override
    public Record warn() {
        this.level = RecordLevel.WARN;
        Logger.getLogger((Class)this.realCreator).warn((Object)this);
        return this;
    }

    @Override
    public Record next() {
        this.extra = "";
        for (Object o : this.others) {
            if (o == null) continue;
            this.extra = this.extra + ":" + o.toString();
        }
        LogFileRecord newThis = new LogFileRecord(this.eventClass, this.type, this.realCreator, null, this.userId, this.correlationId, "");
        return newThis;
    }

    @Override
    public Record append(Object ... obj) {
        for (Object o : obj) {
            this.others.add(o == null ? ISNULL : "" + o);
        }
        this.extra = "";
        for (Object o : this.others) {
            if (o == null) continue;
            this.extra = this.extra + ":" + o.toString();
        }
        return this;
    }

    public ArrayList getOthers() {
        return this.others;
    }

    public static String getIsnull() {
        return ISNULL;
    }

    public static String getNext() {
        return NEXT;
    }

    public String getLead() {
        return this.lead;
    }

    private String leadIn() {
        return this.lead == null ? (this.lead = String.format(":%010d:%s:%s:%s:%s:", new Object[]{this.getTimestamp().getTime(), this.getCreator(), this.correlationId != null ? this.correlationId : "", this.userId != null ? this.userId : "", this.type})) : this.lead;
    }

    @Override
    public String toString() {
        String ret = this.leadIn();
        for (Object o : this.others) {
            if (o == null) continue;
            ret = ret + ":" + o.toString();
        }
        return ret.replaceAll("::*", ":").replaceAll(NEXT, NEXT + this.leadIn());
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    @Override
    public EventClass getEventClass() {
        return this.eventClass;
    }

    public void setClazz(EventClass clazz) {
        this.eventClass = clazz;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public void setCodeLocation(String codeLocation) {
        this.codeLocation = codeLocation;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Override
    public Record withDetails(String userId, String primaryInfo, String key, String value) {
        this.userId = userId;
        this.correlationId = primaryInfo;
        return this.withDetails(key, value);
    }

    @Override
    public Record withDetails(String key, String value) {
        this.others.clear();
        this.others.add(key);
        this.others.add(value);
        this.info();
        return this.next();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventClass == null ? 0 : this.eventClass.hashCode());
        result = 31 * result + (this.codeLocation == null ? 0 : this.codeLocation.hashCode());
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.creator == null ? 0 : this.creator.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseRecord other = (BaseRecord)obj;
        if (this.eventClass == null ? other.eventClass != null : !this.eventClass.equals((Object)other.eventClass)) {
            return false;
        }
        if (this.codeLocation == null ? other.codeLocation != null : !this.codeLocation.equals(other.codeLocation)) {
            return false;
        }
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.creator == null ? other.creator != null : !this.creator.equals(other.creator)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

