/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.http;

import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.http.MappingHttpMessage;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class MappingHttpRequest
extends MappingHttpMessage
implements HttpRequest {
    private static Logger LOG = Logger.getLogger(MappingHttpRequest.class);
    private HttpMethod method;
    private String uri;
    private String servicePath;
    private String query;
    private final Map<String, String> parameters;
    private final Map<String, String> rawParameters;
    private final Set<String> nonQueryParameterKeys;
    private final Map<String, String> formFields;
    private String restNamespace;

    public MappingHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion);
        this.method = method;
        this.uri = uri;
        try {
            URL url2 = new URL("http://eucalyptus" + uri);
            this.servicePath = url2.getPath();
            this.parameters = Maps.newHashMap();
            this.rawParameters = Maps.newHashMap();
            this.nonQueryParameterKeys = Sets.newHashSet();
            this.query = this.query == url2.getQuery() ? this.query : url2.getQuery();
            this.formFields = Maps.newHashMap();
            this.populateParameters();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateParameters() {
        if (this.query != null && !"".equals(this.query)) {
            for (String p : this.query.split("&")) {
                String[] splitParam = p.split("=", 2);
                String lhs = splitParam[0];
                String rhs = splitParam.length == 2 ? splitParam[1] : null;
                this.rawParameters.put(lhs, rhs);
                try {
                    if (lhs != null) {
                        lhs = new URLCodec().decode(lhs);
                    }
                }
                catch (DecoderException decoderException) {
                    // empty catch block
                }
                try {
                    if (rhs != null) {
                        rhs = new URLCodec().decode(rhs);
                    }
                }
                catch (DecoderException decoderException) {
                    // empty catch block
                }
                this.parameters.put(lhs, rhs);
            }
        }
    }

    public MappingHttpRequest(HttpVersion httpVersion, HttpMethod method, ServiceConfiguration serviceConfiguration, Object source) {
        super(httpVersion);
        this.method = method;
        URI fullUri = ServiceUris.internal(serviceConfiguration, new String[0]);
        this.uri = fullUri.toString();
        this.servicePath = fullUri.getPath();
        this.query = null;
        this.parameters = null;
        this.rawParameters = null;
        this.nonQueryParameterKeys = null;
        this.formFields = null;
        this.message = source;
        if (source instanceof BaseMessage) {
            this.setCorrelationId(((BaseMessage)source).getCorrelationId());
        }
        this.addHeader("Host", fullUri.getHost() + ":" + fullUri.getPort());
    }

    public MappingHttpRequest(HttpVersion httpVersion, HttpMethod method, String host, int port, String servicePath, Object source) {
        super(httpVersion);
        this.method = method;
        this.uri = "http://" + host + ":" + port + servicePath;
        this.servicePath = servicePath;
        this.query = null;
        this.parameters = null;
        this.rawParameters = null;
        this.nonQueryParameterKeys = null;
        this.formFields = null;
        this.message = source;
        if (source instanceof BaseMessage) {
            this.setCorrelationId(((BaseMessage)source).getCorrelationId());
        }
        this.addHeader("Host", host + ":" + port);
    }

    @Override
    public void setMessage(Object message) {
        if (message instanceof BaseMessage && this.getCorrelationId() != null) {
            ((BaseMessage)message).setCorrelationId(this.getCorrelationId());
        }
        super.setMessage(message);
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        try {
            this.query = new URLCodec().decode(query);
        }
        catch (DecoderException e) {
            this.query = query;
        }
        this.populateParameters();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.method = httpMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.getMethod().toString() + ' ' + this.getUri() + ' ' + super.getProtocolVersion().getText();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getRawParameters() {
        return this.rawParameters;
    }

    public void addNonQueryParameterKeys(Set<String> keys) {
        if (this.nonQueryParameterKeys != null) {
            this.nonQueryParameterKeys.addAll(keys);
        }
    }

    public boolean isQueryParameter(String key) {
        return this.nonQueryParameterKeys != null && !this.nonQueryParameterKeys.contains(key);
    }

    public String getRestNamespace() {
        return this.restNamespace;
    }

    public void setRestNamespace(String restNamespace) {
        this.restNamespace = restNamespace;
    }

    public Map getFormFields() {
        return this.formFields;
    }

    public String getAndRemoveHeader(String key) {
        String value = this.getHeader(key);
        this.removeHeader(key);
        return value;
    }

    @Override
    public String logMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append("============================================\n");
        buf.append("HTTP").append(this.getProtocolVersion()).append(" ").append(this.getMethod()).append(" ").append(this.getUri()).append("\n");
        for (String s : this.getHeaderNames()) {
            buf.append(s).append(": ").append(this.getHeader(s)).append("\n");
        }
        buf.append("============================================\n");
        buf.append(this.getContent().toString("UTF-8")).append("\n");
        buf.append("============================================\n");
        return buf.toString();
    }
}

