/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.http;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;

public abstract class MappingHttpMessage
extends DefaultHttpMessage
implements HttpMessage {
    private static Logger LOG = Logger.getLogger(MappingHttpMessage.class);
    private String correlationId;
    private String messageString;
    private SOAPEnvelope soapEnvelope;
    private OMElement omMessage;
    protected Object message;
    private User user;
    private Boolean keepAlive = Boolean.TRUE;
    private final Long timestamp = System.currentTimeMillis();

    protected MappingHttpMessage(HttpVersion version) {
        super(version);
    }

    public SOAPEnvelope getSoapEnvelope() {
        return this.soapEnvelope;
    }

    public void setSoapEnvelope(SOAPEnvelope soapEnvelope) {
        this.soapEnvelope = soapEnvelope;
    }

    public OMElement getOmMessage() {
        return this.omMessage;
    }

    public void setOmMessage(OMElement omMessage) {
        this.omMessage = omMessage;
    }

    public Object getMessage() {
        return this.message;
    }

    public void setMessage(Object message) {
        if (message instanceof BaseMessage && this.getCorrelationId() != null) {
            ((BaseMessage)message).setCorrelationId(this.getCorrelationId());
        }
        this.message = message;
    }

    public String getMessageString() {
        return this.messageString;
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public final Long getTimestamp() {
        return this.timestamp;
    }

    public final String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String logMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append("============================================\n");
        buf.append("HTTP").append(this.getProtocolVersion()).append('\n');
        for (String s : this.getHeaderNames()) {
            buf.append(s).append(": ").append(this.getHeader(s)).append('\n');
        }
        buf.append("============================================\n");
        buf.append(this.getContent().toString("UTF-8")).append('\n');
        buf.append("============================================\n");
        return buf.toString();
    }

    public static <T extends MappingHttpMessage> T extractMessage(ChannelEvent e) {
        if (e instanceof MessageEvent) {
            MessageEvent msge = (MessageEvent)e;
            if (msge.getMessage() instanceof MappingHttpRequest) {
                return (T)((Object)((MappingHttpMessage)((Object)msge.getMessage())));
            }
            if (msge.getMessage() instanceof MappingHttpResponse) {
                return (T)((Object)((MappingHttpMessage)((Object)msge.getMessage())));
            }
            return null;
        }
        return null;
    }
}

