/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.event;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.ListenerRegistry;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

@ConfigurableClass(root="bootstrap.timer", description="Parameters controlling the system timer.")
public class SystemClock
extends TimerTask
implements Thread.UncaughtExceptionHandler {
    private static Logger LOG = Logger.getLogger(SystemClock.class);
    @ConfigurableField(description="Amount of time (in milliseconds) before a previously running instance which is not reported will be marked as terminated.", initial="60", changeListener=ClockRateChangeListener.class)
    public static Long RATE = 10000L;
    private static SystemClock clock;
    private static Timer timer;
    private static Timer hzTimer;
    private static HzClock hertz;
    private int phase = 0;

    public static long getRate() {
        return RATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupTimer() {
        Class<SystemClock> clazz = SystemClock.class;
        synchronized (SystemClock.class) {
            if (timer == null) {
                timer = new Timer("SystemClockTimer");
                hzTimer = new Timer("SystemHzTimer");
                clock = new SystemClock();
                hertz = new HzClock();
                ListenerRegistry.getInstance().register(ClockTick.class, new Dummy());
                ListenerRegistry.getInstance().register(Hertz.class, new Dummy());
                timer.scheduleAtFixedRate((TimerTask)clock, 0L, (long)RATE);
                hzTimer.scheduleAtFixedRate((TimerTask)hertz, 0L, 1000L);
                OrderedShutdown.registerPreShutdownHook(new Runnable(){

                    @Override
                    public void run() {
                        timer.cancel();
                    }
                });
                OrderedShutdown.registerPreShutdownHook(new Runnable(){

                    @Override
                    public void run() {
                        hzTimer.cancel();
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setUncaughtExceptionHandler(this);
        if (!Databases.isVolatile().booleanValue()) {
            try {
                long sign = (long)Math.pow(-1.0, ++this.phase % 2);
                ListenerRegistry.getInstance().fireEvent(new ClockTick().setMessage(sign * System.currentTimeMillis()));
            }
            catch (EventFailedException sign) {
            }
            catch (Exception t) {
                LOG.error((Object)t, (Throwable)t);
            }
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        LOG.fatal((Object)e, e);
    }

    public static class HzClock
    extends TimerTask
    implements Thread.UncaughtExceptionHandler {
        private int phase = 0;

        @Override
        public void uncaughtException(Thread thread, Throwable t) {
            LOG.error((Object)t, t);
        }

        @Override
        public void run() {
            if (!Databases.isVolatile().booleanValue()) {
                Thread.currentThread().setUncaughtExceptionHandler(this);
                try {
                    ListenerRegistry.getInstance().fireEvent(new Hertz());
                }
                catch (EventFailedException eventFailedException) {
                }
                catch (Exception t) {
                    LOG.error((Object)t, (Throwable)t);
                }
            }
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.Final)
    public static class SystemClockBootstrapper
    extends Bootstrapper {
        @Override
        public boolean load() throws Exception {
            return true;
        }

        @Override
        public boolean start() throws Exception {
            SystemClock.setupTimer();
            return true;
        }

        @Override
        public boolean enable() throws Exception {
            return true;
        }

        @Override
        public boolean stop() throws Exception {
            return true;
        }

        @Override
        public void destroy() throws Exception {
        }

        @Override
        public boolean disable() throws Exception {
            return true;
        }

        @Override
        public boolean check() throws Exception {
            return true;
        }
    }

    public static class Dummy
    implements EventListener {
        public void fireEvent(Event event) {
        }
    }

    public static class ClockRateChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                RATE = Long.parseLong((String)newValue);
                hzTimer.cancel();
                timer.cancel();
                SystemClock.setupTimer();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

