/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.event;

import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.GenericEvent;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.Parameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class StatefulNamedRegistry<T extends HasName, E extends Enum<E>> {
    private static Logger LOG = Logger.getLogger(StatefulNamedRegistry.class);
    private final ConcurrentNavigableMap<String, StatefulValue> stateMap = new ConcurrentSkipListMap<String, StatefulValue>();
    private E[] states;
    private ReadWriteLock canHas;

    protected StatefulNamedRegistry(E ... states) {
        this.states = states;
        this.canHas = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(String name) {
        this.canHas.readLock().lock();
        try {
            boolean bl = this.stateMap.containsKey(name);
            return bl;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    public T deregister(String key) {
        StatefulValue oldValue = null;
        this.canHas.writeLock().lock();
        try {
            oldValue = (StatefulValue)this.stateMap.remove(key);
            if (oldValue != null) {
                Object t = oldValue.getValue();
                return t;
            }
            throw new NoSuchElementException("Can't find registered object: " + key + " in " + this.getClass().getSimpleName());
        }
        finally {
            this.canHas.writeLock().unlock();
            if (oldValue != null) {
                this.fireStateChange(oldValue, this.states[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T register(T obj, E nextState) {
        StatefulValue newValue;
        StatefulValue oldValue;
        block4: {
            block5: {
                Object t;
                oldValue = null;
                newValue = null;
                Parameters.checkParam(obj, Matchers.notNullValue());
                this.canHas.writeLock().lock();
                try {
                    newValue = new StatefulValue(this, nextState, obj);
                    oldValue = this.stateMap.putIfAbsent(obj.getName(), newValue);
                    if (oldValue == null) break block4;
                    newValue = new StatefulValue(this, nextState, oldValue.getValue());
                    if (!this.stateMap.replace(obj.getName(), oldValue, newValue)) break block5;
                    t = newValue.getValue();
                    this.canHas.writeLock().unlock();
                    this.fireStateChange(oldValue, nextState);
                }
                catch (Throwable throwable) {
                    this.canHas.writeLock().unlock();
                    this.fireStateChange(oldValue, nextState);
                    throw throwable;
                }
                return t;
            }
            newValue = oldValue;
            Object t = newValue.getValue();
            this.canHas.writeLock().unlock();
            this.fireStateChange(oldValue, nextState);
            return t;
        }
        Object t = newValue.getValue();
        this.canHas.writeLock().unlock();
        this.fireStateChange(oldValue, nextState);
        return t;
    }

    private E getState(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            if (this.stateMap.containsKey(name)) {
                Object e = ((StatefulValue)this.stateMap.get(name)).getState();
                return e;
            }
            throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T lookup(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            Object t = this.lookupEntry(name).getValue();
            return t;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T lookup(T obj) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            Object t = this.lookupEntry(obj.getName()).getValue();
            return t;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E lookupState(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            this.lookup((T)"hi");
            Object e = this.lookupEntry(name).getState();
            return e;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    public StatefulValue lookupEntry(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            StatefulValue currValue = (StatefulValue)this.stateMap.get(name);
            if (currValue != null) {
                StatefulValue statefulValue = currValue;
                return statefulValue;
            }
            throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(String name, E newState) throws NoSuchElementException {
        StatefulValue oldValue = null;
        this.canHas.writeLock().lock();
        try {
            oldValue = this.lookupEntry(name);
            if (((Enum)oldValue.getState()).equals(newState)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.stateMap.replace(name, oldValue, new StatefulValue(this, newState, oldValue.getValue()));
            return bl;
        }
        finally {
            this.canHas.writeLock().unlock();
            if (oldValue != null && !((Enum)oldValue.getState()).equals(newState)) {
                this.fireStateChange(oldValue, newState);
            }
        }
    }

    private void fireStateChange(StatefulValue oldValue, E newState) {
        try {
            ListenerRegistry.getInstance().fireEvent(new StateEvent(oldValue.getValue(), newState, oldValue.getState()));
        }
        catch (EventFailedException e) {
            LOG.warn((Object)("Registry change was vetoed: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        this.canHas.readLock().lock();
        try {
            boolean bl = this.stateMap.containsKey(name);
            return bl;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name, E state) {
        this.canHas.readLock().lock();
        try {
            boolean bl = this.stateMap.containsKey(name) && ((Enum)((StatefulValue)this.stateMap.get(state)).getState()).equals(state);
            return bl;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    public List<T> listValues() {
        ArrayList valueList = Lists.newArrayList();
        for (StatefulValue m : this.stateMap.values()) {
            valueList.add(m.getValue());
        }
        return ImmutableList.copyOf((Collection)valueList);
    }

    public ImmutableList<String> listKeys(E state) {
        return ImmutableList.copyOf((Collection)this.stateMap.keySet());
    }

    public ImmutableList<T> listStateValues(E state) {
        ArrayList valueList = Lists.newArrayList();
        for (StatefulValue m : this.stateMap.values()) {
            if (!((Enum)m.getState()).equals(state)) continue;
            valueList.add(m.getValue());
        }
        return ImmutableList.copyOf((Collection)valueList);
    }

    private static class StatefulValue {
        private final E state;
        private final T value;
        final /* synthetic */ StatefulNamedRegistry this$0;

        public StatefulValue(E state, T value) {
            this.this$0 = var1_1;
            this.state = state;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatefulValue other = (StatefulValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public E getState() {
            return this.state;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class StateEvent<T, E extends Enum<E>>
    extends GenericEvent<T> {
        private final E state;
        private final E previousState;
        private final T value;

        public StateEvent(T value, E state, E previousState) {
            this.value = value;
            this.state = state;
            this.previousState = previousState;
        }

        public StateEvent(T value, E state, E previousState, T message) {
            super(message);
            this.value = value;
            this.state = state;
            this.previousState = previousState;
        }

        public E getState() {
            return this.state;
        }

        public E getPreviousState() {
            return this.previousState;
        }
    }
}

