/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.event;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ListenerRegistry {
    private static Logger LOG = Logger.getLogger(ListenerRegistry.class);
    private static ListenerRegistry singleton = ListenerRegistry.getInstance();
    private final Map<Class, ReentrantListenerRegistry> registryMap = Maps.newHashMap();
    private final ReentrantListenerRegistry<Class<? extends Event>> eventMap = new ReentrantListenerRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListenerRegistry getInstance() {
        Class<ListenerRegistry> clazz = ListenerRegistry.class;
        synchronized (ListenerRegistry.class) {
            if (singleton == null) {
                singleton = new ListenerRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public ListenerRegistry() {
        this.registryMap.put(ComponentId.class, new ReentrantListenerRegistry());
        this.registryMap.put(String.class, new ReentrantListenerRegistry());
    }

    public void register(Object type, EventListener listener) {
        Class<?> key;
        List<Class> lookupTypes = Classes.genericsToClasses(listener);
        lookupTypes.remove(Event.class);
        boolean illegal = type == null && lookupTypes.isEmpty();
        for (Class c : lookupTypes) {
            if (type == null || !c.isAssignableFrom(type instanceof Class ? (Class<?>)type : type.getClass())) continue;
            illegal = false;
            break;
        }
        if (illegal) {
            throw Exceptions.error(new IllegalArgumentException("Failed to register listener " + listener.getClass().getCanonicalName() + " because the declared generic type " + lookupTypes + " is not assignable from the provided event type: " + (type != null ? type.getClass().getCanonicalName() : "null")));
        }
        Class<Object> clazz = type == null ? lookupTypes.get(0) : (key = type instanceof Class ? (Class)type : type.getClass());
        if (Event.class.isAssignableFrom(key)) {
            this.eventMap.register(key, listener);
        } else {
            if (!this.registryMap.containsKey(key)) {
                this.registryMap.put(key, new ReentrantListenerRegistry());
            }
            this.registryMap.get(key).register(type, listener);
        }
    }

    public void deregister(Object type, EventListener listener) {
        List<Class> lookupTypes = Classes.genericsToClasses(listener);
        lookupTypes.remove(Event.class);
        boolean illegal = type == null && lookupTypes.isEmpty();
        for (Class c : lookupTypes) {
            if (type == null || !c.isAssignableFrom(type instanceof Class ? (Class<?>)type : type.getClass())) continue;
            illegal = false;
            break;
        }
        if (illegal) {
            throw Exceptions.error(new IllegalArgumentException("Failed to register listener " + listener.getClass().getCanonicalName() + " because the declared generic type " + lookupTypes + " is not assignable from the provided event type: " + (type != null ? type.getClass().getCanonicalName() : "null")));
        }
        if (type instanceof Class && Event.class.isAssignableFrom((Class)type)) {
            this.eventMap.deregister((Class)type, listener);
        } else {
            if (!this.registryMap.containsKey(type.getClass())) {
                this.registryMap.put(type.getClass(), new ReentrantListenerRegistry());
            }
            this.registryMap.get(type.getClass()).deregister(type, listener);
        }
    }

    public void destroy(Object type) {
        if (type instanceof Class && Event.class.isAssignableFrom((Class)type)) {
            this.eventMap.destroy((Class)type);
        } else {
            if (!this.registryMap.containsKey(type.getClass())) {
                this.registryMap.put(type.getClass(), new ReentrantListenerRegistry());
            }
            this.registryMap.get(type.getClass()).destroy(type);
        }
    }

    public void fireEvent(Event e) throws EventFailedException {
        this.eventMap.fireEvent(e.getClass(), e);
    }

    public void fireThrowableEvent(Event e) throws EventFailedException {
        this.eventMap.fireThrowableEvent(e.getClass(), e);
    }

    public void fireEvent(Object type, Event e) throws EventFailedException {
        if (!this.registryMap.containsKey(type.getClass())) {
            this.registryMap.put(type.getClass(), new ReentrantListenerRegistry());
        }
        this.registryMap.get(type.getClass()).fireEvent(type, e);
    }

    public Future<Event> fireEventAsync(final Object type, final Event e) {
        return Threads.enqueue(ServiceConfigurations.createEphemeral(Empyrean.INSTANCE), 32, new Callable<Event>(){

            @Override
            public Event call() throws Exception {
                try {
                    ListenerRegistry.this.fireEvent(type, e);
                    return e;
                }
                catch (Exception ex) {
                    Logs.exhaust().error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
        });
    }

    public static class ReentrantListenerRegistry<T> {
        private Multimap<T, EventListener> listenerMap = ArrayListMultimap.create();
        private Lock modificationLock = new ReentrantLock();
        private static final LoadingCache<EventListener, Function<Event, Callable<Object>>> listenerTasks = CacheBuilder.newBuilder().build(ReentrantListenerRegistry.getListenerWrapper());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(T type, EventListener listener) {
            if (type instanceof Enum) {
                EventRecord.caller(ReentrantListenerRegistry.class, EventType.LISTENER_REGISTERED, type.getClass().getSimpleName(), ((Enum)type).name(), listener.getClass().getSimpleName()).trace();
            } else {
                EventRecord.caller(ReentrantListenerRegistry.class, EventType.LISTENER_REGISTERED, type.getClass().getSimpleName(), listener.getClass().getSimpleName()).trace();
            }
            this.modificationLock.lock();
            try {
                if (!this.listenerMap.containsEntry(type, (Object)listener)) {
                    this.listenerMap.put(type, (Object)listener);
                }
            }
            finally {
                this.modificationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregister(T type, EventListener listener) {
            if (type instanceof Enum) {
                EventRecord.caller(ReentrantListenerRegistry.class, EventType.LISTENER_DEREGISTERED, type.getClass().getSimpleName(), ((Enum)type).name(), listener.getClass().getSimpleName()).trace();
            } else {
                EventRecord.caller(ReentrantListenerRegistry.class, EventType.LISTENER_DEREGISTERED, type.getClass().getSimpleName(), listener.getClass().getSimpleName()).trace();
            }
            this.modificationLock.lock();
            try {
                this.listenerMap.remove(type, (Object)listener);
            }
            finally {
                this.modificationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(T type) {
            this.modificationLock.lock();
            try {
                for (EventListener e : this.listenerMap.get(type)) {
                    EventRecord.caller(ReentrantListenerRegistry.class, EventType.LISTENER_DESTROY_ALL, type.getClass().getSimpleName(), e.getClass().getCanonicalName()).trace();
                }
                this.listenerMap.removeAll(type);
            }
            finally {
                this.modificationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireThrowableEvent(T type, Event e) throws EventFailedException {
            ArrayList listeners;
            this.modificationLock.lock();
            try {
                listeners = Lists.newArrayList((Iterable)this.listenerMap.get(type));
            }
            finally {
                this.modificationLock.unlock();
            }
            ArrayList errors = Lists.newArrayList();
            for (EventListener ce : listeners) {
                EventRecord.here(ReentrantListenerRegistry.class, EventType.LISTENER_EVENT_FIRED, ce.getClass().getSimpleName(), e.toString()).trace();
                try {
                    ce.fireEvent(e);
                }
                catch (Exception ex) {
                    EventFailedException eventEx = new EventFailedException("Failed to fire event: listener=" + ce.getClass().getCanonicalName() + " event=" + e.toString() + " because of: " + ex.getMessage(), Exceptions.filterStackTrace(ex));
                    throw eventEx;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(T type, Event e) {
            ArrayList listeners;
            this.modificationLock.lock();
            try {
                listeners = Lists.newArrayList((Iterable)this.listenerMap.get(type));
            }
            finally {
                this.modificationLock.unlock();
            }
            for (EventListener ce : listeners) {
                Threads.lookup(Empyrean.class, ListenerRegistry.class, "listenerTasks").submit((Callable)((Function)listenerTasks.getUnchecked((Object)ce)).apply((Object)e));
            }
        }

        private static final CacheLoader<EventListener, Function<Event, Callable<Object>>> getListenerWrapper() {
            return new CacheLoader<EventListener, Function<Event, Callable<Object>>>(){

                public Function<Event, Callable<Object>> load(final EventListener key) throws Exception {
                    return new Function<Event, Callable<Object>>(){
                        final AtomicBoolean busy = new AtomicBoolean(false);

                        public Callable<Object> apply(final Event input) {
                            return new Callable<Object>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Object call() throws Exception {
                                    if (!Ats.inClassHierarchy(input).has(Event.Periodic.class) || busy.compareAndSet(false, true)) {
                                        try {
                                            key.fireEvent(input);
                                        }
                                        catch (Exception ex) {
                                            EventFailedException eventEx = new EventFailedException("Failed to fire event: listener=" + key.getClass().getCanonicalName() + " event=" + ex.toString() + " because of: " + ex.getMessage(), Exceptions.filterStackTrace(ex));
                                            Logs.extreme().error((Object)eventEx, (Throwable)eventEx);
                                            LOG.error((Object)eventEx);
                                        }
                                        finally {
                                            busy.set(false);
                                        }
                                    }
                                    return input;
                                }
                            };
                        }
                    };
                }
            };
        }
    }
}

