/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.event;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.event.EventListener;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class EventListenerDiscovery
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(EventListenerDiscovery.class);

    @Override
    public Double getPriority() {
        return 0.5;
    }

    @Override
    public boolean processClass(Class candidate) throws Exception {
        if (EventListener.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers())) {
            try {
                this.getEventListener(candidate);
                return true;
            }
            catch (Exception ex) {
                LOG.trace((Object)ex.getMessage());
                return false;
            }
        }
        return false;
    }

    private Class getEventListener(Class candidate) throws Exception {
        LOG.trace((Object)("Candidate event listener: " + candidate.getName()));
        Method factory = candidate.getDeclaredMethod("register", new Class[0]);
        if (!Modifier.isStatic(factory.getModifiers()) || !Modifier.isPublic(factory.getModifiers())) {
            throw new InstantiationException(candidate.getCanonicalName() + " does not declare public static register()V");
        }
        LOG.trace((Object)("-> Registered event listener: " + candidate.getName()));
        factory.invoke(null, new Object[0]);
        return candidate;
    }
}

