/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.event;

import com.eucalyptus.util.HasFullName;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractNamedRegistry<TYPE extends HasFullName> {
    protected ReadWriteLock canHas = new ReentrantReadWriteLock();
    private ConcurrentNavigableMap<String, TYPE> activeMap = new ConcurrentSkipListMap<String, TYPE>();
    private ConcurrentNavigableMap<String, TYPE> disabledMap = new ConcurrentSkipListMap<String, TYPE>();

    protected AbstractNamedRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String key) {
        this.canHas.writeLock().lock();
        try {
            this.disabledMap.remove(key);
            this.activeMap.remove(key);
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(TYPE obj) {
        HasFullName<Object> tempObj = null;
        this.canHas.writeLock().lock();
        try {
            tempObj = (HasFullName)this.disabledMap.remove(obj.getName());
            if (tempObj == null) {
                tempObj = obj;
            }
            this.activeMap.putIfAbsent(tempObj.getName(), tempObj);
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisabled(TYPE obj) {
        HasFullName<Object> tempObj = null;
        this.canHas.writeLock().lock();
        try {
            tempObj = (HasFullName)this.activeMap.remove(obj.getName());
            if (tempObj == null) {
                tempObj = obj;
            }
            this.disabledMap.putIfAbsent(tempObj.getName(), tempObj);
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TYPE> listDisabledValues() {
        this.canHas.readLock().lock();
        try {
            ArrayList arrayList = Lists.newArrayList(this.disabledMap.values());
            return arrayList;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TYPE> listValues() {
        this.canHas.readLock().lock();
        try {
            ArrayList arrayList = Lists.newArrayList(this.activeMap.values());
            return arrayList;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE lookupDisabled(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            if (!this.disabledMap.containsKey(name)) {
                throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
            }
            HasFullName hasFullName = (HasFullName)this.disabledMap.get(name);
            return (TYPE)hasFullName;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE lookup(String name) throws NoSuchElementException {
        this.canHas.readLock().lock();
        try {
            if (!this.activeMap.containsKey(name)) {
                throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
            }
            HasFullName hasFullName = (HasFullName)this.activeMap.get(name);
            return (TYPE)hasFullName;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    public void disable(TYPE that) throws NoSuchElementException {
        this.disable(that.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable(String name) {
        this.canHas.writeLock().lock();
        try {
            HasFullName obj = null;
            obj = (HasFullName)this.activeMap.remove(name);
            if (obj == null && (obj = (HasFullName)this.disabledMap.remove(name)) == null) {
                throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
            }
            this.disabledMap.putIfAbsent(obj.getName(), obj);
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    public void enable(TYPE that) throws NoSuchElementException {
        this.enable(that.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(String name) throws NoSuchElementException {
        this.canHas.writeLock().lock();
        try {
            HasFullName obj = null;
            obj = (HasFullName)this.disabledMap.remove(name);
            if (obj == null && (obj = (HasFullName)this.activeMap.remove(name)) == null) {
                throw new NoSuchElementException("Can't find registered object: " + name + " in " + this.getClass().getSimpleName());
            }
            this.activeMap.putIfAbsent(obj.getName(), obj);
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    public boolean contains(TYPE obj) {
        return this.contains(obj.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        this.canHas.readLock().lock();
        try {
            boolean bl = this.activeMap.containsKey(name) || this.disabledMap.containsKey(name);
            return bl;
        }
        finally {
            this.canHas.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE enableFirst(Predicate<TYPE> filter) throws NoSuchElementException {
        this.canHas.writeLock().lock();
        try {
            HasFullName first = (HasFullName)Maps.filterValues(this.disabledMap, filter).values().iterator().next();
            if (first == null) {
                throw new NoSuchElementException("Disabled map is empty.");
            }
            this.activeMap.put(first.getName(), first);
            HasFullName hasFullName = first;
            return (TYPE)hasFullName;
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    public String toString() {
        return String.format("%s [activeMap=%s, disabledMap=%s]", this.getClass().getSimpleName(), this.activeMap, this.disabledMap);
    }
}

