/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.entities.AccountMetadata;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedType;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.hamcrest.Matchers;

@MappedSuperclass
public abstract class UserMetadata<STATE extends Enum<STATE>>
extends AccountMetadata<STATE>
implements RestrictedType.UserRestrictedType {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_user_id")
    protected String ownerUserId;
    @Column(name="metadata_user_name")
    protected String ownerUserName;

    protected UserMetadata() {
    }

    protected UserMetadata(OwnerFullName owner) {
        super(owner);
        this.setOwner(owner);
    }

    protected UserMetadata(OwnerFullName owner, String displayName) {
        super(owner, displayName);
        this.setOwner(owner);
    }

    @Override
    public void setOwner(OwnerFullName owner) {
        this.ownerFullNameCached = null;
        this.setOwnerUserId(owner != null ? owner.getUserId() : null);
        this.setOwnerUserName(owner != null ? owner.getUserName() : null);
        super.setOwner(owner);
    }

    @Override
    public OwnerFullName getOwner() {
        if (this.ownerFullNameCached != null) {
            return this.ownerFullNameCached;
        }
        if (this.getOwnerUserId() != null) {
            OwnerFullName tempOwner = null;
            tempOwner = Principals.nobodyFullName().getUserId().equals(this.getOwnerUserId()) ? Principals.nobodyFullName() : (Principals.systemFullName().getUserId().equals(this.getOwnerUserId()) ? Principals.systemFullName() : UserFullName.getInstance(this.getOwnerUserId(), new String[0]));
            this.ownerFullNameCached = tempOwner;
            return this.ownerFullNameCached;
        }
        return super.getOwner();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ownerUserId == null ? 0 : this.ownerUserId.hashCode());
        return result;
    }

    @Override
    public String getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    @Override
    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    @PrePersist
    @PreUpdate
    public void verifyComplete() {
        Parameters.checkParam(this.ownerUserId, Matchers.notNullValue());
        Parameters.checkParam(this.ownerUserName, Matchers.notNullValue());
    }
}

