/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.PersistenceExceptions;
import com.eucalyptus.entities.TransactionCallbackException;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionExecutionException;
import com.eucalyptus.entities.TransactionInternalException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class Transactions {
    private static Logger LOG = Logger.getLogger(Transactions.class);
    private static ThreadLocal<AtomicInteger> depth = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private static ThreadLocal<List<EntityTransaction>> wrappers = new ThreadLocal<List<EntityTransaction>>(){

        @Override
        protected List<EntityTransaction> initialValue() {
            return Lists.newArrayList();
        }
    };

    private static <T> EntityTransaction get(T obj) {
        EntityTransaction db = Entities.get(obj);
        depth.get().incrementAndGet();
        wrappers.get().add(db);
        return db;
    }

    private static void pop() {
        Integer nextLevel = depth.get().decrementAndGet();
        if (nextLevel <= 0) {
            for (EntityTransaction db : wrappers.get()) {
                if (!db.isActive()) continue;
                db.commit();
            }
            wrappers.remove();
            depth.remove();
        }
    }

    private static TransactionException transformException(Throwable t) {
        Logs.exhaust().error((Object)t, t);
        PersistenceExceptions.throwFiltered(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new TransactionExecutionException(t.getCause().getMessage(), t.getCause());
        }
        if (t instanceof EucalyptusCloudException) {
            return new TransactionExecutionException(t.getMessage(), t);
        }
        if (t instanceof UndeclaredThrowableException) {
            return new TransactionCallbackException(t.getCause().getMessage(), t.getCause());
        }
        return new TransactionInternalException(t.getMessage(), t);
    }

    public static <T> List<T> findAll(T search) throws TransactionException {
        return Transactions.each(search, new Callback<T>(){

            @Override
            public void fire(T t) {
            }
        });
    }

    public static <T> List<T> each(T search, Callback<T> c) throws TransactionException {
        return Transactions.each(search, (Criterion)Restrictions.conjunction(), Collections.emptyMap(), c);
    }

    public static <T> List<T> each(T search, Criterion criterion, Map<String, String> aliases, Callback<T> c) throws TransactionException {
        Parameters.checkParam(search, Matchers.notNullValue());
        Parameters.checkParam(c, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(search);
        try {
            List<T> res = Entities.query(search, false, criterion, aliases);
            for (T t : res) {
                try {
                    c.fire(t);
                }
                catch (Exception ex) {
                    throw new TransactionCallbackException(ex);
                }
            }
            List<T> list = res;
            return list;
        }
        catch (TransactionCallbackException e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw e;
        }
        catch (UndeclaredThrowableException e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw new TransactionInternalException(e);
        }
        finally {
            Transactions.pop();
        }
    }

    public static <T> T find(T search) throws TransactionException {
        return (T)Transactions.one(search, Functions.identity());
    }

    public static <T> T one(T search, final Callback<T> c) throws TransactionException {
        return (T)Transactions.one(search, new Function<T, T>(){

            public T apply(T input) {
                try {
                    c.fire(input);
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared(new TransactionCallbackException(ex));
                }
                return input;
            }
        });
    }

    public static <S, T> S one(T search, Function<T, S> f) throws TransactionException {
        return Transactions.one(search, Predicates.alwaysTrue(), f);
    }

    public static <S, T> S one(final T search, Predicate<? super T> predicate, Function<? super T, S> f) throws TransactionException {
        return Transactions.one(search, new Callable<T>(){

            @Override
            public T call() throws TransactionException {
                return Entities.uniqueResult(search);
            }
        }, predicate, f);
    }

    public static <S, T> S one(final T search, final Criterion criterion, final Map<String, String> aliases, Predicate<? super T> predicate, Function<? super T, S> f) throws TransactionException {
        return Transactions.one(search, new Callable<T>(){

            @Override
            public T call() throws TransactionException {
                List<Object> ts = Entities.query(search, false, criterion, aliases);
                if (ts.size() != 1) {
                    throw new NoSuchElementException();
                }
                return ts.get(0);
            }
        }, predicate, f);
    }

    private static <S, T> S one(T type, Callable<T> lookup, Predicate<? super T> predicate, Function<? super T, S> f) throws TransactionException {
        Parameters.checkParam(type, Matchers.notNullValue());
        Parameters.checkParam(f, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(type);
        try {
            Object object;
            T entity = lookup.call();
            if (!predicate.apply(entity)) {
                throw new NoSuchElementException();
            }
            try {
                Object res;
                object = res = f.apply(entity);
            }
            catch (Exception ex) {
                try {
                    throw new TransactionCallbackException(ex);
                }
                catch (TransactionCallbackException e) {
                    db.rollback();
                    Logs.extreme().error((Object)e, (Throwable)e);
                    throw e;
                }
                catch (UndeclaredThrowableException e) {
                    db.rollback();
                    Logs.extreme().error((Object)e, (Throwable)e);
                    if (e.getCause() instanceof TransactionException) {
                        throw e;
                    }
                    throw new TransactionCallbackException(e.getCause());
                }
                catch (Exception t) {
                    db.rollback();
                    throw Transactions.transformException(t);
                }
            }
            return (S)object;
        }
        finally {
            Transactions.pop();
        }
    }

    public static <T> List<T> filter(T search, Predicate<? super T> condition) throws TransactionException {
        Function f = Functions.identity();
        return Transactions.filteredTransform(search, condition, f);
    }

    public static <T> List<T> filter(T search, Predicate<? super T> condition, Criterion criterion, Map<String, String> aliases) throws TransactionException {
        Function f = Functions.identity();
        return Transactions.filteredTransform(search, criterion, aliases, condition, f);
    }

    public static <S, T> List<S> transform(T search, Function<T, S> f) throws TransactionException {
        Predicate p = Predicates.alwaysTrue();
        return Transactions.filteredTransform(search, p, f);
    }

    public static <T, O> List<O> filteredTransform(final T search, Predicate<? super T> condition, Function<? super T, O> transform) throws TransactionException {
        Parameters.checkParam(search, Matchers.notNullValue());
        Supplier resultsSupplier = new Supplier<List<T>>(){

            public List<T> get() {
                return Entities.query(search);
            }
        };
        return Transactions.filteredTransform(search.getClass(), resultsSupplier, condition, transform);
    }

    public static <T, O> List<O> filteredTransform(final T search, final Criterion criterion, final Map<String, String> aliases, Predicate<? super T> condition, Function<? super T, O> transform) throws TransactionException {
        Parameters.checkParam(search, Matchers.notNullValue());
        Supplier resultsSupplier = new Supplier<List<T>>(){

            public List<T> get() {
                return Entities.query(search, false, criterion, aliases);
            }
        };
        return Transactions.filteredTransform(search.getClass(), resultsSupplier, condition, transform);
    }

    private static <T, O> List<O> filteredTransform(Class<?> searchClass, Supplier<List<T>> searchResultSupplier, Predicate<? super T> condition, Function<? super T, O> transform) throws TransactionException {
        Parameters.checkParam(searchResultSupplier, Matchers.notNullValue());
        Parameters.checkParam(condition, Matchers.notNullValue());
        Parameters.checkParam(transform, Matchers.notNullValue());
        ArrayList res = Lists.newArrayList();
        EntityTransaction db = Transactions.get(searchClass);
        try {
            List queryResults = (List)searchResultSupplier.get();
            for (Object t : queryResults) {
                if (!condition.apply(t)) continue;
                try {
                    res.add(transform.apply(t));
                }
                catch (Exception ex) {
                    throw new TransactionCallbackException(ex);
                }
            }
            ArrayList arrayList = res;
            return arrayList;
        }
        catch (TransactionCallbackException e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            db.rollback();
            throw Transactions.transformException(e);
        }
        finally {
            Transactions.pop();
        }
    }

    public static <T> T save(T saveMe) throws TransactionException {
        return Transactions.save(saveMe, new Callback<T>(){

            @Override
            public void fire(T t) {
            }
        });
    }

    public static <T> T save(T saveMe, Callback<T> c) throws TransactionException {
        Parameters.checkParam(saveMe, Matchers.notNullValue());
        Parameters.checkParam(c, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(saveMe);
        try {
            T entity = Entities.merge(saveMe);
            try {
                c.fire(entity);
            }
            catch (Exception ex) {
                throw new TransactionCallbackException(ex);
            }
            db.commit();
            T t = entity;
            return t;
        }
        catch (TransactionCallbackException e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception t) {
            db.rollback();
            throw Transactions.transformException(t);
        }
        finally {
            Transactions.pop();
        }
    }

    public static <T> T saveDirect(T saveMe) throws TransactionException {
        Parameters.checkParam(saveMe, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(saveMe);
        try {
            T entity = Entities.persist(saveMe);
            db.commit();
            T t = entity;
            return t;
        }
        catch (Exception t) {
            throw Transactions.transformException(t);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
            Transactions.pop();
        }
    }

    public static <T> boolean delete(T search) throws TransactionException {
        return Transactions.delete(search, Predicates.alwaysTrue());
    }

    public static <T> boolean delete(T search, Predicate<? super T> precondition) throws TransactionException {
        Parameters.checkParam(search, Matchers.notNullValue());
        Parameters.checkParam(precondition, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(search);
        try {
            T entity = Entities.uniqueResult(search);
            try {
                if (precondition.apply(entity)) {
                    Entities.delete(entity);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                try {
                    throw new TransactionCallbackException(ex);
                }
                catch (TransactionCallbackException e) {
                    db.rollback();
                    Logs.extreme().error((Object)e, (Throwable)e);
                    throw e;
                }
                catch (Exception t) {
                    db.rollback();
                    throw Transactions.transformException(t);
                }
            }
        }
        finally {
            Transactions.pop();
        }
    }

    public static <T> boolean deleteAll(T search, Predicate<? super T> precondition) throws TransactionException {
        Parameters.checkParam(search, Matchers.notNullValue());
        Parameters.checkParam(precondition, Matchers.notNullValue());
        EntityTransaction db = Transactions.get(search);
        try {
            List<T> entities = Entities.query(search);
            boolean failed = false;
            for (T entity : entities) {
                try {
                    if (precondition.apply(entity)) {
                        Entities.delete(entity);
                        continue;
                    }
                    failed = true;
                }
                catch (Exception ex) {
                    throw new TransactionCallbackException(ex);
                }
            }
            boolean bl = !failed;
            return bl;
        }
        catch (TransactionCallbackException e) {
            db.rollback();
            Logs.extreme().error((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception t) {
            db.rollback();
            throw Transactions.transformException(t);
        }
        finally {
            Transactions.pop();
        }
    }
}

