/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.entities.RecoverablePersistenceException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.TreeSet;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.InstantiationException;
import org.hibernate.LazyInitializationException;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PropertyAccessException;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.SessionException;
import org.hibernate.StaleStateException;
import org.hibernate.TransactionException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.type.SerializationException;

public class PersistenceExceptions {
    private static Logger LOG = Logger.getLogger(PersistenceExceptions.class);
    private static final Multimap<ErrorCategory, Class<? extends Exception>> errorCategorization = PersistenceExceptions.buildErrorMap();

    private static Multimap<ErrorCategory, Class<? extends Exception>> buildErrorMap() {
        ArrayListMultimap map = ArrayListMultimap.create();
        map.get((Object)ErrorCategory.BUG).addAll(Lists.newArrayList((Object[])new Class[]{LazyInitializationException.class, InstantiationException.class, MappingException.class, MultipleBagFetchException.class, NonUniqueObjectException.class, QueryException.class, PersistentObjectException.class, PropertyAccessException.class, SerializationException.class, SessionException.class, TooManyRowsAffectedException.class, TransientObjectException.class, StaleStateException.class, TypeMismatchException.class, UnresolvableObjectException.class, WrongClassException.class, SQLGrammarException.class, TransactionRequiredException.class, HibernateException.class}));
        map.get((Object)ErrorCategory.CONSTRAINT).addAll(Lists.newArrayList((Object[])new Class[]{ConstraintViolationException.class, NonUniqueResultException.class, NoResultException.class, NonUniqueResultException.class}));
        map.get((Object)ErrorCategory.RUNTIME).addAll(Lists.newArrayList((Object[])new Class[]{TransactionException.class, IllegalStateException.class, RollbackException.class, PessimisticLockException.class, OptimisticLockException.class, EntityNotFoundException.class, EntityExistsException.class}));
        map.get((Object)ErrorCategory.CONNECTION).addAll(Lists.newArrayList((Object[])new Class[]{JDBCConnectionException.class, QueryTimeoutException.class, LockTimeoutException.class}));
        return map;
    }

    public static boolean isStaleUpdate(Throwable throwable) {
        return Exceptions.isCausedBy(throwable, OptimisticLockException.class);
    }

    public static boolean isLockError(Throwable throwable) {
        return Exceptions.isCausedBy(throwable, LockAcquisitionException.class);
    }

    public static ErrorCategory classify(Throwable e) {
        List res = Lists.transform(Exceptions.causes(e), (Function)ClassifySingleException.INSTANCE);
        if (res.isEmpty()) {
            return ErrorCategory.APPLICATION;
        }
        return (ErrorCategory)((Object)Sets.newTreeSet((Iterable)res).last());
    }

    public static RecoverablePersistenceException throwFiltered(Throwable e) {
        Logs.extreme().trace((Object)e, e);
        ConstraintViolationException constraintVolationCause = Exceptions.findCause(e, ConstraintViolationException.class);
        if (constraintVolationCause != null) {
            throw constraintVolationCause;
        }
        PersistentObjectException detachedObjectCause = Exceptions.findCause(e, PersistentObjectException.class);
        if (detachedObjectCause != null) {
            LOG.error((Object)detachedObjectCause);
        }
        if (e instanceof RuntimeException) {
            ErrorCategory category = PersistenceExceptions.classify(e);
            RuntimeException up = category.handleException((RuntimeException)e);
            if (!category.isRecoverable()) {
                throw up;
            }
            return new RecoverablePersistenceException("Error during transaction: " + Joiner.on((char)'\n').join(Exceptions.causes(e)), e);
        }
        throw ErrorCategory.APPLICATION.handleException((RuntimeException)((Object)new PersistenceException("Error during transaction: " + e.getMessage(), e)));
    }

    public static Exception transform(Throwable e) {
        try {
            return PersistenceExceptions.throwFiltered(e);
        }
        catch (Exception ex) {
            return ex;
        }
    }

    static enum ClassifySingleException implements Function<Throwable, ErrorCategory>
    {
        INSTANCE;


        public ErrorCategory apply(Throwable input) {
            TreeSet results = Sets.newTreeSet();
            for (Class p : Classes.classAncestors(input)) {
                for (ErrorCategory category : ErrorCategory.values()) {
                    if (!errorCategorization.get((Object)category).contains(p)) continue;
                    if (category.isRecoverable()) {
                        return category;
                    }
                    results.add(category);
                }
            }
            if (results.isEmpty()) {
                return ErrorCategory.APPLICATION;
            }
            return (ErrorCategory)((Object)results.first());
        }
    }

    public static enum ErrorCategory {
        BUG{

            @Override
            public RuntimeException handleException(RuntimeException e) {
                LOG.fatal((Object)e, (Throwable)e);
                throw super.handleException(e);
            }
        }
        ,
        APPLICATION,
        CONSTRAINT,
        RUNTIME,
        CONNECTION{

            @Override
            public RuntimeException handleException(RuntimeException e) {
                PersistenceContexts.PersistenceContextEventInterceptorDiscovery.dispatcher().onConnectionError();
                Logs.extreme().error((Object)e, (Throwable)e);
                return super.handleException(e);
            }

            @Override
            public boolean isRecoverable() {
                return true;
            }
        };


        public boolean isRecoverable() {
            return false;
        }

        public RuntimeException handleException(RuntimeException e) {
            String msg = "[" + this.name() + ("] Persistence error occurred because of: " + e.getMessage());
            Logs.exhaust().error((Object)msg, (Throwable)e);
            return e;
        }
    }
}

