/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DatabaseInfo;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.annotation.DatabaseNamingStrategy;
import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.PersistenceContextDiscovery;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.Strings;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicStampedReference;
import javax.annotation.Nullable;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.EntityManagerFactoryImpl;

public class PersistenceContexts {
    private static Logger LOG = Logger.getLogger(PersistenceContexts.class);
    private static Long MAX_FAIL_SECONDS = 60L;
    private static final int MAX_EMF_RETRIES = 20;
    private static AtomicStampedReference<Long> failCount = new AtomicStampedReference<Long>(0L, 0);
    private static final ArrayListMultimap<String, Class> entities = ArrayListMultimap.create();
    private static final ArrayListMultimap<String, Class> remotableEntities = ArrayListMultimap.create();
    private static final List<Class> sharedEntities = Lists.newArrayList();
    private static Map<String, EntityManagerFactoryImpl> emf = new ConcurrentSkipListMap<String, EntityManagerFactoryImpl>();
    private static Multimap<String, Exception> illegalAccesses = ArrayListMultimap.create();

    public static boolean isPersistentClass(Class candidate) {
        return PersistenceContexts.isSharedEntityClass(candidate) || PersistenceContexts.isEntityClass(candidate);
    }

    public static boolean isSharedEntityClass(Class candidate) {
        return Ats.from(candidate).has(MappedSuperclass.class) || Ats.from(candidate).has(Embeddable.class);
    }

    private static boolean isRemotable(Class entity) {
        return Ats.from(entity).has(RemotablePersistence.class);
    }

    public static boolean isEntityClass(Class candidate) {
        if (Ats.from(candidate).has(Entity.class)) {
            if (!Ats.from(candidate).has(PersistenceContext.class)) {
                throw Exceptions.toUndeclared((String)("Database entity does not have required @PersistenceContext annotation: " + candidate.getCanonicalName()), (Throwable[])new Throwable[0]);
            }
            return true;
        }
        return false;
    }

    public static DatabaseNamingStrategy getNamingStrategy(String context) {
        DatabaseNamingStrategy strategy = DatabaseNamingStrategy.defaultStrategy();
        try {
            ComponentId componentId = ComponentIds.lookup(Strings.trimPrefix("eucalyptus_", context));
            strategy = componentId.getDatabaseNamingStrategy();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return DatabaseNamingStrategy.overrideStrategy(strategy);
    }

    public static Function<String, String> toDatabaseName() {
        return PersistenceContextStringFunctions.CONTEXT_TO_DATABASE;
    }

    public static Function<String, String> toSchemaName() {
        return PersistenceContextStringFunctions.CONTEXT_TO_SCHEMA;
    }

    static void addEntity(Class entity) {
        if (!PersistenceContexts.isDuplicate(entity)) {
            String ctxName = Ats.from(entity).get(PersistenceContext.class).name();
            EventRecord.here(PersistenceContextDiscovery.class, EventType.PERSISTENCE_ENTITY_REGISTERED, ctxName, entity.getCanonicalName()).trace();
            if (PersistenceContexts.isRemotable(entity)) {
                remotableEntities.put((Object)ctxName, (Object)entity);
            } else {
                entities.put((Object)ctxName, (Object)entity);
            }
        }
    }

    static void addSharedEntity(Class entity) {
        if (!PersistenceContexts.isDuplicate(entity)) {
            EventRecord.here(PersistenceContextDiscovery.class, EventType.PERSISTENCE_ENTITY_REGISTERED, "shared", entity.getCanonicalName()).trace();
            sharedEntities.add(entity);
        }
    }

    private static boolean isDuplicate(Class entity) {
        PersistenceContext ctx = Ats.from(entity).get(PersistenceContext.class);
        if (Ats.from(entity).has(MappedSuperclass.class) || Ats.from(entity).has(Embeddable.class)) {
            return false;
        }
        if (ctx == null || ctx.name() == null) {
            RuntimeException ex = new RuntimeException("Failed to register broken entity class: " + entity.getCanonicalName() + ".  Ensure that the class has a well-formed @PersistenceContext annotation.");
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
        if (sharedEntities.contains(entity)) {
            Class old = sharedEntities.get(sharedEntities.indexOf(entity));
            LOG.error((Object)("Duplicate entity definition detected: " + entity.getCanonicalName()));
            LOG.error((Object)("=> OLD: " + old.getProtectionDomain().getCodeSource().getLocation()));
            LOG.error((Object)("=> NEW: " + entity.getProtectionDomain().getCodeSource().getLocation()));
            throw BootstrapException.throwFatal("Duplicate entity definition in shared entities: " + entity.getCanonicalName() + ". See error logs for details.");
        }
        if (entities.get((Object)ctx.name()) != null && entities.get((Object)ctx.name()).contains(entity)) {
            List context = entities.get((Object)ctx.name());
            Class old = (Class)context.get(context.indexOf(entity));
            LOG.error((Object)("Duplicate entity definition detected: " + entity.getCanonicalName()));
            LOG.error((Object)("=> OLD: " + old.getProtectionDomain().getCodeSource().getLocation()));
            LOG.error((Object)("=> NEW: " + entity.getProtectionDomain().getCodeSource().getLocation()));
            throw BootstrapException.throwFatal("Duplicate entity definition in '" + ctx.name() + "': " + entity.getCanonicalName() + ". See error logs for details.");
        }
        return false;
    }

    public static EntityManagerFactoryImpl registerPersistenceContext(String persistenceContext, Ejb3Configuration config) {
        if (!emf.containsKey(persistenceContext)) {
            try {
                LOG.trace((Object)("-> Setting up persistence context for: " + persistenceContext));
                EntityManagerFactoryImpl entityManagerFactory = (EntityManagerFactoryImpl)config.buildEntityManagerFactory();
                LOG.trace((Object)LogUtil.subheader(LogUtil.dumpObject(config)));
                emf.put(persistenceContext, entityManagerFactory);
                LOG.info((Object)("-> Setup done for persistence context: " + persistenceContext));
            }
            catch (Exception ex) {
                LOG.error((Object)("-> Error in persistence context setup: " + persistenceContext), (Throwable)ex);
            }
        }
        return emf.get(persistenceContext);
    }

    public static void flush(String ctx) {
        emf.get(ctx).getCache().evictAll();
    }

    public static void deregisterPersistenceContext(String persistenceContext) {
        if (!emf.containsKey(persistenceContext)) {
            return;
        }
        EntityManagerFactoryImpl emfactory = emf.remove(persistenceContext);
        if (emfactory != null && emfactory.isOpen()) {
            try {
                if (emfactory.getCache() != null) {
                    emfactory.getCache().evictAll();
                }
                emfactory.close();
                LOG.info((Object)("Closed entity manager factory for " + persistenceContext));
            }
            catch (Exception ex) {
                LOG.warn((Object)"Failed to close entity manager factory", (Throwable)ex);
            }
        }
    }

    public static List<String> list() {
        ArrayList persistences = Lists.newArrayList((Iterable)entities.keySet());
        return persistences;
    }

    public static List<String> listRemotable() {
        return Lists.newArrayList((Iterable)remotableEntities.keySet());
    }

    public static boolean remoteConnected() {
        for (String remoteContext : PersistenceContexts.listRemotable()) {
            if (!emf.containsKey(remoteContext)) continue;
            return true;
        }
        return false;
    }

    public static String toRemoteDatabaseName(String persistenceContext) {
        if ("localhost".equals(DatabaseInfo.getDatabaseInfo().getAppendOnlyHost())) {
            return (String)PersistenceContexts.toDatabaseName().apply((Object)persistenceContext);
        }
        return persistenceContext;
    }

    public static String toRemoteSchemaName(String persistenceContext) {
        if ("localhost".equals(DatabaseInfo.getDatabaseInfo().getAppendOnlyHost())) {
            return (String)PersistenceContexts.toSchemaName().apply((Object)persistenceContext);
        }
        return null;
    }

    public static List<Class> listEntities(String persistenceContext) {
        ArrayList ctxEntities = Lists.newArrayList();
        if (entities.containsKey((Object)persistenceContext)) {
            ctxEntities.addAll(Lists.newArrayList((Iterable)entities.get((Object)persistenceContext)));
        }
        if (remotableEntities.containsKey((Object)persistenceContext)) {
            ctxEntities.addAll(Lists.newArrayList((Iterable)remotableEntities.get((Object)persistenceContext)));
        }
        Collections.sort(ctxEntities, Ordering.usingToString());
        return ctxEntities;
    }

    private static void touchDatabase() {
        long failInterval = System.currentTimeMillis() - failCount.getReference();
        if (MAX_FAIL_SECONDS * 1000L > failInterval) {
            LOG.fatal((Object)LogUtil.header("Database connection failure time limit reached (" + MAX_FAIL_SECONDS + " seconds):  HUPping the system."));
        } else if (failCount.getStamp() > 0) {
            LOG.warn((Object)("Found database connection errors: # " + failCount.getStamp() + " over the last " + failInterval + " seconds."));
        }
    }

    public static EntityManagerFactoryImpl getEntityManagerFactory(String persistenceContext) {
        PersistenceContextEventInterceptorDiscovery.dispatcher().onLookup();
        if (emf.containsKey(persistenceContext)) {
            return emf.get(persistenceContext);
        }
        for (int i = 0; i < 20; ++i) {
            if (emf.containsKey(persistenceContext)) {
                return emf.get(persistenceContext);
            }
            Exceptions.trace(persistenceContext + ": Persistence context has not been configured yet." + " (see debug logs for details)" + "\nThe available contexts are: \n" + Joiner.on((String)"\n").join(emf.keySet()));
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                throw Exceptions.toUndeclared(Exceptions.maybeInterrupted(ex));
            }
        }
        throw Exceptions.error("Failed to lookup persistence context after 20 tries.\n");
    }

    public static void shutdown() {
        for (String ctx : emf.keySet()) {
            EntityManagerFactoryImpl em = emf.remove(ctx);
            if (em.isOpen()) {
                LOG.info((Object)("Closing persistence context: " + ctx));
                em.close();
                continue;
            }
            LOG.info((Object)("Closing persistence context: " + ctx + " (found it closed already)"));
        }
    }

    private static enum PersistenceContextStringFunctions implements Function<String, String>
    {
        CONTEXT_TO_DATABASE{

            @Nullable
            public String apply(@Nullable String context) {
                return PersistenceContexts.getNamingStrategy(context).getDatabaseName(context);
            }
        }
        ,
        CONTEXT_TO_SCHEMA{

            @Nullable
            public String apply(@Nullable String context) {
                return PersistenceContexts.getNamingStrategy(context).getSchemaName(context);
            }
        };

    }

    public static class PersistenceContextEventInterceptorDiscovery
    extends ServiceJarDiscovery {
        static final List<PersistenceContextEventInterceptor> interceptors = new CopyOnWriteArrayList<PersistenceContextEventInterceptor>();
        static final PersistenceContextEventInterceptor dispatcher = new PersistenceContextEventInterceptor(){

            @Override
            public void onLookup() {
                for (PersistenceContextEventInterceptor interceptor : interceptors) {
                    interceptor.onLookup();
                }
            }

            @Override
            public void onConnectionError() {
                for (PersistenceContextEventInterceptor interceptor : interceptors) {
                    interceptor.onConnectionError();
                }
            }
        };

        static PersistenceContextEventInterceptor dispatcher() {
            return dispatcher;
        }

        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (PersistenceContextEventInterceptor.class.isAssignableFrom(candidate) && Modifier.isPublic(candidate.getModifiers())) {
                interceptors.add((PersistenceContextEventInterceptor)candidate.newInstance());
                return true;
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 1.0;
        }
    }

    public static interface PersistenceContextEventInterceptor {
        public void onLookup();

        public void onConnectionError();
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.PersistenceInit)
    public static class PersistenceContextBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            Groovyness.run("setup_persistence.groovy");
            return true;
        }
    }
}

