/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class Interceptors {
    private static Logger LOG = Logger.getLogger(Interceptors.class);
    private static Boolean TRANSACTION_INTERCEPT = Boolean.FALSE;
    private static Interceptor interceptor = Interceptors.get();

    private static final Table stringify(Object[] state, String[] propertyNames, Type[] types) {
        return HashBasedTable.create();
    }

    private static Interceptor empty() {
        if (interceptor != null && interceptor instanceof EmptyInterceptor) {
            return interceptor;
        }
        EmptyInterceptor i = new EmptyInterceptor(){
            private static final long serialVersionUID = 1L;
        };
        if (interceptor != null && !(interceptor instanceof EmptyInterceptor)) {
            interceptor = i;
        }
        return i;
    }

    private static Interceptor logger() {
        if (interceptor != null && interceptor instanceof LogMonitorInterceptor) {
            return interceptor;
        }
        LogMonitorInterceptor i = new LogMonitorInterceptor();
        if (interceptor != null && !(interceptor instanceof LogMonitorInterceptor)) {
            interceptor = i;
        }
        return i;
    }

    static Interceptor get() {
        return TRANSACTION_INTERCEPT != false ? Interceptors.logger() : Interceptors.empty();
    }

    private static final class LogMonitorInterceptor
    extends EmptyInterceptor {
        private static final long serialVersionUID = 1L;
        private int operations = 0;

        private LogMonitorInterceptor() {
        }

        private String toStringNullably(Object o) {
            try {
                return o != null ? "" + o.toString() : "null";
            }
            catch (Exception ex) {
                return o.getClass().getCanonicalName() + ".toString(): " + ex.getMessage();
            }
        }

        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, entity.getClass().getSimpleName(), id, this.toStringNullably(entity)));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.onDelete(entity, id, state, propertyNames, types);
        }

        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, entity.getClass().getSimpleName(), id, this.toStringNullably(entity)));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        }

        public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, entity.getClass().getSimpleName(), id));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.onLoad(entity, id, state, propertyNames, types);
        }

        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, entity.getClass().getSimpleName(), id, this.toStringNullably(entity)));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.onSave(entity, id, state, propertyNames, types);
        }

        public void postFlush(Iterator entities) {
            try {
                if (Logs.isExtrrreeeme()) {
                    Logs.exhaust().debug((Object)String.format("%s():%d %s", Threads.currentStackFrame().getMethodName(), this.operations, Iterators.transform((Iterator)entities, Classes.simpleNameFunction())));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.postFlush(entities);
        }

        public void preFlush(Iterator entities) {
            try {
                if (Logs.isExtrrreeeme()) {
                    Logs.exhaust().debug((Object)String.format("%s():%d %s", Threads.currentStackFrame().getMethodName(), this.operations, Iterators.transform((Iterator)entities, Classes.simpleNameFunction())));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.preFlush(entities);
        }

        public Boolean isTransient(Object entity) {
            return super.isTransient(entity);
        }

        public void afterTransactionBegin(Transaction tx) {
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = Threads.currentStackFrame().getMethodName();
                this.operations = 0;
                objectArray[1] = 0;
                objectArray[2] = tx.toString();
                LOG.debug((Object)String.format("%s():%d %s", objectArray));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.afterTransactionBegin(tx);
        }

        public void afterTransactionCompletion(Transaction tx) {
            try {
                LOG.debug((Object)String.format("%s():%d %s", Threads.currentStackFrame().getMethodName(), this.operations, tx.toString()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.afterTransactionCompletion(tx);
        }

        public void beforeTransactionCompletion(Transaction tx) {
            if (this.operations == 0) {
                LOG.error((Object)Threads.currentStackString());
            }
            try {
                LOG.debug((Object)String.format("%s():%d %s", Threads.currentStackFrame().getMethodName(), this.operations, tx.toString()));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.beforeTransactionCompletion(tx);
        }

        public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
            try {
                Iterable iter = collection instanceof Iterable ? (Iterable)collection : Lists.newArrayList((Object[])new Object[]{collection});
                String summary = Iterables.toString((Iterable)Iterables.transform((Iterable)iter, Classes.canonicalNameFunction()));
                if (Logs.isExtrrreeeme()) {
                    Logs.exhaust().debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, key, summary));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.onCollectionRemove(collection, key);
        }

        public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
            try {
                Iterable iter = collection instanceof Iterable ? (Iterable)collection : Lists.newArrayList((Object[])new Object[]{collection});
                String summary = Iterables.toString((Iterable)Iterables.transform((Iterable)iter, Classes.canonicalNameFunction()));
                if (Logs.isExtrrreeeme()) {
                    Logs.exhaust().debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, key, summary));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.onCollectionRecreate(collection, key);
        }

        public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
            try {
                Iterable iter = collection instanceof Iterable ? (Iterable)collection : Lists.newArrayList((Object[])new Object[]{collection});
                String summary = Iterables.toString((Iterable)Iterables.transform((Iterable)iter, Classes.canonicalNameFunction()));
                LOG.debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, key, summary));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            super.onCollectionUpdate(collection, key);
        }

        public Object instantiate(String entityName, EntityMode entityMode, Serializable id) {
            try {
                LOG.debug((Object)String.format("%s():%d", Threads.currentStackFrame().getMethodName(), ++this.operations));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.instantiate(entityName, entityMode, id);
        }

        public String getEntityName(Object object) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, object.getClass().getSimpleName(), this.toStringNullably(object)));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.getEntityName(object);
        }

        public Object getEntity(String entityName, Serializable id) {
            try {
                LOG.debug((Object)String.format("%s():%d %s %s", Threads.currentStackFrame().getMethodName(), ++this.operations, entityName, id));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            return super.getEntity(entityName, id);
        }
    }
}

