/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.auth.policy.PolicyResourceType;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.FullName;
import org.apache.log4j.Logger;

public abstract class GlobalUserMetadata<STATE extends Enum<STATE>>
extends UserMetadata<STATE> {
    private static Logger LOG = Logger.getLogger(GlobalUserMetadata.class);
    private final Class<? extends ComponentId> serviceComponentClass;
    private final String serviceName;
    private final String regionName;
    private final String resourceTypeName;

    public GlobalUserMetadata(Class<? extends ComponentId> serviceComponentClass) {
        this.serviceComponentClass = serviceComponentClass;
        ComponentId serviceComponent = ComponentIds.lookup(serviceComponentClass);
        this.serviceName = serviceComponent.getVendorName();
        this.regionName = serviceComponent.name();
        Ats ats = Ats.from(this);
        if (ats.has(PolicyResourceType.class)) {
            this.resourceTypeName = ats.get(PolicyResourceType.class).value();
        } else {
            LOG.debug((Object)("HACK:  type is missing the resource type information in a @PolicyResourceType: " + this.getClass()));
            this.resourceTypeName = this.getClass().getSimpleName().toLowerCase();
        }
    }

    @Override
    public String getPartition() {
        return ComponentIds.lookup(Eucalyptus.class).name();
    }

    @Override
    public FullName getFullName() {
        return FullName.create.vendor(this.serviceName).region(this.getPartition()).accountId(this.getOwnerAccountNumber()).relativeId(this.resourceTypeName, this.getDisplayName());
    }
}

