/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class EntityCache<E extends AbstractPersistent, TE extends Comparable<TE>>
implements Supplier<Iterable<TE>> {
    private static final int batchSize = 500;
    private final E example;
    private final Function<? super E, TE> transformFunction;
    private final ConcurrentMap<Pair<String, Integer>, TE> cache = Maps.newConcurrentMap();

    public EntityCache(E example, Function<? super E, TE> transformFunction) {
        this.example = example;
        this.transformFunction = transformFunction;
    }

    private List<Pair<String, Integer>> loadVersionMap() {
        try (TransactionResource db = Entities.transactionFor(this.example);){
            List idVersionList = Entities.createCriteria(this.example.getClass()).add((Criterion)Example.create(this.example)).setReadOnly(true).setCacheable(false).setFetchSize(1000).setProjection((Projection)Projections.projectionList().add((Projection)Projections.id()).add((Projection)Projections.property((String)"version"))).list();
            ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)idVersionList, (Function)ObjectArrayToStringIntPair.INSTANCE));
            return arrayList;
        }
    }

    private void refresh() {
        List<Pair<String, Integer>> currentKeys = this.loadVersionMap();
        this.cache.keySet().retainAll(currentKeys);
        currentKeys.removeAll(this.cache.keySet());
        for (List keyBatch : Iterables.partition(currentKeys, (int)500)) {
            TransactionResource db = Entities.transactionFor(this.example);
            Throwable throwable = null;
            try {
                List entities = Entities.createCriteria(this.example.getClass()).add((Criterion)Example.create(this.example)).setReadOnly(true).setCacheable(false).setFetchSize(500).add(Restrictions.in((String)"id", (Collection)Lists.newArrayList((Iterable)Iterables.transform((Iterable)keyBatch, Pair.left())))).list();
                for (AbstractPersistent entity : entities) {
                    this.cache.put(Pair.pair(this.getId(entity), entity.getVersion()), this.transformFunction.apply((Object)entity));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (db == null) continue;
                if (throwable != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                db.close();
            }
        }
    }

    public Iterable<TE> get() {
        this.refresh();
        return Ordering.natural().sortedCopy(this.cache.values());
    }

    private String getId(E entity) {
        return Objects.toString(Entities.resolvePrimaryKey(entity));
    }

    private static enum ObjectArrayToStringIntPair implements Function<Object[], Pair<String, Integer>>
    {
        INSTANCE;


        public Pair<String, Integer> apply(Object[] objects) {
            return Pair.pair(String.valueOf(objects[0]), ((Number)objects[1]).intValue());
        }
    }
}

